/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.factory;

import java.rmi.RemoteException;
import java.util.Calendar;
import javax.naming.InitialContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.usefulrp.ServiceMetaDataResourceProperty;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.CreateReliableFileTransferInputType;
import org.globus.rft.generated.CreateReliableFileTransferOutputType;
import org.globus.rft.generated.DelegationEPRMissingFaultType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.transfer.reliable.service.MyPerformanceLog;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.ReliableFileTransferHome;
import org.globus.transfer.reliable.service.factory.ActiveResourceInstancesRP;
import org.globus.transfer.reliable.service.factory.DelegationServiceEndpoint;
import org.globus.transfer.reliable.service.factory.RFTFactoryStartTime;
import org.globus.transfer.reliable.service.factory.TotalNumberOfActiveTransfers;
import org.globus.transfer.reliable.service.factory.TotalNumberOfBytesTransferred;
import org.globus.transfer.reliable.service.factory.TotalNumberOfTransfersRP;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.servicegroup.client.MDSConfiguration;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.AddressingUtils;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.lifetime.UnableToSetTerminationTimeFaultType;

public class ReliableFileTransferFactoryService
implements Resource,
ResourceProperties {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService == null ? (class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService = ReliableFileTransferFactoryService.class$("org.globus.transfer.reliable.service.factory.ReliableFileTransferFactoryService")) : class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService == null ? (class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService = ReliableFileTransferFactoryService.class$("org.globus.transfer.reliable.service.factory.ReliableFileTransferFactoryService")) : class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService).getClassLoader());
    private ResourcePropertySet resourcePropertySet = new SimpleResourcePropertySet(RFTConstants.RFT_RP_SET);
    private TotalNumberOfTransfersRP totalTransfersRP;
    private ActiveResourceInstancesRP activeResourcesRP;
    private DelegationServiceEndpoint delegationEndpoint;
    private RFTFactoryStartTime rftFactoryStartTime;
    private TotalNumberOfActiveTransfers totalNumberOfActiveTransfers;
    private TotalNumberOfBytesTransferred totalNumberOfBytesTransferred;
    private ServiceMetaDataResourceProperty metadata;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$factory$ReliableFileTransferFactoryService;

    public ReliableFileTransferFactoryService() {
        try {
            this.totalTransfersRP = new TotalNumberOfTransfersRP(RFTConstants.TOTAL_TRANSFER_COUNT_FACTORY);
            this.activeResourcesRP = new ActiveResourceInstancesRP(RFTConstants.ACTIVE_RESOURCE_COUNT_FACTORY);
            this.delegationEndpoint = DelegationServiceEndpoint.getInstance();
            this.rftFactoryStartTime = new RFTFactoryStartTime(RFTConstants.RFT_FACTORY_START_TIME);
            this.totalNumberOfActiveTransfers = new TotalNumberOfActiveTransfers(RFTConstants.TOTAL_ACTIVE_TRANSFERS_FACTORY);
            this.totalNumberOfBytesTransferred = new TotalNumberOfBytesTransferred(RFTConstants.TOTAL_BYTES_FACTORY);
            this.resourcePropertySet.add((ResourceProperty)this.totalTransfersRP);
            this.resourcePropertySet.add((ResourceProperty)this.activeResourcesRP);
            this.resourcePropertySet.add((ResourceProperty)this.delegationEndpoint);
            this.resourcePropertySet.add((ResourceProperty)this.rftFactoryStartTime);
            this.resourcePropertySet.add((ResourceProperty)this.totalNumberOfActiveTransfers);
            this.resourcePropertySet.add((ResourceProperty)this.totalNumberOfBytesTransferred);
            try {
                this.metadata = new ServiceMetaDataResourceProperty();
                this.resourcePropertySet.add((ResourceProperty)this.metadata);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to add ServiceMetaData RP");
            }
            InitialContext ctx = new InitialContext();
            String config = "java:comp/env//services/ReliableFileTransferFactoryService/mdsConfiguration";
            MDSConfiguration mdsConfiguration = (MDSConfiguration)ctx.lookup(config);
            if (mdsConfiguration.getRegAsBoolean()) {
                logger.debug((Object)i18n.getMessage("mdsEnabled"));
                this.registerToMDS();
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)i18n.getMessage("mdsSuppressed"));
            }
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("factoryCreateErr"), (Throwable)e);
        }
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.resourcePropertySet;
    }

    public CreateReliableFileTransferOutputType createReliableFileTransfer(CreateReliableFileTransferInputType input) throws RemoteException, BaseFaultType {
        Calendar currentTime;
        MyPerformanceLog perf = new MyPerformanceLog("RFT create resource (complete)");
        if (logger.isDebugEnabled()) {
            perf.start();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PerformanceLog createReliableFileTransfer() enter");
        }
        Calendar requestedTermTime = input.getInitialTerminationTime();
        Calendar initTermTime = currentTime = Calendar.getInstance();
        if (requestedTermTime == null) {
            initTermTime = null;
        } else if (!requestedTermTime.getTime().before(currentTime.getTime())) {
            initTermTime = requestedTermTime;
        } else {
            throw new UnableToSetTerminationTimeFaultType();
        }
        CreateReliableFileTransferOutputType response = new CreateReliableFileTransferOutputType();
        response.setCurrentTime(currentTime);
        response.setNewTerminationTime(initTermTime);
        TransferRequestType transferRequestBase = input.getTransferRequest();
        if (transferRequestBase == null) {
            transferRequestBase = input.getDeleteRequest();
        }
        if (transferRequestBase == null) {
            throw new RemoteException(i18n.getMessage("nullRequestErr"));
        }
        this.activeResourcesRP.addInstance();
        if (transferRequestBase instanceof DeleteRequestType) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Got a delete request");
            }
        } else if (transferRequestBase instanceof TransferRequestType) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Got a transfer request");
            }
            TransferRequestType tempReq = transferRequestBase;
            int size = tempReq.getTransfer().length;
            this.totalTransfersRP.addTransfers(size);
        }
        if (transferRequestBase.getTransferCredentialEndpoint() == null) {
            logger.error((Object)"DelegationEPR is missing from request");
            throw new DelegationEPRMissingFaultType();
        }
        EndpointReferenceType epr = new EndpointReferenceType();
        SecurityManager securityManager = SecurityManager.getManager();
        String userSubject = securityManager.getCaller();
        String localUserId = securityManager.getLocalUsernames()[0];
        ReliableFileTransferHome reliableHome = null;
        SimpleResourceKey key = null;
        int requestId = 0;
        try {
            InitialContext ctx = new InitialContext();
            String lookupString = "java:comp/env//services/ReliableFileTransferService/home";
            reliableHome = (ReliableFileTransferHome)((Object)ctx.lookup(lookupString));
            key = reliableHome.create(currentTime, requestedTermTime, (BaseRequestType)transferRequestBase, userSubject, localUserId);
            requestId = Integer.parseInt((String)key.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PerformanceLog created RFTresource with RequestID:" + requestId));
            }
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("resourceCreateErr"), (Throwable)e);
            throw new RemoteException(i18n.getMessage("resourceCreateErr"), e);
        }
        try {
            epr = AddressingUtils.createEndpointReference((String)(ServiceHost.getBaseURL() + "ReliableFileTransferService"), (ResourceKey)key);
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("resourceCreateErr"), (Throwable)e);
            throw new RemoteException(i18n.getMessage("resourceCreateErr"), e);
        }
        response.setReliableTransferEPR(epr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PerformanceLog exit createReliableFileTransfer() for :" + requestId));
        }
        if (logger.isDebugEnabled()) {
            perf.stop();
        }
        return response;
    }

    void registerToMDS() {
        try {
            EndpointReferenceType epr = AddressingUtils.createEndpointReference(null);
            ServiceGroupRegistrationClient.register((EndpointReferenceType)epr, (String)"/etc/globus_wsrf_rft/registration.xml");
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("mdsRegErr"), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

