/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.DeleteOptionsType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.DeleteType;
import org.globus.rft.generated.OverallStatus;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.rft.generated.TransferRequestType;
import org.globus.rft.generated.TransferStatusType;
import org.globus.rft.generated.TransferType;
import org.globus.transfer.reliable.service.RFTRecoveryData;
import org.globus.transfer.reliable.service.RFTUtil;
import org.globus.transfer.reliable.service.database.RFTDatabaseSetup;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.util.I18n;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;

public class ReliableFileTransferDbAdapter {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter == null ? (class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter = ReliableFileTransferDbAdapter.class$("org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter")) : class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter).getName());
    private static ReliableFileTransferDbAdapter dbAdapter = new ReliableFileTransferDbAdapter();
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter == null ? (class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter = ReliableFileTransferDbAdapter.class$("org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter")) : class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter).getClassLoader());
    private static RFTOptionsType globalRFTOptions = new RFTOptionsType();
    private static boolean OLD_SCHEMA = false;
    private static final String activeRequestIdSQL = "SELECT id from request where termination_time > ? and started=? ";
    private static final String requestInsertSQL = "INSERT INTO request(id,concurrency,termination_time,all_or_none,maxattempts,username,started,delegated_epr,user_subject) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String requestInsertSQL_OLD = "INSERT INTO request(concurrency,termination_time,all_or_none,maxattempts,username,started,delegated_epr,user_subject) VALUES (?,?,?,?,?,?,?,?)";
    private static final String transferInsertSQL = "INSERT INTO transfer(id, request_id,source_url,dest_url,user_name,dcau,parallel_streams,tcp_buffer_size,block_size,notpt,binary_mode,source_subject,dest_subject,ignore_file_perm_errors) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String transferInsertSQL_OLD = "INSERT INTO transfer(request_id,source_url,dest_url,user_name,dcau,parallel_streams,tcp_buffer_size,block_size,notpt,binary_mode,source_subject,dest_subject,ignore_file_perm_errors) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String updateStartedQuery = "UPDATE request set started = ? where id = ? ";
    private static final String deleteInsertQuery = "INSERT INTO transfer(id,request_id,source_subject,source_url,status,user_name) VALUES(?,?,?,?,?,?)";
    private static final String deleteInsertQuery_OLD = "INSERT INTO transfer(request_id,source_subject,source_url,status,user_name) VALUES(?,?,?,?,?)";
    private static final String singleTransferInsertQuery = "INSERT INTO transfer(id,request_id,source_url,dest_url,status,user_name,dcau,parallel_streams,tcp_buffer_size,block_size,notpt,binary_mode,source_subject,dest_subject) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String singleTransferInsertQuery_OLD = "INSERT INTO transfer(request_id,source_url,dest_url,status,user_name,dcau,parallel_streams,tcp_buffer_size,block_size,notpt,binary_mode,source_subject,dest_subject) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$database$ReliableFileTransferDbAdapter;

    private ReliableFileTransferDbAdapter() {
    }

    public static ReliableFileTransferDbAdapter setup() throws RftDBException, RftException {
        RFTDatabaseSetup.setup();
        ReliableFileTransferDbAdapter.setSchemaVersion();
        return dbAdapter;
    }

    public static ReliableFileTransferDbAdapter getDbAdapter() {
        return dbAdapter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int storeTransferRequest(TransferRequestType request, Calendar terminationTime, String username, String userSubject) throws RftDBException {
        int n;
        int requestId = 0;
        int concurrency = 1;
        Integer tempConcurrency = request.getConcurrency();
        if (tempConcurrency != null && tempConcurrency > 0) {
            concurrency = tempConcurrency;
        }
        Boolean allOrNone = Boolean.FALSE;
        if (request.getAllOrNone() != null) {
            allOrNone = request.getAllOrNone();
        }
        QName qName = new QName("", "DelegatedEPR");
        Connection c = null;
        Statement pstmt = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                boolean flag;
                String delegationEPRString = ObjectSerializer.toString((Object)request.getTransferCredentialEndpoint(), (QName)qName);
                c = RFTDatabaseSetup.getDBConnection();
                if (!OLD_SCHEMA) {
                    pstmt = c.prepareStatement(requestInsertSQL);
                    requestId = this.getNextRequestId(c);
                    pstmt.setObject(1, new Integer(requestId));
                    pstmt.setObject(2, new Integer(concurrency));
                    pstmt.setObject(3, new Long(terminationTime.getTimeInMillis()));
                    pstmt.setObject(4, allOrNone);
                    if (request.getMaxAttempts() == null) {
                        pstmt.setObject(5, new Integer(1));
                    } else {
                        pstmt.setObject(5, request.getMaxAttempts());
                    }
                    pstmt.setObject(6, username);
                    pstmt.setObject(7, new Boolean("false"));
                    pstmt.setObject(8, delegationEPRString);
                    pstmt.setObject(9, userSubject);
                    flag = pstmt.execute();
                } else {
                    pstmt = c.prepareStatement(requestInsertSQL_OLD);
                    pstmt.setObject(1, new Integer(concurrency));
                    pstmt.setObject(2, new Long(terminationTime.getTimeInMillis()));
                    pstmt.setObject(3, allOrNone);
                    pstmt.setObject(4, request.getMaxAttempts());
                    pstmt.setObject(5, username);
                    pstmt.setObject(6, new Boolean("false"));
                    pstmt.setObject(7, delegationEPRString);
                    pstmt.setObject(8, userSubject);
                    flag = pstmt.execute();
                    statement = c.createStatement();
                    rs = statement.executeQuery("select last_value from request_seq");
                    while (rs != null && rs.next()) {
                        requestId = rs.getInt(1);
                    }
                }
                this.storeTransfers(requestId, request, c);
                n = requestId;
                Object var17_18 = null;
            }
            catch (SQLException e) {
                throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
            }
            catch (SerializationException se) {
                throw new RftDBException(i18n.getMessage("serializationErr"), (Exception)((Object)se));
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c == null) throw throwable;
                RFTDatabaseSetup.returnDBConnection(c);
                throw throwable;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sql) {
            logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            return n;
        }
        if (pstmt != null) {
            pstmt.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (c == null) return n;
        RFTDatabaseSetup.returnDBConnection(c);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int storeDeleteRequest(DeleteRequestType request, Calendar terminationTime, String username, String userSubject) throws RftDBException {
        int n;
        int requestId = 0;
        int concurrency = 1;
        Integer tempConcurrency = request.getConcurrency();
        if (tempConcurrency != null && tempConcurrency > 0) {
            concurrency = tempConcurrency;
        }
        QName qName = new QName("", "DelegatedEPR");
        Connection c = null;
        Statement pstmt = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                boolean flag;
                String delegationEPRString = ObjectSerializer.toString((Object)request.getTransferCredentialEndpoint(), (QName)qName);
                c = RFTDatabaseSetup.getDBConnection();
                if (!OLD_SCHEMA) {
                    pstmt = c.prepareStatement(requestInsertSQL);
                    requestId = this.getNextRequestId(c);
                    pstmt.setObject(1, new Integer(requestId));
                    pstmt.setObject(2, new Integer(concurrency));
                    pstmt.setObject(3, new Long(terminationTime.getTimeInMillis()));
                    pstmt.setObject(4, new Boolean(false));
                    pstmt.setObject(5, request.getMaxAttempts());
                    pstmt.setObject(6, username);
                    pstmt.setObject(7, new Boolean("false"));
                    pstmt.setObject(8, delegationEPRString);
                    pstmt.setObject(9, userSubject);
                    flag = pstmt.execute();
                } else {
                    pstmt = c.prepareStatement(requestInsertSQL_OLD);
                    pstmt.setObject(1, new Integer(concurrency));
                    pstmt.setObject(2, new Long(terminationTime.getTimeInMillis()));
                    pstmt.setObject(3, new Boolean(false));
                    pstmt.setObject(4, request.getMaxAttempts());
                    pstmt.setObject(5, username);
                    pstmt.setObject(6, new Boolean("false"));
                    pstmt.setObject(7, delegationEPRString);
                    pstmt.setObject(8, userSubject);
                    flag = pstmt.execute();
                    statement = c.createStatement();
                    rs = statement.executeQuery("select last_value from request_seq");
                    while (rs != null && rs.next()) {
                        requestId = rs.getInt(1);
                    }
                }
                this.storeDelete(requestId, request, c);
                n = requestId;
                Object var16_17 = null;
            }
            catch (SQLException e) {
                throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
            }
            catch (SerializationException se) {
                throw new RftDBException(i18n.getMessage("serializationErr"), (Exception)((Object)se));
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c == null) throw throwable;
                RFTDatabaseSetup.returnDBConnection(c);
                throw throwable;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                throw throwable;
            }
        }
        try {}
        catch (SQLException sql) {
            logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            return n;
        }
        if (pstmt != null) {
            pstmt.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (c == null) return n;
        RFTDatabaseSetup.returnDBConnection(c);
        return n;
    }

    /*
     * Loose catch block
     */
    public synchronized int getNextRequestId(Connection c) throws RftDBException {
        int nextRequestId;
        block14: {
            Statement statement = null;
            Statement tempStatement = null;
            ResultSet rs = null;
            nextRequestId = 0;
            statement = c.createStatement(1004, 1008);
            rs = statement.executeQuery("select request_id from requestid");
            if (!rs.next()) {
                tempStatement = c.createStatement();
                tempStatement.executeUpdate("insert into requestid values(" + ++nextRequestId + ")");
                logger.debug((Object)("updated row with : " + nextRequestId));
            } else {
                rs.previous();
                while (rs != null && rs.next()) {
                    nextRequestId = rs.getInt(1);
                    logger.debug((Object)("next request id: " + nextRequestId));
                    String updateQuery = "update requestid set request_id=";
                    updateQuery = updateQuery + ++nextRequestId;
                    tempStatement = c.createStatement();
                    tempStatement.executeUpdate(updateQuery);
                    logger.debug((Object)("updated row with : " + nextRequestId));
                }
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return nextRequestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void setSchemaVersion() throws RftDBException {
        block14: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            statement.executeQuery("Select * from requestid");
            Object var4_2 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql2) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql2);
            }
            break block14;
            {
                catch (SQLException sql) {
                    logger.info((Object)"Using 4.0 database schema");
                    OLD_SCHEMA = true;
                    Object var4_3 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (c != null) {
                            RFTDatabaseSetup.returnDBConnection(c);
                        }
                        break block14;
                    }
                    catch (SQLException sql2) {
                        logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql2) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized int getNextTransferId(Connection c) throws RftDBException {
        int nextTransferId;
        block14: {
            Statement statement = null;
            Statement tempStatement = null;
            ResultSet rs = null;
            nextTransferId = 0;
            statement = c.createStatement(1004, 1008);
            rs = statement.executeQuery("select transfer_id from transferid");
            if (!rs.next()) {
                StringBuffer query = new StringBuffer();
                query.append("insert into transferid(transfer_id) values (");
                query.append(++nextTransferId);
                query.append(")");
                tempStatement = c.createStatement();
                tempStatement.executeUpdate(query.toString());
            } else {
                rs.previous();
                while (rs != null && rs.next()) {
                    nextTransferId = rs.getInt(1);
                    tempStatement = c.createStatement();
                    tempStatement.executeUpdate("update transferid set transfer_id= " + ++nextTransferId);
                }
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return nextTransferId;
    }

    private int storeTransfers(int requestId, TransferRequestType transferRequest, Connection c) throws RftDBException {
        PreparedStatement pstmt;
        int returnInt = -1;
        try {
            TransferType[] transfers = transferRequest.getTransfer();
            RFTOptionsType localRFTOptions = transferRequest.getRftOptions();
            pstmt = OLD_SCHEMA ? c.prepareStatement(transferInsertSQL_OLD) : c.prepareStatement(transferInsertSQL);
            for (int i = 0; i < transfers.length; ++i) {
                String subjectName;
                RFTOptionsType rftOptions;
                TransferType transfer = transfers[i];
                if (transfer.getDestinationUrl().endsWith("/") && !transfer.getSourceUrl().endsWith("/")) {
                    transfer = this.updateDestinationUrl(transfer);
                }
                if ((rftOptions = transfer.getRftOptions()) == null) {
                    rftOptions = localRFTOptions != null ? localRFTOptions : globalRFTOptions;
                }
                if ((subjectName = rftOptions.getSubjectName()) != null && !subjectName.trim().equals("")) {
                    rftOptions.setSourceSubjectName(subjectName);
                    rftOptions.setDestinationSubjectName(subjectName);
                }
                if (OLD_SCHEMA) {
                    pstmt.setObject(1, new Integer(requestId));
                    pstmt.setObject(2, transfer.getSourceUrl());
                    pstmt.setObject(3, transfer.getDestinationUrl());
                    pstmt.setObject(4, rftOptions.getUserName());
                    pstmt.setObject(5, rftOptions.getDcau());
                    pstmt.setObject(6, rftOptions.getParallelStreams());
                    pstmt.setObject(7, rftOptions.getTcpBufferSize());
                    pstmt.setObject(8, rftOptions.getBlockSize());
                    pstmt.setObject(9, rftOptions.getNotpt());
                    pstmt.setObject(10, rftOptions.getBinary());
                    pstmt.setObject(11, rftOptions.getSourceSubjectName());
                    pstmt.setObject(12, rftOptions.getDestinationSubjectName());
                    pstmt.setObject(13, rftOptions.getIgnoreFilePermErr());
                } else {
                    int firstTransferId = this.getNextTransferId(c);
                    pstmt.setObject(1, new Integer(firstTransferId));
                    pstmt.setObject(2, new Integer(requestId));
                    pstmt.setObject(3, transfer.getSourceUrl());
                    pstmt.setObject(4, transfer.getDestinationUrl());
                    if (rftOptions.getUserName() == null) {
                        pstmt.setObject(5, "null");
                    } else {
                        pstmt.setObject(5, rftOptions.getUserName());
                    }
                    if (rftOptions.getDcau() == null) {
                        pstmt.setObject(6, new Boolean(true));
                    } else {
                        pstmt.setObject(6, rftOptions.getDcau());
                    }
                    if (rftOptions.getParallelStreams() == null) {
                        pstmt.setObject(7, new Integer(1));
                    } else {
                        pstmt.setObject(7, rftOptions.getParallelStreams());
                    }
                    if (rftOptions.getTcpBufferSize() == null) {
                        pstmt.setObject(8, new Integer(16384));
                    } else {
                        pstmt.setObject(8, rftOptions.getTcpBufferSize());
                    }
                    if (rftOptions.getBlockSize() == null) {
                        pstmt.setObject(9, new Integer(16384));
                    } else {
                        pstmt.setObject(9, rftOptions.getBlockSize());
                    }
                    if (rftOptions.getNotpt() == null) {
                        pstmt.setObject(10, new Boolean(false));
                    } else {
                        pstmt.setObject(10, rftOptions.getNotpt());
                    }
                    if (rftOptions.getBinary() == null) {
                        pstmt.setObject(11, new Boolean(true));
                    } else {
                        pstmt.setObject(11, rftOptions.getBinary());
                    }
                    if (rftOptions.getSourceSubjectName() == null) {
                        pstmt.setObject(12, "null");
                    } else {
                        pstmt.setObject(12, rftOptions.getSourceSubjectName());
                    }
                    if (rftOptions.getDestinationSubjectName() == null) {
                        pstmt.setObject(13, "null");
                    } else {
                        pstmt.setObject(13, rftOptions.getDestinationSubjectName());
                    }
                    if (rftOptions.getIgnoreFilePermErr() == null) {
                        pstmt.setObject(14, new Boolean(false));
                    } else {
                        pstmt.setObject(14, rftOptions.getIgnoreFilePermErr());
                    }
                }
                boolean flag = pstmt.execute();
            }
        }
        catch (SQLException e) {
            throw new RftDBException(i18n.getMessage("dbInsertErr") + e.getMessage(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sql) {
            logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
        }
        return returnInt;
    }

    /*
     * Loose catch block
     */
    private void storeDelete(int requestId, DeleteRequestType request, Connection c) throws RftDBException {
        block17: {
            PreparedStatement pstmt = null;
            DeleteOptionsType localDeleteOptions = request.getDeleteOptions();
            DeleteType[] list = request.getDeletion();
            pstmt = OLD_SCHEMA ? c.prepareStatement(deleteInsertQuery_OLD) : c.prepareStatement(deleteInsertQuery);
            for (int i = 0; i < list.length; ++i) {
                DeleteOptionsType tempOptions = list[i].getDeleteOptions();
                if (tempOptions != null) {
                    localDeleteOptions = tempOptions;
                }
                if (localDeleteOptions == null) {
                    localDeleteOptions = new DeleteOptionsType();
                }
                String tempSubjectName = localDeleteOptions.getSubjectName();
                String tempUserName = localDeleteOptions.getUserName();
                if (!OLD_SCHEMA) {
                    int transferId = this.getNextTransferId(c);
                    pstmt.setObject(1, new Integer(transferId));
                    pstmt.setObject(2, new Integer(requestId));
                    pstmt.setObject(3, tempSubjectName);
                    pstmt.setObject(4, list[i].getFile());
                    pstmt.setObject(5, new Integer(8));
                    if (tempUserName == null) {
                        pstmt.setObject(6, "null");
                    } else {
                        pstmt.setObject(6, tempUserName);
                    }
                    pstmt.execute();
                    continue;
                }
                pstmt.setObject(1, new Integer(requestId));
                pstmt.setObject(2, tempSubjectName);
                pstmt.setObject(3, list[i].getFile());
                pstmt.setObject(4, new Integer(8));
                if (tempUserName == null) {
                    pstmt.setObject(5, "null");
                } else {
                    pstmt.setObject(5, tempUserName);
                }
                pstmt.execute();
            }
            Object var13_13 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                break block17;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block17;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getSubject(int requestId) throws RftDBException {
        String subject;
        block14: {
            Connection c = null;
            subject = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            rs = statement.executeQuery("SELECT user_subject from request where id=" + requestId);
            while (rs != null && rs.next()) {
                subject = rs.getString(1);
            }
            Object var8_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return subject;
    }

    /*
     * Loose catch block
     */
    public String getDelegationEPR(int requestId) throws RftDBException {
        String delegationURI;
        block14: {
            Connection c = null;
            delegationURI = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            rs = statement.executeQuery("SELECT delegated_epr from request where id=" + requestId);
            while (rs != null && rs.next()) {
                delegationURI = rs.getString(1);
            }
            Object var8_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return delegationURI;
    }

    /*
     * Loose catch block
     */
    public void updateRequest(int requestId, long newTerm) throws RftDBException {
        block11: {
            Statement statement = null;
            Connection c = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Update request set termination_time =");
            query.append(newTerm);
            query.append(" where id=");
            query.append(requestId);
            statement.executeUpdate(query.toString());
            Object var8_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updateStarted(int requestId, boolean started) throws RftDBException {
        block11: {
            PreparedStatement pstmt = null;
            Connection c = null;
            c = RFTDatabaseSetup.getDBConnection();
            pstmt = c.prepareStatement(updateStartedQuery);
            pstmt.setObject(1, new Boolean(started));
            pstmt.setObject(2, new Integer(requestId));
            pstmt.execute();
            Object var7_5 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Boolean isStarted(int requestId) throws RftDBException {
        Boolean started;
        block14: {
            started = null;
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            rs = statement.executeQuery("SELECT started from request where id=" + requestId);
            while (rs != null && rs.next()) {
                started = new Boolean(rs.getBoolean(1));
            }
            Object var8_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return started;
    }

    /*
     * Loose catch block
     */
    public List getActiveRequestIds() throws RftDBException {
        Vector<Integer> temp;
        block14: {
            temp = new Vector<Integer>();
            Connection c = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            pstmt = c.prepareStatement(activeRequestIdSQL);
            pstmt.setObject(1, new Long(Calendar.getInstance().getTimeInMillis()));
            pstmt.setObject(2, new Boolean(true));
            rs = pstmt.executeQuery();
            while (rs != null && rs.next()) {
                temp.addElement(new Integer(rs.getInt(1)));
            }
            this.resetActiveTransfers(c);
            Object var7_5 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        ArrayList list = new ArrayList(temp);
        return list;
    }

    /*
     * Loose catch block
     */
    private void resetActiveTransfers(Connection c) throws RftDBException {
        block9: {
            Statement statement = null;
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("update transfer set status=4 where (status=3 ");
            query.append(" or status=10)");
            statement.executeUpdate(query.toString());
            Object var5_5 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block9;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block9;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    private TransferType updateDestinationUrl(TransferType transfer) {
        String sourceUrl = transfer.getSourceUrl();
        String fileName = sourceUrl.substring(sourceUrl.lastIndexOf("/") + 1);
        transfer.setDestinationUrl(transfer.getDestinationUrl() + fileName);
        return transfer;
    }

    private TransferType constructTransferType(ResultSet rs) throws SQLException {
        TransferType transfer = new TransferType();
        transfer.setTransferId(new Integer(rs.getInt(1)));
        transfer.setSourceUrl(rs.getString(3));
        transfer.setDestinationUrl(rs.getString(4));
        transfer.setStatus(RFTUtil.mapStatus(rs.getInt(5)));
        transfer.setAttempts(new Integer(rs.getInt(6)));
        RFTOptionsType rftOptions = new RFTOptionsType();
        rftOptions.setUserName(rs.getString(7));
        rftOptions.setDcau(new Boolean(rs.getBoolean(8)));
        rftOptions.setParallelStreams(new Integer(rs.getInt(9)));
        rftOptions.setTcpBufferSize(new Integer(rs.getInt(10)));
        rftOptions.setBlockSize(new Integer(rs.getInt(11)));
        rftOptions.setNotpt(new Boolean(rs.getBoolean(12)));
        boolean binary = rs.getBoolean(13);
        if (rs.wasNull()) {
            binary = true;
        }
        rftOptions.setBinary(new Boolean(binary));
        rftOptions.setSourceSubjectName(rs.getString(14));
        rftOptions.setDestinationSubjectName(rs.getString(15));
        rftOptions.setIgnoreFilePermErr(new Boolean(rs.getBoolean(16)));
        transfer.setRftOptions(rftOptions);
        return transfer;
    }

    /*
     * Loose catch block
     */
    public Vector getInitialTransfers(int requestId, int concurrency) throws RftDBException {
        Vector<TransferType> initialList;
        block15: {
            initialList = new Vector<TransferType>();
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            int activeTransfers = this.getNumberActive();
            int numberAllowed = RFTDatabaseSetup.maxActive - activeTransfers;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Number of active transfers : " + activeTransfers));
                logger.debug((Object)("Number allowed : " + RFTDatabaseSetup.maxActive));
                logger.debug((Object)("concurrency " + concurrency + " number allowed " + numberAllowed));
            }
            int rowLimit = 0;
            rowLimit = concurrency > numberAllowed ? numberAllowed : concurrency;
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM transfer where request_id=");
            query.append(requestId);
            query.append(" and status=4 ");
            query.append(" order by id ");
            statement.setMaxRows(rowLimit);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                initialList.add(this.constructTransferType(rs));
            }
            Object var12_12 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block15;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block15;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return initialList;
    }

    /*
     * Loose catch block
     */
    public Vector getInitialDeleteTransfers(int requestId, int concurrency) throws RftDBException {
        Vector<TransferType> initialList;
        block14: {
            initialList = new Vector<TransferType>();
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("SELECT id,source_url,status,attempts,user_name,source_subject");
            query.append(" FROM transfer where request_id=");
            query.append(requestId);
            query.append(" order by id");
            query.append(" limit " + concurrency);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                TransferType transfer = new TransferType();
                transfer.setTransferId(new Integer(rs.getInt(1)));
                transfer.setSourceUrl(rs.getString(2));
                transfer.setStatus(RFTUtil.mapStatus(rs.getInt(3)));
                transfer.setAttempts(new Integer(rs.getInt(4)));
                RFTOptionsType rftOptions = new RFTOptionsType();
                rftOptions.setUserName(rs.getString(5));
                rftOptions.setSourceSubjectName(rs.getString(6));
                transfer.setRftOptions(rftOptions);
                initialList.add(transfer);
            }
            Object var11_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return initialList;
    }

    /*
     * Loose catch block
     */
    public Collection getActiveTransfers(int requestId) throws RftDBException {
        ArrayList<TransferType> initialList;
        block17: {
            initialList = new ArrayList<TransferType>();
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            int concurrency = this.getConcurrency(requestId);
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM transfer where request_id=");
            query.append(requestId);
            query.append(" AND (status=3 or status=4 or ");
            query.append(" status=1 or status=8 or status=6) ");
            query.append(" order by id ");
            statement.setMaxRows(concurrency);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                TransferType transfer = new TransferType();
                transfer.setTransferId(new Integer(rs.getInt(1)));
                transfer.setSourceUrl(rs.getString(3));
                String tempDest = rs.getString(4);
                if (tempDest == null || tempDest.equals("null")) {
                    transfer.setStatus(RFTUtil.mapStatus(8));
                } else {
                    transfer.setDestinationUrl(tempDest);
                    int tempStatus = rs.getInt(5);
                    transfer.setStatus(RFTUtil.mapStatus(tempStatus));
                    if (tempStatus == 6) {
                        this.recoverDirectoryTransfers(requestId, transfer.getSourceUrl(), transfer.getDestinationUrl());
                    }
                }
                transfer.setAttempts(new Integer(rs.getInt(6)));
                RFTOptionsType rftOptions = new RFTOptionsType();
                rftOptions.setUserName(rs.getString(7));
                rftOptions.setDcau(new Boolean(rs.getBoolean(8)));
                rftOptions.setParallelStreams(new Integer(rs.getInt(9)));
                rftOptions.setTcpBufferSize(new Integer(rs.getInt(10)));
                rftOptions.setBlockSize(new Integer(rs.getInt(11)));
                rftOptions.setNotpt(new Boolean(rs.getBoolean(12)));
                rftOptions.setBinary(new Boolean(rs.getBoolean(13)));
                rftOptions.setSourceSubjectName(rs.getString(14));
                rftOptions.setDestinationSubjectName(rs.getString(15));
                rftOptions.setIgnoreFilePermErr(new Boolean(rs.getBoolean(16)));
                transfer.setRftOptions(rftOptions);
                initialList.add(transfer);
            }
            Object var12_13 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block17;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block17;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return initialList;
    }

    public RFTRecoveryData getRecoveryData(int requestId) throws RftDBException {
        RFTRecoveryData recoveryData = this.getSecurityRecoveryData(requestId);
        recoveryData.setRecoveredTransfers(this.getActiveTransfers(requestId));
        recoveryData.setOverallStatus(this.getOverallStatus(requestId));
        return recoveryData;
    }

    /*
     * Loose catch block
     */
    public RFTRecoveryData getSecurityRecoveryData(int requestId) throws RftDBException {
        RFTRecoveryData recoveryData;
        block14: {
            recoveryData = new RFTRecoveryData();
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select username,user_subject from request ");
            query.append(" where id=").append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                recoveryData.setUserName(rs.getString(1));
                recoveryData.setUserSubject(rs.getString(2));
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return recoveryData;
    }

    /*
     * Loose catch block
     */
    public OverallStatus getOverallStatus(int requestId) throws RftDBException {
        OverallStatus overallStatus;
        block22: {
            ResultSet rs;
            Statement statement;
            Connection c;
            block21: {
                c = null;
                statement = null;
                rs = null;
                int status = -1;
                overallStatus = null;
                int finished = 0;
                int active = 0;
                int pending = 0;
                int retrying = 0;
                int cancelled = 0;
                int failed = 0;
                c = RFTDatabaseSetup.getDBConnection();
                statement = c.createStatement();
                StringBuffer query = new StringBuffer();
                query.append("Select status from transfer  ");
                query.append(" where request_id=").append(requestId);
                rs = statement.executeQuery(query.toString());
                while (rs != null && rs.next()) {
                    status = rs.getInt(1);
                    if (status == 0) {
                        ++finished;
                        continue;
                    }
                    if (status == 1) {
                        ++retrying;
                        continue;
                    }
                    if (status == 2) {
                        ++failed;
                        continue;
                    }
                    if (status == 3) {
                        ++active;
                        continue;
                    }
                    if (status == 4 || status == 10 || status == 8) {
                        ++pending;
                        continue;
                    }
                    if (status == 5) {
                        ++cancelled;
                        continue;
                    }
                    if (status == 6) {
                        ++active;
                        continue;
                    }
                    if (status != 7) continue;
                    ++finished;
                }
                overallStatus = new OverallStatus();
                overallStatus.setTransfersFinished(finished);
                overallStatus.setTransfersRestarted(retrying);
                overallStatus.setTransfersFailed(failed);
                overallStatus.setTransfersActive(active);
                overallStatus.setTransfersPending(pending);
                overallStatus.setTransfersCancelled(cancelled);
                if (!logger.isDebugEnabled()) break block21;
                logger.debug((Object)("OverallStatus for requestId: " + requestId + " Finished:" + finished + " Retrying:" + retrying + " Failed:" + failed + " Active:" + active + " Pending:" + pending + " Cancelled:" + cancelled));
            }
            Object var15_15 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block22;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block22;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return overallStatus;
    }

    /*
     * Loose catch block
     */
    private void recoverDirectoryTransfers(int requestId, String sourceUrl, String destinationUrl) throws RftDBException {
        block12: {
            logger.debug((Object)"Recovering directory transfers");
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("DELETE from transfer where request_id=");
            query.append(requestId);
            query.append(" and source_url like '");
            query.append(sourceUrl);
            query.append("%' and dest_url like '");
            query.append(destinationUrl);
            query.append("%'");
            query.append(" and status = 4");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query to remove dir entries:" + query.toString()));
            }
            statement.executeUpdate(query.toString());
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block12;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block12;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getNumberActive(int requestId) throws RftDBException {
        int activeTransfers;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            activeTransfers = 0;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select count(*) from transfer where ");
            query.append(" request_id= ");
            query.append(requestId);
            query.append(" and (status=3 or status=6)");
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                int status;
                activeTransfers = status = rs.getInt(1);
                logger.debug((Object)("status from db: " + status));
            }
            Object var9_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return activeTransfers;
    }

    /*
     * Loose catch block
     */
    public int getNumberActive() throws RftDBException {
        int activeTransfers;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            activeTransfers = 0;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select count(*) from transfer where ");
            query.append(" status=3");
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                activeTransfers = rs.getInt(1);
            }
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return activeTransfers;
    }

    /*
     * Loose catch block
     */
    public int getConcurrency(int requestId) throws RftDBException {
        int concurrency;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            concurrency = -1;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select concurrency from request ");
            query.append(" where id=");
            query.append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                concurrency = rs.getInt(1);
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return concurrency;
    }

    /*
     * Loose catch block
     */
    public String getRestartMarker(int transferJobID) throws RftDBException {
        String marker;
        block14: {
            Connection c = null;
            PreparedStatement ps = null;
            marker = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            ps = c.prepareStatement("Select marker from restart where transfer_id=?");
            ps.setInt(1, transferJobID);
            rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                marker = rs.getString(1);
            }
            Object var8_6 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + transferJobID)), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return marker;
    }

    /*
     * Loose catch block
     */
    public void removeRestartMarker(Connection c, int requestId) throws RftDBException {
        block12: {
            PreparedStatement ps1 = null;
            ResultSet rs = null;
            Statement ps2 = null;
            ps1 = c.prepareStatement("SELECT id from transfer where request_id=?");
            ps1.setInt(1, requestId);
            rs = ps1.executeQuery();
            ps2 = c.prepareStatement("DELETE FROM restart WHERE transfer_id=?");
            while (rs != null && rs.next()) {
                int transferId = rs.getInt(1);
                ps2.setInt(1, transferId);
                ps2.executeUpdate();
            }
            Object var8_8 = null;
            try {
                if (ps1 != null) {
                    ps1.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                break block12;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block12;
            {
                catch (SQLException sql) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr", (Object)(" " + requestId)), sql);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void setRestartMarker(int transferJobID, String marker) throws RftDBException {
        block14: {
            Statement ps2;
            PreparedStatement ps;
            Connection c;
            block13: {
                c = null;
                ps = null;
                ps2 = null;
                c = RFTDatabaseSetup.getDBConnection();
                ps = c.prepareStatement("UPDATE restart set  marker=? where transfer_id=?");
                ps.setString(1, marker);
                ps.setInt(2, transferJobID);
                int update = ps.executeUpdate();
                if (update != 0) break block13;
                ps2 = c.prepareStatement("INSERT into restart(transfer_id,marker) VALUES(?,?)");
                ps2.setInt(1, transferJobID);
                ps2.setString(2, marker);
                ps2.executeUpdate();
            }
            Object var8_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr", (Object)(" " + transferJobID)), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void update(int requestId, TransferType transferJob) throws RftDBException {
        block11: {
            Connection c = null;
            PreparedStatement updatePS = null;
            int status = RFTUtil.reverseMap(transferJob.getStatus());
            logger.debug((Object)("Updating status in database for id: " + transferJob.getTransferId() + " with status: " + status));
            c = RFTDatabaseSetup.getDBConnection();
            updatePS = c.prepareStatement("update transfer set status=?,attempts=?,dest_url=?,source_url=? where id=?");
            updatePS.setInt(1, status);
            updatePS.setInt(2, transferJob.getAttempts());
            updatePS.setString(3, transferJob.getDestinationUrl());
            updatePS.setString(4, transferJob.getSourceUrl());
            updatePS.setInt(5, transferJob.getTransferId());
            updatePS.executeUpdate();
            logger.debug((Object)("Updated status in database for id: " + transferJob.getTransferId() + " with status: " + status));
            Object var8_6 = null;
            try {
                if (updatePS != null) {
                    updatePS.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (updatePS != null) {
                        updatePS.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void storeDelegationListenerId(int requestId, String delegationId) throws RftDBException {
        block11: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer insertQuery = new StringBuffer();
            insertQuery.append("Update request set proxy_loc='");
            insertQuery.append(delegationId);
            insertQuery.append("' where id=").append(requestId);
            statement.executeUpdate(insertQuery.toString());
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbUpdateErr"), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getDelegationListenerId(int requestId) throws RftDBException {
        String delegationListenerId;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            delegationListenerId = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select proxy_loc from request where id=");
            query.append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                delegationListenerId = rs.getString(1);
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbUpdateErr"), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return delegationListenerId;
    }

    /*
     * Loose catch block
     */
    private void updateFactoryRPs(long size, Connection c) throws RftDBException {
        block16: {
            ResultSet rs;
            Statement ps2;
            PreparedStatement ps;
            block15: {
                ps = null;
                ps2 = null;
                rs = null;
                long totalTransfers = 0L;
                long totalBytes = 0L;
                ps = c.prepareStatement("Select total_transfers,total_bytes from factory");
                rs = ps.executeQuery();
                while (rs != null && rs.next()) {
                    totalTransfers = rs.getLong(1);
                    totalBytes = rs.getLong(2);
                }
                if (totalTransfers == 0L && totalBytes == 0L) {
                    totalTransfers = 1L;
                    totalBytes = size;
                    ps2 = c.prepareStatement("INSERT into factory values(?,?)");
                    ps2.setLong(1, totalTransfers);
                    ps2.setLong(2, totalBytes);
                    ps2.executeUpdate();
                    break block15;
                }
                totalBytes = size + totalBytes;
                ps2 = c.prepareStatement("update factory set total_transfers=?, total_bytes=?");
                ps2.setLong(1, ++totalTransfers);
                ps2.setLong(2, totalBytes);
                ps2.executeUpdate();
            }
            Object var13_8 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block16;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block16;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbUpdateErr"), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean checkAllDone(int requestId) throws RftDBException {
        boolean allDone;
        block15: {
            ResultSet rs;
            PreparedStatement ps;
            Connection c;
            block14: {
                allDone = false;
                c = null;
                ps = null;
                rs = null;
                int count = 0;
                c = RFTDatabaseSetup.getDBConnection();
                ps = c.prepareStatement("select count(*) from transfer where status != 0 and status !=7  and status !=2  and request_id=?");
                ps.setInt(1, requestId);
                rs = ps.executeQuery();
                while (rs != null && rs.next()) {
                    count = rs.getInt(1);
                }
                if (count != 0) break block14;
                allDone = true;
            }
            Object var9_7 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block15;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block15;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbRetrieveErr"), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return allDone;
    }

    /*
     * Loose catch block
     */
    public long getMinimumPollTime() throws RftDBException {
        long retryTime;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            retryTime = 0L;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("select min(retry_time) from ");
            query.append(" transfer where retry_time >= ").append(Calendar.getInstance().getTimeInMillis());
            query.append(" and status=1");
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                retryTime = rs.getLong(1);
            }
            Object var8_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbRetrieveErr"), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return retryTime;
    }

    /*
     * Loose catch block
     */
    public void storeTransferJob(int requestId, TransferType transferJob) throws RftDBException {
        block14: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            RFTOptionsType localOptions = transferJob.getRftOptions();
            if (localOptions == null) {
                localOptions = globalRFTOptions;
            }
            if (!OLD_SCHEMA) {
                statement = c.prepareStatement(singleTransferInsertQuery);
                int transferId = this.getNextTransferId(c);
                statement.setObject(1, new Integer(transferId));
                statement.setObject(2, new Integer(requestId));
                statement.setObject(3, transferJob.getSourceUrl());
                statement.setObject(4, transferJob.getDestinationUrl());
                statement.setObject(5, new Integer(RFTUtil.reverseMap(transferJob.getStatus())));
                statement.setObject(6, localOptions.getUserName());
                statement.setObject(7, localOptions.getDcau());
                statement.setObject(8, localOptions.getParallelStreams());
                statement.setObject(9, localOptions.getTcpBufferSize());
                statement.setObject(10, localOptions.getBlockSize());
                statement.setObject(11, localOptions.getNotpt());
                statement.setObject(12, localOptions.getBinary());
                statement.setObject(13, localOptions.getSourceSubjectName());
                statement.setObject(14, localOptions.getDestinationSubjectName());
            } else {
                statement = c.prepareStatement(singleTransferInsertQuery_OLD);
                statement.setObject(1, new Integer(requestId));
                statement.setObject(2, transferJob.getSourceUrl());
                statement.setObject(3, transferJob.getDestinationUrl());
                statement.setObject(4, new Integer(RFTUtil.reverseMap(transferJob.getStatus())));
                statement.setObject(5, localOptions.getUserName());
                statement.setObject(6, localOptions.getDcau());
                statement.setObject(7, localOptions.getParallelStreams());
                statement.setObject(8, localOptions.getTcpBufferSize());
                statement.setObject(9, localOptions.getBlockSize());
                statement.setObject(10, localOptions.getNotpt());
                statement.setObject(11, localOptions.getBinary());
                statement.setObject(12, localOptions.getSourceSubjectName());
                statement.setObject(13, localOptions.getDestinationSubjectName());
            }
            statement.execute();
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbInsertErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public long getTotalNumberOfTransfers() throws RftDBException {
        long totalNumberOfTransfers;
        block14: {
            Connection c = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            totalNumberOfTransfers = 0L;
            c = RFTDatabaseSetup.getDBConnection();
            ps = c.prepareStatement("select total_transfers from factory");
            rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                totalNumberOfTransfers = rs.getLong(1);
            }
            Object var8_5 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return totalNumberOfTransfers;
    }

    /*
     * Loose catch block
     */
    public long getTotalNumberOfBytes() throws RftDBException {
        long totalNumberOfBytes;
        block14: {
            Connection c = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            totalNumberOfBytes = 0L;
            c = RFTDatabaseSetup.getDBConnection();
            ps = c.prepareStatement("select total_bytes from factory");
            rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                totalNumberOfBytes = rs.getLong(1);
            }
            Object var8_5 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return totalNumberOfBytes;
    }

    /*
     * Loose catch block
     */
    public void updateTransfer(int transferId, long size, String permissions) throws RftDBException {
        block11: {
            Connection c = null;
            PreparedStatement ps = null;
            c = RFTDatabaseSetup.getDBConnection();
            StringBuffer query = new StringBuffer();
            ps = c.prepareStatement("update transfer set permissions=?, size=? where id=?");
            ps.setString(1, permissions);
            ps.setLong(2, size);
            ps.setInt(3, transferId);
            ps.executeUpdate();
            this.updateFactoryRPs(size, c);
            Object var9_8 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (ps != null) {
                    ps.close();
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getUserName(int requestId) throws RftDBException {
        String userName;
        block14: {
            Connection c = null;
            Statement statement = null;
            userName = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            rs = statement.executeQuery("SELECT username from request where  id= " + requestId);
            while (rs != null && rs.next()) {
                userName = rs.getString(1);
            }
            Object var8_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return userName;
    }

    /*
     * Loose catch block
     */
    public void backOff(String hostName) throws RftDBException {
        block11: {
            Connection c = null;
            Statement statement = null;
            logger.debug((Object)"backing off");
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Update transfer set retry_time= ");
            query.append(Calendar.getInstance().getTimeInMillis() + (long)(2 * RFTDatabaseSetup.backOff));
            query.append(" where (source_url like '%");
            query.append(hostName);
            query.append("%' or dest_url like '%");
            query.append(hostName);
            query.append("%') and (status=1 or status=4 or status=3");
            query.append(" or status=10)");
            statement.executeUpdate(query.toString());
            Object var6_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void backOff(int transferId, int attempts) throws RftDBException {
        block11: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Update transfer set retry_time= ");
            query.append((double)Calendar.getInstance().getTimeInMillis() + Math.pow(2.0, attempts) * (double)RFTDatabaseSetup.backOff);
            query.append(" where id=").append(transferId);
            statement.executeUpdate(query.toString());
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public TransferStatusType getStatus(int requestId, String sourceUrl) throws RftDBException {
        TransferStatusType statusType;
        block14: {
            Connection c = null;
            Statement statement = null;
            statusType = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select source_url,dest_url,attempts,status ");
            query.append(" from transfer");
            query.append(" where request_id=");
            query.append(requestId);
            query.append(" and source_url='");
            query.append(sourceUrl);
            query.append("' ");
            statement.setMaxRows(1);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                statusType = new TransferStatusType();
                statusType.setSourceUrl(rs.getString(1));
                statusType.setDestinationUrl(rs.getString(2));
                statusType.setAttempts(rs.getInt(3));
                statusType.setStatus(RFTUtil.mapStatus(rs.getInt(4)));
            }
            Object var9_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return statusType;
    }

    /*
     * Loose catch block
     */
    public Vector getStatusSet(int requestId, int initial, int offset) throws RftDBException {
        Vector<TransferStatusType> statusTypesVector;
        block14: {
            Connection c = null;
            Statement statement = null;
            statusTypesVector = new Vector<TransferStatusType>();
            TransferStatusType statusType = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select source_url,dest_url,attempts,status ");
            query.append(" from transfer");
            query.append(" where request_id=");
            query.append(requestId);
            query.append(" and id >= ");
            query.append(this.getFirstTransferId(requestId) + initial - 1);
            query.append(" order by id");
            statement.setMaxRows(offset);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                statusType = new TransferStatusType();
                statusType.setSourceUrl(rs.getString(1));
                statusType.setDestinationUrl(rs.getString(2));
                statusType.setAttempts(rs.getInt(3));
                statusType.setStatus(RFTUtil.mapStatus(rs.getInt(4)));
                statusTypesVector.add(statusType);
            }
            Object var11_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return statusTypesVector;
    }

    /*
     * Loose catch block
     */
    public int getFirstTransferId(int requestId) throws RftDBException {
        int transferId;
        block14: {
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            transferId = -1;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select min(id) from transfer");
            query.append(" where request_id=");
            query.append(requestId);
            statement.setMaxRows(1);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                transferId = rs.getInt(1);
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return transferId;
    }

    /*
     * Loose catch block
     */
    public boolean getAllOrNone(int requestId) throws RftDBException {
        boolean allOrNone;
        block14: {
            allOrNone = false;
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("select all_or_none from request where id=");
            query.append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                allOrNone = rs.getBoolean(1);
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return allOrNone;
    }

    /*
     * Loose catch block
     */
    public Vector getFinishedTransfers(int requestId) throws RftDBException {
        Vector<TransferType> transferTypes;
        block14: {
            transferTypes = null;
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Select * from transfer where request_id=");
            query.append(requestId);
            query.append(" and status=0 order by id");
            rs = statement.executeQuery(query.toString());
            transferTypes = new Vector<TransferType>();
            while (rs != null && rs.next()) {
                TransferType transfer = new TransferType();
                transfer.setTransferId(new Integer(rs.getInt(1)));
                transfer.setSourceUrl(rs.getString(3));
                transfer.setDestinationUrl(rs.getString(4));
                transfer.setStatus(RFTUtil.mapStatus(rs.getInt(5)));
                transfer.setAttempts(new Integer(rs.getInt(6)));
                RFTOptionsType rftOptions = new RFTOptionsType();
                rftOptions.setDcau(new Boolean(rs.getBoolean(7)));
                rftOptions.setParallelStreams(new Integer(rs.getInt(8)));
                rftOptions.setTcpBufferSize(new Integer(rs.getInt(9)));
                rftOptions.setBlockSize(new Integer(rs.getInt(10)));
                rftOptions.setNotpt(new Boolean(rs.getBoolean(11)));
                rftOptions.setBinary(new Boolean(rs.getBoolean(12)));
                rftOptions.setSourceSubjectName(rs.getString(13));
                rftOptions.setDestinationSubjectName(rs.getString(14));
                rftOptions.setIgnoreFilePermErr(new Boolean(rs.getBoolean(16)));
                transfer.setRftOptions(rftOptions);
                transferTypes.add(transfer);
            }
            Object var10_10 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return transferTypes;
    }

    /*
     * Loose catch block
     */
    public void updateToDirty(int requestId) throws RftDBException {
        block11: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Update transfer set status=8 where request_id=");
            query.append(requestId);
            query.append(" and status != 2 ");
            statement.executeUpdate(query.toString());
            Object var6_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void updateToCancelled(int requestId, int fromId, int toId) throws RftDBException {
        block14: {
            Connection c = null;
            Statement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("Update transfer set status=5 where request_id=");
            query.append(requestId);
            if (fromId == -1 || toId == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cancelling the entire request " + requestId));
                }
            } else {
                query.append(" and id>=");
                query.append(fromId);
                query.append(" and id<=");
                query.append(toId);
            }
            statement.executeUpdate(query.toString());
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void deleteAll(int requestId) throws RftDBException {
        block11: {
            Connection c = null;
            PreparedStatement statement = null;
            c = RFTDatabaseSetup.getDBConnection();
            this.removeRestartMarker(c, requestId);
            statement = c.prepareStatement("DELETE FROM transfer where request_id=?");
            statement.setInt(1, requestId);
            statement.executeUpdate();
            StringBuffer query2 = new StringBuffer();
            statement = c.prepareStatement("DELETE from request where id=?");
            statement.setInt(1, requestId);
            statement.executeUpdate();
            Object var6_6 = null;
            try {
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                if (statement != null) {
                    statement.close();
                }
                break block11;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block11;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbUpdateErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getMaxAttempts(int requestId) throws RftDBException {
        int maxAttempts;
        block14: {
            maxAttempts = 0;
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("select maxattempts from request where id=");
            query.append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                maxAttempts = rs.getInt(1);
            }
            Object var8_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return maxAttempts;
    }

    /*
     * Loose catch block
     */
    public Calendar getTerminationTime(int requestId) throws RftDBException {
        long terminationTime;
        block14: {
            terminationTime = 0L;
            Connection c = null;
            Statement statement = null;
            ResultSet rs = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.createStatement();
            StringBuffer query = new StringBuffer();
            query.append("select termination_time from request where id=");
            query.append(requestId);
            rs = statement.executeQuery(query.toString());
            while (rs != null && rs.next()) {
                terminationTime = rs.getLong(1);
            }
            Object var9_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block14;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block14;
            {
                catch (Exception e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr"), e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        Calendar returnThis = Calendar.getInstance();
        returnThis.setTimeInMillis(terminationTime);
        return returnThis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

