/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.globus.transfer.reliable.service.RFTConfiguration;
import org.globus.transfer.reliable.service.ReliableFileTransferImpl;
import org.globus.transfer.reliable.service.database.RFTDatabaseOptions;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.util.I18n;

public class RFTDatabaseSetup {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup == null ? (class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup = RFTDatabaseSetup.class$("org.globus.transfer.reliable.service.database.RFTDatabaseSetup")) : class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup == null ? (class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup = RFTDatabaseSetup.class$("org.globus.transfer.reliable.service.database.RFTDatabaseSetup")) : class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup).getClassLoader());
    private static RFTDatabaseOptions rftDatabaseOptions = null;
    private static boolean driverSetup = false;
    private static final String baseURI = "jdbc:apache:commons:dbcp:";
    private static final String rftURI = "rft";
    static GenericObjectPool connectionPool = null;
    static int def_activeConnections = 32;
    static byte def_onExhaustAction = 1;
    static long def_maxWait = -1L;
    static int def_idleConnections = 2;
    static int backOff = 10;
    public static int maxActive = 10;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$database$RFTDatabaseSetup;

    private RFTDatabaseSetup() {
    }

    public static void setup() throws RftDBException, RftException {
        RFTConfiguration rftConfig = ReliableFileTransferImpl.getRFTConfiguration();
        try {
            String tempMaxActive;
            String tempBackOff = rftConfig.getBackOff();
            if (tempBackOff != null) {
                backOff = Integer.parseInt(tempBackOff);
            }
            if ((tempMaxActive = rftConfig.getMaxActiveAllowed()) != null) {
                maxActive = Integer.parseInt(tempMaxActive);
            }
        }
        catch (Exception e) {
            throw new RftException(i18n.getMessage("dbConfigFileErr") + e.getMessage(), e);
        }
        RFTDatabaseOptions rftDbOption = ReliableFileTransferImpl.getDatabaseConfiguration();
        try {
            RFTDatabaseSetup.setupDBConnection(rftDbOption);
        }
        catch (RftDBException exp) {
            throw new RftDBException(i18n.getMessage("dbSetupErr") + exp.getMessage(), (Exception)((Object)exp));
        }
    }

    public static void setupDBConnection(RFTDatabaseOptions rftDatabaseOptions, int activeConnections) throws RftDBException {
        RFTDatabaseSetup.setupDBConnection(rftDatabaseOptions, activeConnections, def_onExhaustAction, def_maxWait, def_idleConnections);
    }

    public static void setupDBConnection(RFTDatabaseOptions rftDatabaseOptions, int activeConnections, byte onExhaustAction) throws RftDBException {
        RFTDatabaseSetup.setupDBConnection(rftDatabaseOptions, activeConnections, onExhaustAction, def_maxWait, def_idleConnections);
    }

    public static void setupDBConnection(RFTDatabaseOptions rftDatabaseOptions_, int activeConnections, byte onExhaustAction, long maxWait) throws RftDBException {
        RFTDatabaseSetup.setupDBConnection(rftDatabaseOptions_, activeConnections, onExhaustAction, maxWait, def_idleConnections);
    }

    public static void setupDBConnection(RFTDatabaseOptions rftDatabaseOptions) throws RftDBException {
        RFTDatabaseSetup.setupDBConnection(rftDatabaseOptions, rftDatabaseOptions.getMaxActive(), def_onExhaustAction, rftDatabaseOptions.getMaxWait(), rftDatabaseOptions.getMaxIdle());
    }

    public static void setupDBConnection(RFTDatabaseOptions rftDatabaseOptions_, int activeConnections, byte onExhaustAction, long maxWait, int idleConnections) throws RftDBException {
        if (!driverSetup) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting up db : maximum active connection is " + activeConnections));
                logger.debug((Object)("Setting up db : maximum idle connection is " + idleConnections));
                logger.debug((Object)("dbOptions" + rftDatabaseOptions_.getConnectionString() + " " + rftDatabaseOptions_.getUserName() + " " + rftDatabaseOptions_.getPassword() + " " + rftDatabaseOptions_.getDriverName() + " " + activeConnections + " " + onExhaustAction + " " + maxWait + " " + idleConnections));
            }
            try {
                RFTDatabaseSetup.setupDriver(rftDatabaseOptions_.getConnectionString(), rftDatabaseOptions_.getUserName(), rftDatabaseOptions_.getPassword(), activeConnections, onExhaustAction, maxWait, idleConnections);
                rftDatabaseOptions = rftDatabaseOptions_;
                Class.forName(rftDatabaseOptions.getDriverName());
            }
            catch (Exception e) {
                logger.error((Object)i18n.getMessage("dbSetupErr"), (Throwable)e);
                throw new RftDBException(i18n.getMessage("dbSetupErr") + e.getMessage(), e);
            }
            driverSetup = true;
        }
    }

    public static Connection getDBConnection() throws RftDBException {
        Connection connection = null;
        if (rftDatabaseOptions == null) {
            throw new RftDBException(i18n.getMessage("driverNotInitErr"));
        }
        try {
            connection = DriverManager.getConnection("jdbc:apache:commons:dbcp:rft");
            return connection;
        }
        catch (SQLException e) {
            throw new RftDBException(i18n.getMessage("dbConnErr") + e.getMessage(), e);
        }
    }

    private static void setupDriver(String connectURI, String username, String password, int activeConnections, byte onExhaustAction, long maxWait, int idleConnections) throws Exception {
        connectionPool = new GenericObjectPool(null, activeConnections, onExhaustAction, maxWait, idleConnections, true, false);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
        String validationQuery = "SELECT 1";
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, validationQuery, false, true);
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(rftURI, (ObjectPool)connectionPool);
    }

    public static void returnDBConnection(Connection connection) throws RftDBException {
        if (rftDatabaseOptions == null) {
            throw new RftDBException(i18n.getMessage("dbSetupErr"));
        }
        try {
            connection.close();
        }
        catch (SQLException sqlExcep) {
            logger.error((Object)i18n.getMessage("dbConnReturnErr"), (Throwable)sqlExcep);
            throw new RftDBException(i18n.getMessage("dbConnReturnErr") + sqlExcep.getMessage(), sqlExcep);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

