/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service.database;

import commonj.work.Work;
import commonj.work.WorkManager;
import java.util.Calendar;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.TransferType;
import org.globus.transfer.reliable.service.RFTResourceManager;
import org.globus.transfer.reliable.service.TransferWork;
import org.globus.util.I18n;
import org.globus.wsrf.ResourcePropertySet;

public class RFTDatabasePoller
implements Work {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$database$RFTDatabasePoller == null ? (class$org$globus$transfer$reliable$service$database$RFTDatabasePoller = RFTDatabasePoller.class$("org.globus.transfer.reliable.service.database.RFTDatabasePoller")) : class$org$globus$transfer$reliable$service$database$RFTDatabasePoller).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$database$RFTDatabasePoller == null ? (class$org$globus$transfer$reliable$service$database$RFTDatabasePoller = RFTDatabasePoller.class$("org.globus.transfer.reliable.service.database.RFTDatabasePoller")) : class$org$globus$transfer$reliable$service$database$RFTDatabasePoller).getClassLoader());
    private boolean started = false;
    private long pollTime = 0L;
    private ResourcePropertySet rpSet = null;
    private int requestId = 0;
    private RFTResourceManager resourceManager;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$database$RFTDatabasePoller;

    public RFTDatabasePoller(long pollTime, ResourcePropertySet rpSet, int requestId, RFTResourceManager resourceManager) {
        this.pollTime = pollTime;
        this.rpSet = rpSet;
        this.requestId = requestId;
        this.resourceManager = resourceManager;
    }

    public void release() {
    }

    public boolean isDaemon() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setPollTime(long pollTime) {
        this.pollTime = pollTime;
    }

    public void run() {
        try {
            this.started = true;
            while (this.pollTime > Calendar.getInstance().getTimeInMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Sleeping here ");
                    logger.debug((Object)(" pollTime: " + this.pollTime));
                    logger.debug((Object)("Current time: " + Calendar.getInstance().getTimeInMillis()));
                }
                Thread.sleep(1000L);
            }
            TransferType newTransfer = this.resourceManager.getNext();
            if (newTransfer != null) {
                InitialContext initialCtx = new InitialContext();
                WorkManager workManager = (WorkManager)initialCtx.lookup("java:comp/env/wm/ContainerWorkManager");
                TransferWork transferWork = new TransferWork(this.requestId, this.rpSet, newTransfer);
                transferWork.setWorkManager(workManager);
                transferWork.setResourceManager(this.resourceManager);
                workManager.schedule((Work)transferWork);
            }
            this.started = false;
        }
        catch (Exception ie) {
            logger.error((Object)i18n.getMessage("dbPollingErr"), (Throwable)ie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

