/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.HostPort;
import org.globus.ftp.MlsxEntry;
import org.globus.ftp.exception.ServerException;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.rft.generated.TransferStatusTypeEnumeration;
import org.globus.rft.generated.TransferType;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;

public class URLExpander
extends Thread {
    private GridFTPClient sourceHost;
    private GridFTPClient destinationHost;
    private String sourcePath;
    private String destinationPath;
    private Vector sourceUrlsEx;
    private GlobusURL sourceGlobusUrl;
    private GlobusURL destinationGlobusUrl;
    private boolean done = false;
    private RFTOptionsType rftOptions = null;
    private boolean isDelete = false;
    private Vector dirVector = new Vector();
    private int requestId = 0;
    private int numberOfTransfers = 0;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$URLExpander == null ? (class$org$globus$transfer$reliable$service$URLExpander = URLExpander.class$("org.globus.transfer.reliable.service.URLExpander")) : class$org$globus$transfer$reliable$service$URLExpander).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$URLExpander == null ? (class$org$globus$transfer$reliable$service$URLExpander = URLExpander.class$("org.globus.transfer.reliable.service.URLExpander")) : class$org$globus$transfer$reliable$service$URLExpander).getClassLoader());
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$URLExpander;

    public URLExpander(GridFTPClient sourceHost, GridFTPClient destinationHost, GlobusURL sourceGlobusUrl, GlobusURL destinationGlobusUrl, RFTOptionsType rftOptions) throws RftException {
        this.sourceHost = sourceHost;
        this.destinationHost = destinationHost;
        this.sourceGlobusUrl = sourceGlobusUrl;
        this.destinationGlobusUrl = destinationGlobusUrl;
        this.sourcePath = "/" + sourceGlobusUrl.getPath();
        this.destinationPath = "/" + destinationGlobusUrl.getPath();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expanding: " + this.sourcePath + " " + this.destinationPath));
        }
        this.rftOptions = rftOptions;
        this.sourceUrlsEx = new Vector();
        this.sourceUrlsEx.add(this.sourcePath);
        this.changeDir(this.destinationPath);
    }

    public void release() {
    }

    public URLExpander(GridFTPClient sourceHost, GlobusURL sourceGlobusUrl, RFTOptionsType rftOptions) {
        this.sourceHost = sourceHost;
        this.sourceGlobusUrl = sourceGlobusUrl;
        this.rftOptions = rftOptions;
        this.sourceUrlsEx = new Vector();
        this.sourcePath = "/" + sourceGlobusUrl.getPath();
        this.sourceUrlsEx.add(this.sourcePath);
        this.isDelete = true;
    }

    public void setRequestId(int requestId) {
        logger.debug((Object)("RequestId in Expander:" + requestId));
        this.requestId = requestId;
    }

    public Vector getSourceUrlList() {
        return this.sourceUrlsEx;
    }

    public int getNumberOfTransfers() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning number of transfers : " + this.numberOfTransfers));
        }
        return this.numberOfTransfers;
    }

    public Vector doMlsd(String localSourcePath) {
        Vector returnThis = new Vector();
        try {
            HostPort hp = this.sourceHost.setLocalPassive();
            this.sourceHost.setActive(hp);
            this.sourceHost.changeDir(localSourcePath);
            returnThis = this.sourceHost.mlsd();
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("urlExpansionErr") + e.getMessage()), (Throwable)e);
        }
        return returnThis;
    }

    public boolean getStatus() {
        return this.done;
    }

    public void run() {
        try {
            while (this.sourceUrlsEx.size() > 0) {
                logger.debug((Object)("Size of SourceUrlsEx " + this.sourceUrlsEx.size()));
                String currentUrl = (String)this.sourceUrlsEx.remove(0);
                this.dirVector.add(currentUrl);
                Vector v = this.doMlsd(currentUrl);
                while (!v.isEmpty()) {
                    MlsxEntry f = (MlsxEntry)v.remove(0);
                    if (f.get("type").equals("dir")) {
                        String dirName = f.getFileName();
                        if (!this.isDelete) {
                            this.makeDirectory(dirName);
                        }
                        String newSourcePath = currentUrl + "/" + dirName;
                        this.sourceUrlsEx.add(newSourcePath);
                        continue;
                    }
                    if (!f.get("type").equals("file")) continue;
                    TransferType transferType = new TransferType();
                    String newSourceUrl = "gsiftp://" + this.sourceGlobusUrl.getHost() + ":" + this.sourceGlobusUrl.getPort() + currentUrl + "/" + f.getFileName();
                    transferType.setSourceUrl(newSourceUrl);
                    int temp = currentUrl.lastIndexOf("//");
                    String mkdir = "";
                    if (temp != -1) {
                        mkdir = currentUrl.substring(temp + 2);
                    }
                    if (!this.isDelete) {
                        String newDestinationUrl = "gsiftp://" + this.destinationGlobusUrl.getHost() + ":" + this.destinationGlobusUrl.getPort() + this.destinationPath + "/" + mkdir + "/" + f.getFileName();
                        transferType.setDestinationUrl(newDestinationUrl);
                        transferType.setStatus(TransferStatusTypeEnumeration.Pending);
                    } else {
                        transferType.setStatus(TransferStatusTypeEnumeration.Dirty);
                    }
                    transferType.setAttempts(new Integer(0));
                    transferType.setRftOptions(this.rftOptions);
                    ReliableFileTransferDbAdapter.getDbAdapter().storeTransferJob(this.requestId, transferType);
                    ++this.numberOfTransfers;
                }
                if (this.sourceUrlsEx.size() <= 0) continue;
                currentUrl = (String)this.sourceUrlsEx.elementAt(0);
                if (!this.isDelete) {
                    String dirChange = currentUrl.substring(currentUrl.lastIndexOf("//") + 2);
                    if ((dirChange = dirChange.trim()).equals("")) continue;
                    dirChange = this.destinationPath + dirChange;
                    this.changeDir(dirChange);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Delete this: " + currentUrl));
            }
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("urlExpansionErr"), (Throwable)e);
        }
        if (this.sourceUrlsEx.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"UrlExpander is done");
            }
            this.done = true;
        }
    }

    private void makeDirectory(String dir) throws IOException {
        try {
            this.destinationHost.makeDir(dir);
        }
        catch (ServerException se) {
            logger.error((Object)(i18n.getMessage("dirExistsErr", (Object)dir) + se.getMessage()));
        }
    }

    public void close() {
        try {
            if (this.sourceHost != null) {
                this.sourceHost.close();
            }
            if (this.destinationHost != null) {
                this.destinationHost.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("closeClientErr") + e.getMessage()), (Throwable)e);
        }
    }

    private void changeDir(String dirString) {
        try {
            this.destinationHost.changeDir(dirString);
        }
        catch (ServerException e) {
            try {
                this.makeDirectory(dirString);
                this.destinationHost.changeDir(dirString);
            }
            catch (ServerException se) {
                logger.error((Object)i18n.getMessage("urlExpansionErr"), (Throwable)e);
            }
            catch (IOException ioe) {
                logger.error((Object)i18n.getMessage("urlExpansionErr"), (Throwable)e);
            }
        }
        catch (IOException ioe) {
            logger.error((Object)i18n.getMessage("urlExpansionErr"), (Throwable)ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

