/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkManager;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.OverallStatus;
import org.globus.rft.generated.RFTFaultResourcePropertyType;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.RequestStatusTypeEnumeration;
import org.globus.rft.generated.TransferType;
import org.globus.transfer.reliable.service.DeleteClient;
import org.globus.transfer.reliable.service.FaultUtil;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.RFTResourceManager;
import org.globus.transfer.reliable.service.RFTUtil;
import org.globus.transfer.reliable.service.TransferClient;
import org.globus.transfer.reliable.service.URLExpander;
import org.globus.transfer.reliable.service.database.RFTDatabasePoller;
import org.globus.transfer.reliable.service.database.RFTDatabaseSetup;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.transfer.reliable.service.exception.RftTransientException;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;

public class TransferWork
implements Work {
    private TransferType transferJob;
    private int status = -1;
    private int attempts;
    private int requestId = 0;
    private ReliableFileTransferDbAdapter dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$TransferWork == null ? (class$org$globus$transfer$reliable$service$TransferWork = TransferWork.class$("org.globus.transfer.reliable.service.TransferWork")) : class$org$globus$transfer$reliable$service$TransferWork).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$TransferWork == null ? (class$org$globus$transfer$reliable$service$TransferWork = TransferWork.class$("org.globus.transfer.reliable.service.TransferWork")) : class$org$globus$transfer$reliable$service$TransferWork).getClassLoader());
    private static Vector transferClients = new Vector();
    private static Vector deleteClients = new Vector();
    private OverallStatus overallStatus;
    private ResourceProperty overallStatusRP;
    private RequestStatusType requestStatusType;
    private ResourceProperty requestStatusTypeRP;
    private ResourcePropertySet rpSet;
    private int maxAttempts = 0;
    private WorkManager workManager;
    private RFTFaultResourcePropertyType fault;
    private TransferClient transferClient = null;
    private DeleteClient deleteClient = null;
    private RFTResourceManager resourceManager = null;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$TransferWork;

    public TransferWork(int requestId, ResourcePropertySet rpSet, TransferType transferJob) {
        this.requestId = requestId;
        this.rpSet = rpSet;
        this.transferJob = transferJob;
        this.status = -1;
        this.attempts = transferJob.getAttempts();
        this.overallStatusRP = this.rpSet.get(RFTConstants.OVERALL_STATUS_RESOURCE);
        this.overallStatus = (OverallStatus)this.overallStatusRP.get(0);
        this.requestStatusTypeRP = this.rpSet.get(RFTConstants.REQUEST_STATUS_RESOURCE);
        this.requestStatusType = (RequestStatusType)this.requestStatusTypeRP.get(0);
    }

    public void setTransferJob(TransferType transferJob) {
        this.transferJob = transferJob;
    }

    public boolean isDaemon() {
        return true;
    }

    public void release() {
    }

    public int getStatus() {
        return this.status;
    }

    public void setResourceManager(RFTResourceManager resourceManager) throws RftDBException {
        this.resourceManager = resourceManager;
        this.maxAttempts = this.resourceManager.getMaxAttempts();
    }

    private synchronized void statusChanged(int status) {
        try {
            this.status = status;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getTransferIdentifiers() + "status changed called with status: " + this.status));
            }
            this.transferJob.setStatus(RFTUtil.mapStatus(this.status));
            this.resourceManager.updateTransferJob(this.transferJob.getTransferId(), this.status, this.attempts);
            if (this.status != 6) {
                this.overallStatus = this.resourceManager.getOverallStatus();
                if (this.fault != null) {
                    this.overallStatus.setFault(this.fault);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getTransferIdentifiers() + "setting overall rp to " + "(finished: " + this.overallStatus.getTransfersFinished() + ", active: " + this.overallStatus.getTransfersActive() + ", failed: " + this.overallStatus.getTransfersFailed() + ", restarted: " + this.overallStatus.getTransfersRestarted() + ", pending: " + this.overallStatus.getTransfersPending() + ", cancelled: " + this.overallStatus.getTransfersCancelled() + ")"));
                }
                this.overallStatusRP.set(0, (Object)this.overallStatus);
                this.setRequestStatus();
            }
        }
        catch (RftDBException e) {
            logger.error((Object)(i18n.getMessage("dbUpdateErr") + e.getMessage()), (Throwable)((Object)e));
        }
    }

    private void setRequestStatus() {
        RequestStatusTypeEnumeration reqStatus = this.requestStatusType.getRequestStatus();
        int totalTransfers = 0;
        int activeTransfers = this.overallStatus.getTransfersActive();
        int failedTransfers = this.overallStatus.getTransfersFailed();
        int pendingTransfers = this.overallStatus.getTransfersPending();
        int finishedTransfers = this.overallStatus.getTransfersFinished();
        int restartedTransfers = this.overallStatus.getTransfersRestarted();
        totalTransfers = activeTransfers + failedTransfers + pendingTransfers + finishedTransfers + restartedTransfers;
        if (activeTransfers > 0 && !reqStatus.getValue().equals("Active")) {
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Active);
            this.requestStatusTypeRP.set(0, (Object)this.requestStatusType);
        }
        if (failedTransfers > 0 && !reqStatus.getValue().equals("Failed")) {
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Failed);
            this.requestStatusType.setFault(this.fault);
            this.requestStatusTypeRP.set(0, (Object)this.requestStatusType);
            return;
        }
        if (totalTransfers == finishedTransfers) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getTransferIdentifiers() + "setting status RP to Done"));
            }
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Done);
            this.requestStatusTypeRP.set(0, (Object)this.requestStatusType);
            return;
        }
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopActiveTransfers(int requestId, int fromId, int toId) {
        Vector vector = transferClients;
        synchronized (vector) {
            for (int i = 0; i < transferClients.size(); ++i) {
                TransferClient transferClient = (TransferClient)transferClients.elementAt(i);
                int transferRequestId = transferClient.getRequestId();
                int transferClientStatus = transferClient.getStatus();
                if (transferRequestId != requestId || transferClientStatus != 3) continue;
                int transferId = transferClient.getTransferID();
                if (transferId >= fromId && transferId <= toId) {
                    transferClient.close();
                    transferClient.setStatus(5);
                    continue;
                }
                transferClient.close();
                transferClient.setStatus(5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTransferClients(int requestId) {
        Vector closingTransferClients = new Vector();
        Vector vector = transferClients;
        synchronized (vector) {
            for (int i = 0; i < transferClients.size(); ++i) {
                TransferClient closeMe = (TransferClient)transferClients.elementAt(i);
                if (closeMe.getRequestId() != requestId) continue;
                closingTransferClients.add(transferClients.remove(i));
                if (i > 0) {
                    --i;
                }
                logger.debug((Object)("Closing all clients for request: " + requestId));
            }
        }
        for (int i = 0; i < closingTransferClients.size(); ++i) {
            TransferClient temp = (TransferClient)closingTransferClients.elementAt(i);
            temp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDeleteClients(int requestId) {
        Vector closingDeleteClients = new Vector();
        Vector vector = deleteClients;
        synchronized (vector) {
            for (int i = 0; i < deleteClients.size(); ++i) {
                DeleteClient closeMeDel = (DeleteClient)deleteClients.elementAt(i);
                if (closeMeDel.getRequestId() != requestId) continue;
                closingDeleteClients.add(deleteClients.remove(i));
                if (i <= 0) continue;
                --i;
            }
        }
        for (int i = 0; i < closingDeleteClients.size(); ++i) {
            DeleteClient temp = (DeleteClient)closingDeleteClients.elementAt(i);
            temp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransferClient getTransferClient() throws RftException, RftTransientException, RftDBException {
        TransferClient temp = null;
        GlobusURL sourceURL = null;
        GlobusURL destURL = null;
        boolean reuse = false;
        try {
            sourceURL = new GlobusURL(this.transferJob.getSourceUrl());
            if (!sourceURL.getProtocol().equalsIgnoreCase("gsiftp")) {
                throw new RftException("Only 3rd party transfers supported");
            }
            destURL = new GlobusURL(this.transferJob.getDestinationUrl());
            if (!destURL.getProtocol().equalsIgnoreCase("gsiftp")) {
                throw new RftException("Only 3rd party transfers supported");
            }
        }
        catch (MalformedURLException mue) {
            throw new RftException(mue);
        }
        logger.debug((Object)(this.getTransferIdentifiers() + "transferring " + this.transferJob.getSourceUrl() + "  ->  " + this.transferJob.getDestinationUrl()));
        Vector vector = transferClients;
        synchronized (vector) {
            int i;
            for (i = 0; i < transferClients.size(); ++i) {
                temp = (TransferClient)transferClients.elementAt(i);
                if (!temp.checkForReuse(this.requestId, sourceURL, destURL)) continue;
                reuse = true;
                break;
            }
            if (reuse && transferClients.size() > 0) {
                temp = (TransferClient)transferClients.remove(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getTransferIdentifiers() + "reusing transfer client " + transferClients.size()));
                }
                temp.setSourcePath(sourceURL.getPath());
                temp.setDestinationPath("/" + destURL.getPath());
                temp.setSourceURL(sourceURL);
                temp.setDestinationURL(destURL);
                if (temp.getStatus() != 2) {
                    temp.setStatus(3);
                }
            }
        }
        if (!reuse) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getTransferIdentifiers() + "no client to reuse"));
            }
            temp = this.getNewClient();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteClient getDeleteClient() throws RftDBException, RftException, RftTransientException {
        DeleteClient temp = null;
        GlobusURL sourceURL = null;
        boolean reuse = false;
        try {
            sourceURL = new GlobusURL(this.transferJob.getSourceUrl());
        }
        catch (MalformedURLException mue) {
            throw new RftException(mue);
        }
        logger.debug((Object)(this.getTransferIdentifiers() + "deleting " + this.transferJob.getSourceUrl()));
        Vector vector = deleteClients;
        synchronized (vector) {
            int i;
            for (i = 0; i < deleteClients.size(); ++i) {
                temp = (DeleteClient)deleteClients.elementAt(i);
                if (!temp.checkForReuse(this.transferJob.getSourceUrl(), this.requestId)) continue;
                reuse = true;
                break;
            }
            if (reuse) {
                temp = (DeleteClient)deleteClients.remove(i);
                temp.setFileURL(sourceURL.getPath());
                if (temp.getStatus() != 2) {
                    this.status = temp.getStatus();
                }
            }
        }
        if (!reuse) {
            temp = new DeleteClient(this.transferJob.getSourceUrl(), this.transferJob.getRftOptions().getSourceSubjectName(), this.resourceManager.getCredential(), this.transferJob.getRftOptions().getUserName());
        }
        temp.setRequestId(this.requestId);
        return temp;
    }

    private TransferClient getNewClient() throws RftException, RftTransientException, RftDBException {
        logger.debug((Object)("max active allowed: " + RFTDatabaseSetup.maxActive));
        TransferClient temp = new TransferClient();
        String userName = this.resourceManager.getUserName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transfer " + this.transferJob.getTransferId() + ": " + "new transfer client for user: " + userName));
        }
        temp.setUserName(userName);
        temp.setSourceHost(this.transferJob.getSourceUrl());
        temp.setDestinationHost(this.transferJob.getDestinationUrl());
        temp.setOptions(this.transferJob.getRftOptions());
        temp.setCredential(this.resourceManager.getCredential());
        temp.authorize();
        temp.authenticate();
        temp.setRFTOptions();
        temp.setRequestId(this.requestId);
        temp.setModeE();
        temp.setStriping();
        temp.setStatus(3);
        return temp;
    }

    private void setFault(Exception e) {
        if (e instanceof RftTransientException) {
            this.fault = FaultUtil.createTransferTransientFault(this.requestId, e.getMessage(), e);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setting transient fault");
            }
            this.requestStatusType.setFault(this.fault);
            this.overallStatus.setFault(this.fault);
        }
        if (e instanceof RftException) {
            this.fault = FaultUtil.createTransferFault(this.requestId, e.getMessage(), e);
            this.requestStatusType.setFault(this.fault);
            this.overallStatus.setFault(this.fault);
        }
        if (e instanceof RftDBException) {
            this.fault = FaultUtil.createRFTDatabaseFault(this.requestId, e);
            this.requestStatusType.setFault(this.fault);
            this.overallStatus.setFault(this.fault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStates() {
        int transferId = this.transferJob.getTransferId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getTransferIdentifiers() + "processing state for transfer of " + this.transferJob.getSourceUrl() + "  ->  " + this.transferJob.getDestinationUrl()));
        }
        switch (this.status) {
            case 0: {
                Vector vector;
                this.resourceManager.decrementActive();
                logger.debug((Object)(this.getTransferIdentifiers() + "transfer done"));
                if (this.transferClient != null) {
                    vector = transferClients;
                    synchronized (vector) {
                        transferClients.add(this.transferClient);
                    }
                }
                if (this.deleteClient != null) {
                    vector = deleteClients;
                    synchronized (vector) {
                        deleteClients.add(this.deleteClient);
                    }
                }
                this.statusChanged(0);
                break;
            }
            case 2: {
                this.resourceManager.decrementActive();
                logger.debug((Object)(this.getTransferIdentifiers() + "transfer failed"));
                this.statusChanged(2);
                try {
                    if (this.dbAdapter.getAllOrNone(this.requestId)) {
                        TransferWork.stopActiveTransfers(this.requestId, -1, -1);
                        this.dbAdapter.updateToDirty(this.requestId);
                    }
                }
                catch (RftDBException rftdbe) {
                    logger.error((Object)i18n.getMessage("dbRetrieveErr"), (Throwable)((Object)rftdbe));
                }
                if (this.transferClient == null) break;
                this.transferClient.close();
                break;
            }
            case 1: {
                this.resourceManager.decrementActive();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getTransferIdentifiers() + "retry attempt " + this.transferJob.getAttempts() + " of " + this.maxAttempts));
                }
                if (this.transferJob.getAttempts() >= this.maxAttempts) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Transfer " + transferId + ": " + "transfer failed (retried " + this.transferJob.getAttempts() + " times)"));
                    }
                    this.statusChanged(2);
                } else {
                    this.statusChanged(1);
                }
                if (this.transferClient == null) break;
                this.transferClient.close();
                break;
            }
            case 6: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getTransferIdentifiers() + "expanding the url: " + this.transferJob.getSourceUrl()));
                }
                this.statusChanged(6);
                URLExpander expander = null;
                if (this.transferClient != null) {
                    expander = this.transferClient.getUrlExpander();
                } else if (this.deleteClient != null) {
                    expander = this.deleteClient.getUrlExpander();
                }
                if (expander != null) {
                    boolean expStatus = expander.getStatus();
                    while (!expStatus) {
                        try {
                            expander.join();
                            expStatus = expander.getStatus();
                        }
                        catch (InterruptedException ee) {
                            logger.error((Object)i18n.getMessage("urlExpansionErr"), (Throwable)ee);
                        }
                    }
                }
                this.resourceManager.setNumberOfTransfers(expander.getNumberOfTransfers());
                this.statusChanged(7);
                this.resourceManager.decrementActive();
                expander.close();
                this.startDirTransfer();
                break;
            }
        }
    }

    private void startDirTransfer() {
        int concurrency = this.resourceManager.getConcurrency();
        for (int activeTransfers = this.resourceManager.getActive(); activeTransfers < concurrency; ++activeTransfers) {
            this.startNewTransfer();
        }
    }

    private synchronized void startNewTransfer() {
        try {
            TransferType newTransferJob = this.resourceManager.getNext();
            if (newTransferJob != null) {
                TransferWork newTransferWork = new TransferWork(this.requestId, this.rpSet, newTransferJob);
                newTransferWork.setWorkManager(this.workManager);
                newTransferWork.setResourceManager(this.resourceManager);
                this.workManager.schedule((Work)newTransferWork);
            } else {
                long retryTime;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PerformanceLog All transfers done for " + this.requestId));
                }
                if ((retryTime = this.dbAdapter.getMinimumPollTime()) != 0L) {
                    RFTDatabasePoller dbPoller = new RFTDatabasePoller(retryTime, this.rpSet, this.requestId, this.resourceManager);
                    this.workManager.schedule((Work)dbPoller);
                }
                if (this.dbAdapter.checkAllDone(this.requestId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.getTransferIdentifiers() + "all transfers of " + this.requestId + " are done"));
                    }
                    TransferWork.closeTransferClients(this.requestId);
                    TransferWork.closeDeleteClients(this.requestId);
                }
            }
        }
        catch (RftDBException dbe) {
            logger.error((Object)(i18n.getMessage("dbRetrieveErr") + dbe.getMessage()), (Throwable)((Object)dbe));
            this.setFault((Exception)((Object)dbe));
            this.statusChanged(2);
        }
        catch (WorkException we) {
            logger.error((Object)i18n.getMessage("unableToScheduleErr"), (Throwable)we);
            this.setFault((Exception)((Object)we));
            this.statusChanged(2);
        }
    }

    private boolean checkDelete() {
        boolean returnValue = false;
        String transferType = this.transferJob.getStatus().getValue();
        String destUrl = this.transferJob.getDestinationUrl();
        if (destUrl == null) {
            returnValue = true;
        }
        if (transferType.equals("Dirty") && destUrl != null) {
            this.transferJob.setSourceUrl(this.transferJob.getDestinationUrl());
            returnValue = true;
        }
        return returnValue;
    }

    public void run() {
        try {
            int transferId = this.transferJob.getTransferId();
            this.attempts = this.transferJob.getAttempts();
            ++this.attempts;
            this.transferJob.setAttempts(new Integer(this.attempts));
            if (this.checkDelete()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("This is a delete:" + transferId));
                }
                this.deleteClient = this.getDeleteClient();
                this.statusChanged(3);
                this.deleteClient.delete();
                this.status = this.deleteClient.getStatus();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("This is a transfer:" + transferId));
                }
                this.transferClient = this.getTransferClient();
                if (this.transferClient == null) {
                    return;
                }
                this.statusChanged(3);
                this.transferJob.setAttempts(new Integer(this.attempts));
                boolean restart = false;
                String restartMarker = this.dbAdapter.getRestartMarker(transferId);
                this.transferClient.setTransferId(transferId);
                if (restartMarker != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.getTransferIdentifiers() + "setting restart marker: " + restartMarker));
                    }
                    this.transferClient.setRestartMarker(restartMarker);
                    restart = true;
                }
                this.transferClient.setRequestId(this.requestId);
                this.transferClient.setResourcePropertySet(this.rpSet);
                this.transferClient.transfer(restart);
                this.status = this.transferClient.getStatus();
            }
        }
        catch (RftDBException dbe) {
            logger.error((Object)i18n.getMessage("dbRetrieveErr"), (Throwable)((Object)dbe));
            this.status = 2;
            this.setFault((Exception)((Object)dbe));
        }
        catch (RftException rfe) {
            logger.error((Object)(i18n.getMessage("terminalTransferErr") + rfe.getMessage()), (Throwable)((Object)rfe));
            this.status = 2;
            this.setFault((Exception)((Object)rfe));
        }
        catch (RftTransientException rfte) {
            logger.error((Object)(i18n.getMessage("transientTransferErr") + rfte.getMessage()), (Throwable)((Object)rfte));
            this.status = 1;
            this.setFault((Exception)((Object)rfte));
        }
        this.processStates();
        this.startNewTransfer();
    }

    private String getTransferIdentifiers() {
        return "[Request " + this.requestId + ", Transfer " + this.transferJob.getTransferId() + "] ";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

