/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.ByteRangeList;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.GridFTPRestartMarker;
import org.globus.ftp.HostPortList;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.MlsxEntry;
import org.globus.ftp.Options;
import org.globus.ftp.RestartData;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.rft.generated.TotalBytesTransferredResource;
import org.globus.transfer.reliable.service.MyMarkerListener;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.URLExpander;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.transfer.reliable.service.exception.RftTransientException;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.globus.util.Util;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.ietf.jgss.GSSCredential;

public class TransferClient {
    private GridFTPClient sourceHost;
    private GridFTPClient destinationHost;
    private String sourcePath;
    private String destinationPath;
    private int status = -1;
    private int transferid;
    private int parallelism;
    private int tcpBufferSize;
    private GSSCredential credential;
    private GlobusURL sourceGlobusURL;
    private GlobusURL destinationGlobusURL;
    private long size;
    private RFTOptionsType rftOptions;
    private String sourceSubjectName;
    private String destinationSubjectName;
    private MyMarkerListener markerListener;
    private URLExpander urlExpander;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$TransferClient == null ? (class$org$globus$transfer$reliable$service$TransferClient = TransferClient.class$("org.globus.transfer.reliable.service.TransferClient")) : class$org$globus$transfer$reliable$service$TransferClient).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$TransferClient == null ? (class$org$globus$transfer$reliable$service$TransferClient = TransferClient.class$("org.globus.transfer.reliable.service.TransferClient")) : class$org$globus$transfer$reliable$service$TransferClient).getClassLoader());
    private int requestId = 0;
    private ResourcePropertySet rpSet;
    private ResourceProperty totalBytesTransferredRP;
    private TotalBytesTransferredResource totalBytes;
    private String userName = null;
    private String permissions = null;
    private int attempts = 1;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$TransferClient;

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void setResourcePropertySet(ResourcePropertySet rpSet) {
        this.rpSet = rpSet;
        this.totalBytesTransferredRP = this.rpSet.get(RFTConstants.TOTAL_BYTES_RESOURCE);
        this.totalBytes = (TotalBytesTransferredResource)this.totalBytesTransferredRP.get(0);
    }

    public void setSourceHost(String sourceURL) throws RftException, RftTransientException, RftDBException {
        try {
            this.sourceGlobusURL = new GlobusURL(sourceURL);
            if (!this.sourceGlobusURL.getProtocol().equalsIgnoreCase("gsiftp")) {
                throw new RftException(i18n.getMessage("thirdPartyOnlyErr"));
            }
        }
        catch (MalformedURLException mue) {
            this.setStatus(2);
            logger.error((Object)(i18n.getMessage("invalidUrlErr") + sourceURL));
            throw new RftException(i18n.getMessage("invalidUrlErr"), mue);
        }
        try {
            this.sourceHost = new GridFTPClient(this.sourceGlobusURL.getHost(), this.sourceGlobusURL.getPort());
            this.sourcePath = "/" + this.sourceGlobusURL.getPath();
        }
        catch (ConnectException ce) {
            logger.error((Object)i18n.getMessage("unableToConnectErr", new Object[]{this.sourceGlobusURL.getHost(), Integer.toString(this.sourceGlobusURL.getPort())}));
            this.setStatus(1);
            ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.sourceGlobusURL.getHost() + ":" + this.sourceGlobusURL.getPort());
            throw new RftTransientException(i18n.getMessage("unableToConnectErr", new Object[]{this.sourceGlobusURL.getHost(), Integer.toString(this.sourceGlobusURL.getPort())}));
        }
        catch (Exception e) {
            this.setStatus(2);
            logger.error((Object)i18n.getMessage("unableToConnectErr", new Object[]{this.sourceGlobusURL.getHost(), Integer.toString(this.sourceGlobusURL.getPort())}));
            throw new RftException(i18n.getMessage("unableToConnectErr", new Object[]{this.sourceGlobusURL.getHost(), Integer.toString(this.sourceGlobusURL.getPort())}));
        }
    }

    public void setDestinationHost(String destURL) throws RftException, RftTransientException, RftDBException {
        try {
            this.destinationGlobusURL = new GlobusURL(destURL);
            if (!this.destinationGlobusURL.getProtocol().equalsIgnoreCase("gsiftp")) {
                throw new RftException(i18n.getMessage("thirdPartyOnlyErr"));
            }
        }
        catch (MalformedURLException mue) {
            this.setStatus(2);
            logger.error((Object)(i18n.getMessage("invalidUrlErr") + destURL));
            throw new RftException(i18n.getMessage("invalidUrlErr", (Object)destURL), mue);
        }
        try {
            this.destinationHost = new GridFTPClient(this.destinationGlobusURL.getHost(), this.destinationGlobusURL.getPort());
            this.destinationPath = "/" + this.destinationGlobusURL.getPath();
        }
        catch (ConnectException ce) {
            logger.error((Object)i18n.getMessage("unableToConnectErr", new Object[]{this.destinationGlobusURL.getHost(), Integer.toString(this.destinationGlobusURL.getPort())}));
            this.setStatus(1);
            ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.destinationGlobusURL.getHost() + ":" + this.destinationGlobusURL.getPort());
            throw new RftTransientException(i18n.getMessage("unableToConnectErr", new Object[]{this.destinationGlobusURL.getHost(), Integer.toString(this.destinationGlobusURL.getPort())}));
        }
        catch (Exception e) {
            this.setStatus(2);
            logger.error((Object)i18n.getMessage("unableToConnectErr", new Object[]{this.destinationGlobusURL.getHost(), Integer.toString(this.destinationGlobusURL.getPort())}));
            throw new RftException(i18n.getMessage("unableToConnectErr", new Object[]{this.destinationGlobusURL.getHost(), Integer.toString(this.destinationGlobusURL.getPort())}));
        }
    }

    public GlobusURL getSourceURL() {
        return this.sourceGlobusURL;
    }

    public void setSourceURL(GlobusURL sourceGlobusURL) {
        this.sourceGlobusURL = sourceGlobusURL;
    }

    public GlobusURL getDestinationURL() {
        return this.destinationGlobusURL;
    }

    public void setDestinationURL(GlobusURL destinationGlobusURL) {
        this.destinationGlobusURL = destinationGlobusURL;
    }

    public synchronized void setStatus(int status) {
        this.status = status;
    }

    public void setCredential(GSSCredential credential) {
        this.credential = credential;
    }

    public void setTransferId(int transferId) {
        this.transferid = transferId;
    }

    public long getSize() {
        return this.size;
    }

    public URLExpander getUrlExpander() {
        return this.urlExpander;
    }

    public boolean checkForReuse(int requestId, GlobusURL targetSource, GlobusURL targetDest) {
        boolean reuse = false;
        if (this.requestId == requestId && this.sourceGlobusURL.getHost().equals(targetSource.getHost()) && this.destinationGlobusURL.getHost().equals(targetDest.getHost()) && this.sourceGlobusURL.getPort() == targetSource.getPort() && this.destinationGlobusURL.getPort() == targetDest.getPort()) {
            reuse = true;
        }
        return reuse;
    }

    public void authorize() throws RftException {
        try {
            String subjectName = this.rftOptions.getSubjectName();
            this.sourceSubjectName = this.rftOptions.getSourceSubjectName();
            this.destinationSubjectName = this.rftOptions.getDestinationSubjectName();
            if (subjectName != null) {
                this.sourceSubjectName = subjectName;
                this.destinationSubjectName = subjectName;
            }
            this.authorizeSource();
            this.authorizeDestination();
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("authzErr") + e.getMessage()), (Throwable)e);
            this.setStatus(2);
            throw new RftException(i18n.getMessage("authzErr") + e.getMessage(), e);
        }
    }

    private void authorizeSource() {
        if (this.sourceSubjectName != null && !this.sourceSubjectName.equals("null") && !this.sourceSubjectName.trim().equals("")) {
            this.sourceHost.setAuthorization((Authorization)new IdentityAuthorization(this.sourceSubjectName));
        }
    }

    private void authorizeDestination() {
        if (this.destinationSubjectName != null && !this.destinationSubjectName.equals("null") && !this.destinationSubjectName.trim().equals("")) {
            this.destinationHost.setAuthorization((Authorization)new IdentityAuthorization(this.destinationSubjectName));
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public void setDestinationPath(String destPath) {
        this.destinationPath = destPath;
    }

    public int getTransferID() {
        return this.transferid;
    }

    public synchronized void setSourcePath(String sourcePath) {
        this.sourcePath = "/" + sourcePath;
    }

    public void setOptions(RFTOptionsType rftOptions) {
        this.rftOptions = rftOptions;
    }

    public void setRFTOptions() throws RftException {
        try {
            this.parallelism = this.rftOptions.getParallelStreams();
            this.tcpBufferSize = this.rftOptions.getTcpBufferSize();
            if (this.parallelism == 0) {
                this.parallelism = 1;
            }
            if (this.tcpBufferSize == 0) {
                this.tcpBufferSize = 16384;
            }
            this.setSourceOptions();
            this.setDestinationOptions();
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("transferOptionsErr") + e.getMessage()), (Throwable)e);
            throw new RftException(i18n.getMessage("transferOptionsErr") + e.getMessage(), e);
        }
    }

    private void setSourceOptions() throws ServerException, IOException {
        if (!this.sourcePath.endsWith("/")) {
            this.sourceHost.setOptions((Options)new RetrieveOptions(this.parallelism));
            this.sourceHost.setTCPBufferSize(this.tcpBufferSize);
        }
        if (this.rftOptions.getBinary().booleanValue()) {
            this.sourceHost.setType(1);
        } else {
            this.sourceHost.setType(2);
        }
        if (this.rftOptions.getDcau().booleanValue()) {
            this.sourceHost.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            this.sourceHost.setProtectionBufferSize(16384);
        } else {
            this.sourceHost.setDataChannelAuthentication(DataChannelAuthentication.NONE);
        }
    }

    private void setDestinationOptions() throws ServerException, IOException {
        this.destinationHost.setOptions((Options)new RetrieveOptions(this.parallelism));
        this.destinationHost.setTCPBufferSize(this.tcpBufferSize);
        if (this.rftOptions.getBinary().booleanValue()) {
            this.destinationHost.setType(1);
        } else {
            this.destinationHost.setType(2);
        }
        if (this.rftOptions.getDcau().booleanValue()) {
            this.destinationHost.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            this.destinationHost.setProtectionBufferSize(16384);
        } else {
            this.destinationHost.setDataChannelAuthentication(DataChannelAuthentication.NONE);
        }
    }

    public void authenticate() throws RftException {
        this.authenticateSource();
        this.authenticateDestination();
    }

    private void authenticateSource() throws RftException {
        try {
            String tempUserName = this.rftOptions.getUserName();
            if (tempUserName != null && !tempUserName.equalsIgnoreCase("null")) {
                this.sourceHost.authenticate(this.credential, tempUserName);
            } else {
                this.sourceHost.authenticate(this.credential);
            }
        }
        catch (Exception e) {
            this.setStatus(2);
            throw new RftException(i18n.getMessage("authErr") + e.getMessage(), e);
        }
    }

    private void authenticateDestination() throws RftException {
        try {
            String tempUserName = this.rftOptions.getUserName();
            if (tempUserName != null && !tempUserName.equalsIgnoreCase("null")) {
                this.destinationHost.authenticate(this.credential, tempUserName);
            } else {
                this.destinationHost.authenticate(this.credential);
            }
        }
        catch (Exception e) {
            this.setStatus(2);
            throw new RftException(i18n.getMessage("authErr") + e.getMessage(), e);
        }
    }

    public void setModeE() throws RftException {
        try {
            if (!this.rftOptions.getNotpt().booleanValue()) {
                this.sourceHost.setMode(3);
                this.destinationHost.setMode(3);
            }
        }
        catch (Exception e) {
            this.setStatus(2);
            throw new RftException(i18n.getMessage("transferOptionsErr") + e.getMessage(), e);
        }
    }

    public void setRestartMarker(String marker) {
        try {
            marker = "Range Marker " + marker;
            GridFTPRestartMarker restartmarker = new GridFTPRestartMarker(marker);
            ByteRangeList list = new ByteRangeList();
            list.merge(restartmarker.toVector());
            this.sourceHost.setRestartMarker((RestartData)list);
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("restartMarkerErr") + e.getMessage()), (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.sourceHost != null) {
                this.sourceHost.close(true);
            }
            if (this.destinationHost != null) {
                this.destinationHost.close(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("closeClientErr") + e.getMessage()), (Throwable)e);
        }
    }

    private void updatePermissions() throws RftException {
        try {
            MlsxEntry entry = this.sourceHost.mlst(this.sourcePath);
            this.size = Long.parseLong(entry.get("size"));
            this.permissions = entry.get("unix.mode");
            ReliableFileTransferDbAdapter.getDbAdapter().updateTransfer(this.transferid, this.size, this.permissions);
        }
        catch (Exception ioe) {
            logger.error((Object)(i18n.getMessage("updatePermsErr") + this.sourcePath), (Throwable)ioe);
            if (this.rftOptions.getIgnoreFilePermErr().booleanValue()) {
                logger.error((Object)"MLST is not supported, But thats ok");
            }
            this.setStatus(2);
            throw new RftException(i18n.getMessage("updatePermsErr") + this.sourcePath, ioe);
        }
    }

    public void transfer(boolean useExtended) throws RftException, RftTransientException {
        if (this.sourcePath.endsWith("/")) {
            this.setStatus(6);
            try {
                this.urlExpander = new URLExpander(this.sourceHost, this.destinationHost, this.sourceGlobusURL, this.destinationGlobusURL, this.rftOptions);
                this.urlExpander.setRequestId(this.requestId);
                this.urlExpander.start();
                return;
            }
            catch (Exception e) {
                logger.error((Object)(i18n.getMessage("terminalTransferErr") + e.getMessage()), (Throwable)e);
                this.setStatus(2);
                throw new RftException(i18n.getMessage("dirExpansionErr"), e);
            }
        }
        boolean noThirdParty = this.rftOptions.getNotpt();
        this.markerListener = new MyMarkerListener(this.transferid, this.size);
        if (noThirdParty) {
            this.updatePermissions();
            if (useExtended) {
                this.noThirdPartyExtendedTransfer();
            } else {
                this.noThirdPartyNonExtendedTransfer();
            }
            this.setPermissions();
        } else {
            this.updatePermissions();
            if (useExtended) {
                this.normalExtendedTransfer();
            } else {
                this.normalNonExtendedTransfer();
            }
            this.setPermissions();
        }
        if (this.status != 1) {
            this.setStatus(0);
            long temp = this.totalBytes.getTotalBytes() + this.size;
            this.totalBytes.setTotalBytes(temp);
            this.totalBytesTransferredRP.set(0, (Object)this.totalBytes);
        }
    }

    public void deleteDestination() {
        String file = this.destinationPath;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleting " + file));
            }
            this.destinationHost.deleteFile(file);
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("deleteFileErr", (Object)file), (Throwable)e);
        }
    }

    private void setPermissions() throws RftException {
        block5: {
            try {
                if (this.permissions != null) {
                    String command = "CHMOD " + this.permissions + " " + this.destinationPath;
                    this.destinationHost.site(command);
                    break block5;
                }
                if (this.rftOptions.getIgnoreFilePermErr().booleanValue()) {
                    logger.error((Object)"Not setting file perms");
                    break block5;
                }
                throw new RftException("Permissions are null");
            }
            catch (Exception e) {
                logger.error((Object)(i18n.getMessage("setPermsErr", (Object)this.destinationPath) + e.getMessage()), (Throwable)e);
                if (this.rftOptions.getIgnoreFilePermErr().booleanValue()) {
                    logger.error((Object)"Unable to set permissions, But thats ok");
                }
                this.setStatus(2);
                throw new RftException(i18n.getMessage("setPermsErr", (Object)this.destinationPath) + e.getMessage(), e);
            }
        }
    }

    public void setStriping() throws RftException {
        try {
            if (!this.rftOptions.getNotpt().booleanValue()) {
                boolean striping = false;
                if (this.sourceHost.isFeatureSupported("SPOR") && this.destinationHost.isFeatureSupported("SPAS")) {
                    striping = true;
                }
                if (striping) {
                    HostPortList hpl = this.destinationHost.setStripedPassive();
                    this.sourceHost.setStripedActive(hpl);
                }
            }
        }
        catch (Exception e) {
            throw new RftException("Exception in Striping", e);
        }
    }

    private void noThirdPartyNonExtendedTransfer() throws RftTransientException {
        try {
            File fullLocalFile = File.createTempFile("TempRFT", String.valueOf(this.transferid));
            Util.setOwnerAccessOnly((String)fullLocalFile.getAbsolutePath());
            fullLocalFile.deleteOnExit();
            FileRandomIO sink = null;
            sink = new FileRandomIO(new RandomAccessFile(fullLocalFile, "rw"));
            this.sourceHost.get(this.sourcePath, (DataSink)sink, (MarkerListener)this.markerListener);
            FileRandomIO source = null;
            source = new FileRandomIO(new RandomAccessFile(fullLocalFile, "r"));
            this.destinationHost.put(this.destinationPath, (DataSource)source, (MarkerListener)this.markerListener);
            if (fullLocalFile.exists()) {
                fullLocalFile.delete();
            }
        }
        catch (Exception e) {
            this.setStatus(1);
            logger.error((Object)"Exception in transfer", (Throwable)e);
            try {
                ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.transferid, this.attempts);
            }
            catch (RftDBException ee) {
                logger.error((Object)(i18n.getMessage("dbUpdateErr") + ee.getMessage()), (Throwable)((Object)ee));
            }
            throw new RftTransientException(i18n.getMessage("transientTransferErr") + e.getMessage(), e);
        }
    }

    private void noThirdPartyExtendedTransfer() throws RftTransientException, RftException {
        try {
            File fullLocalFile = File.createTempFile("TempRFT", String.valueOf(this.transferid));
            Util.setOwnerAccessOnly((String)fullLocalFile.getAbsolutePath());
            FileRandomIO sink = null;
            sink = new FileRandomIO(new RandomAccessFile(fullLocalFile, "rw"));
            this.sourceHost.extendedGet(this.sourcePath, this.size, (DataSink)sink, (MarkerListener)this.markerListener);
            FileRandomIO source = null;
            source = new FileRandomIO(new RandomAccessFile(fullLocalFile, "r"));
            this.destinationHost.extendedPut(this.destinationPath, (DataSource)source, (MarkerListener)this.markerListener);
            if (fullLocalFile.exists()) {
                fullLocalFile.delete();
            }
        }
        catch (Exception e) {
            this.setStatus(1);
            logger.error((Object)"Exception in transfer", (Throwable)e);
            try {
                ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.transferid, this.attempts);
            }
            catch (RftDBException ee) {
                logger.error((Object)(i18n.getMessage("dbUpdateErr") + ee.getMessage()), (Throwable)((Object)ee));
            }
            throw new RftTransientException(i18n.getMessage("transientTransferErr") + e.getMessage(), e);
        }
    }

    private void normalExtendedTransfer() throws RftTransientException {
        try {
            this.sourceHost.extendedTransfer(this.sourcePath, this.destinationHost, this.destinationPath, (MarkerListener)this.markerListener);
        }
        catch (Exception e) {
            this.setStatus(1);
            logger.error((Object)"Exception in transfer", (Throwable)e);
            try {
                ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.transferid, this.attempts);
            }
            catch (RftDBException ee) {
                logger.error((Object)(i18n.getMessage("dbUpdateErr") + ee.getMessage()), (Throwable)((Object)ee));
            }
            throw new RftTransientException(i18n.getMessage("transientTransferErr") + e.getMessage(), e);
        }
    }

    private void normalNonExtendedTransfer() throws RftTransientException {
        try {
            this.sourceHost.transfer(this.sourcePath, (FTPClient)this.destinationHost, this.destinationPath, false, (MarkerListener)this.markerListener);
        }
        catch (Exception e) {
            this.setStatus(1);
            logger.error((Object)"Exception in transfer", (Throwable)e);
            try {
                ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.transferid, this.attempts);
            }
            catch (RftDBException ee) {
                logger.error((Object)(i18n.getMessage("dbUpdateErr") + ee.getMessage()), (Throwable)((Object)ee));
            }
            throw new RftTransientException(i18n.getMessage("transientTransferErr") + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

