/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import commonj.work.WorkManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationListener;
import org.globus.delegation.DelegationUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.rft.generated.BaseRequestType;
import org.globus.rft.generated.DeleteRequestType;
import org.globus.rft.generated.OverallStatus;
import org.globus.rft.generated.ReliableTransferProperties;
import org.globus.rft.generated.RequestStatusType;
import org.globus.rft.generated.RequestStatusTypeEnumeration;
import org.globus.rft.generated.TotalBytesTransferredResource;
import org.globus.rft.generated.TotalTimeTakenResource;
import org.globus.rft.generated.TransferRequestType;
import org.globus.security.gridmap.GridMap;
import org.globus.transfer.reliable.service.CredentialRefreshListener;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.RFTRecoveryData;
import org.globus.transfer.reliable.service.RFTResourceManager;
import org.globus.transfer.reliable.service.ReliableFileTransferHome;
import org.globus.transfer.reliable.service.TransferWork;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.transfer.reliable.service.usage.RFTUsageMonitorPacket;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.container.UsageConfig;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.ResourcePropertyTopic;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.globus.wsrf.utils.SubscriptionPersistenceUtils;

public class ReliableFileTransferResource
extends ReflectionResource
implements TopicListAccessor,
ResourceProperties,
ResourceLifetime,
Resource,
SecureResource,
RemoveCallback,
PersistenceCallback {
    String HOME_LOCATION = "java:comp/env//services/ReliableFileTransferService/home";
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$ReliableFileTransferResource == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferResource = ReliableFileTransferResource.class$("org.globus.transfer.reliable.service.ReliableFileTransferResource")) : class$org$globus$transfer$reliable$service$ReliableFileTransferResource).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$ReliableFileTransferResource == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferResource = ReliableFileTransferResource.class$("org.globus.transfer.reliable.service.ReliableFileTransferResource")) : class$org$globus$transfer$reliable$service$ReliableFileTransferResource).getClassLoader());
    private ResourcePropertySet propSet;
    private TopicList topicList;
    private ResourceSecurityDescriptor desc = null;
    private Calendar terminationTime = null;
    private Calendar resourceCreationTime = null;
    private ResourceKey key;
    private int requestId = 0;
    private ResourceProperty overallStatusRP;
    private ResourceProperty totalBytesTransferredRP;
    private ResourceProperty requestStatusRP;
    private ResourceProperty totalTimeTakenResourceRP;
    private TotalBytesTransferredResource totalBytesTransferred;
    private OverallStatus overallStatus;
    private RequestStatusType requestStatusType;
    private RequestStatusTypeEnumeration requestStatusTypeEnumeration;
    private TotalTimeTakenResource totalTimeTakenType;
    private int size = 0;
    private ReliableFileTransferDbAdapter dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
    private TransferRequestType transferRequest;
    private DeleteRequestType deleteRequest;
    private int concurrency = 1;
    private WorkManager workManager;
    private boolean started = false;
    private int maxAttempts = 5;
    private FilePersistenceHelper persistenceHelper;
    private static String SUBSCRIPTION_FILE = System.getProperty("file.separator") + "rft-subscriptions-";
    private boolean delete = false;
    private RFTResourceManager resourceManager;
    private GlobusCredential credential;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$ReliableFileTransferResource;
    static /* synthetic */ Class class$org$globus$rft$generated$ReliableTransferProperties;

    public ReliableFileTransferResource() {
    }

    public ReliableFileTransferResource(BaseRequestType req, String userSubject, String localUserId, Calendar initialTerminationTime) throws Exception {
        Integer tempMaxAttempts;
        if (req instanceof TransferRequestType) {
            this.transferRequest = (TransferRequestType)req;
            this.requestId = this.dbAdapter.storeTransferRequest(this.transferRequest, initialTerminationTime, localUserId, userSubject);
            this.size = this.transferRequest.getTransfer().length;
        } else if (req instanceof DeleteRequestType) {
            this.delete = true;
            this.deleteRequest = (DeleteRequestType)req;
            this.requestId = this.dbAdapter.storeDeleteRequest(this.deleteRequest, initialTerminationTime, localUserId, userSubject);
            if (this.deleteRequest.getDeletion() != null) {
                this.size = this.deleteRequest.getDeletion().length;
            } else {
                logger.error((Object)i18n.getMessage("nullRequestErr"));
                throw new RftException(i18n.getMessage("nullRequestErr"));
            }
        }
        Integer tempConcurrency = req.getConcurrency();
        if (tempConcurrency != null && req.getConcurrency() > 0) {
            this.concurrency = req.getConcurrency();
        }
        if ((tempMaxAttempts = req.getMaxAttempts()) != null && req.getMaxAttempts() > 0) {
            this.maxAttempts = req.getMaxAttempts();
        }
        this.setSecurityDescriptor(userSubject, localUserId);
    }

    public boolean isDelete() {
        return this.delete;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setCredential(GlobusCredential credential) throws RftException {
        this.credential = credential;
        try {
            if (this.resourceManager != null) {
                this.resourceManager.setCredential(this.credential);
            }
        }
        catch (Exception e) {
            throw new RftException(i18n.getMessage("delegationCredErr"), e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void storeSubscriptions() throws Exception {
        FileOutputStream fos = null;
        File tmpFile = null;
        String fileName = SUBSCRIPTION_FILE + this.requestId + ".tmp";
        tmpFile = new File(this.getPersistenceHelper().getStorageDirectory(), fileName);
        fos = new FileOutputStream(tmpFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        SubscriptionPersistenceUtils.storeSubscriptionListeners((TopicList)this.topicList, (ObjectOutputStream)oos);
        Object var6_6 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (Exception ee) {
            logger.error((Object)i18n.getMessage("storeSubscriptionsErr"), (Throwable)ee);
        }
        return;
        {
            catch (Exception e) {
                tmpFile.delete();
                throw new Exception(i18n.getMessage("storeSubscriptionsErr") + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception ee) {
                logger.error((Object)i18n.getMessage("storeSubscriptionsErr"), (Throwable)ee);
            }
            throw throwable;
        }
    }

    private void loadSecurityContext(RFTRecoveryData recoveryData) throws Exception {
        String userSubject = recoveryData.getUserSubject();
        String localUserId = recoveryData.getUserName();
        this.setSecurityDescriptor(userSubject, localUserId);
        this.loadSubscribers();
    }

    public void store() {
        try {
            this.storeSubscriptions();
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("storeSubscriptionsErr"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadSubscribers() {
        FileInputStream fis;
        block9: {
            File file;
            fis = null;
            String fileName = this.getPersistenceHelper().getStorageDirectory() + SUBSCRIPTION_FILE + this.requestId + ".tmp";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading rft subscribers from : " + fileName));
            }
            if (!(file = new File(fileName)).exists()) break block9;
            fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            SubscriptionPersistenceUtils.loadSubscriptionListeners((TopicList)this.getTopicList(), (ObjectInputStream)ois);
        }
        Object var6_6 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (Exception e2) {
            logger.error((Object)i18n.getMessage("loadSubscriptionsErr" + e2.getMessage()));
        }
        return;
        {
            catch (Exception e) {
                logger.error((Object)"Error loading subscribers: ", (Throwable)e);
                Object var6_7 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (Exception e2) {
                    logger.error((Object)i18n.getMessage("loadSubscriptionsErr" + e2.getMessage()));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                logger.error((Object)i18n.getMessage("loadSubscriptionsErr" + e2.getMessage()));
            }
            throw throwable;
        }
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(((Object)((Object)this)).getClass(), ".ser");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }

    protected synchronized void processDelegatedCredential() throws Exception {
        this.processDelegatedCredential(this.requestId);
    }

    private synchronized void processDelegatedCredential(int requestId) throws Exception {
        try {
            CredentialRefreshListener listener;
            EndpointReferenceType epr = null;
            if (this.transferRequest != null) {
                epr = this.transferRequest.getTransferCredentialEndpoint();
            } else if (this.deleteRequest != null) {
                epr = this.deleteRequest.getTransferCredentialEndpoint();
            }
            if (epr == null) {
                throw new RftException(i18n.getMessage("delegationCredErr"));
            }
            this.key = ReliableFileTransferHome.getResourceKey(requestId);
            if (this.key != null) {
                listener = new CredentialRefreshListener(this.HOME_LOCATION, this.key);
                DelegationUtil.registerDelegationListener((EndpointReferenceType)epr, (DelegationListener)listener);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Registered a new listener with id:" + listener.getId()));
                }
            } else {
                throw new RftException(i18n.getMessage("delegationCredErr"));
            }
            this.dbAdapter.storeDelegationListenerId(this.requestId, listener.getId());
            this.resourceManager.setDelegationListenerId(listener.getId());
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("delegationCredErr") + e.getMessage()), (Throwable)e);
            throw new RftException(i18n.getMessage("delegationCredErr") + e.getMessage(), e);
        }
    }

    private void setSecurityDescriptor(String userSubject, String localUserId) {
        try {
            this.desc = new ResourceSecurityDescriptor();
            GridMap gridMap = new GridMap();
            gridMap.map(userSubject, localUserId);
            this.desc.setGridMap(gridMap);
        }
        catch (Exception exp) {
            throw new RuntimeException(exp.getMessage());
        }
    }

    public synchronized void initialize(Object resourceBean, QName resourceElementQName, Object key) throws ResourceException {
        super.initialize(resourceBean, resourceElementQName, key);
        logger.debug((Object)"Enter initialize()");
        this.key = (ResourceKey)key;
        SimpleResourceKey simpleResourceKey = (SimpleResourceKey)this.key;
        String value = (String)simpleResourceKey.getValue();
        this.requestId = Integer.parseInt(value);
        this.propSet = new SimpleResourcePropertySet(RFTConstants.RFT_RP_SET);
        this.topicList = new SimpleTopicList((ResourceProperties)this);
        this.totalBytesTransferredRP = new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(RFTConstants.TOTAL_BYTES_RESOURCE));
        this.totalBytesTransferred = new TotalBytesTransferredResource(0L);
        this.totalTimeTakenResourceRP = new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(RFTConstants.TOTAL_TIME_RESOURCE));
        this.totalTimeTakenType = new TotalTimeTakenResource(0L);
        this.resourceCreationTime = Calendar.getInstance();
        try {
            this.initializeOverallStatusRP();
            this.intializeRequestStatusRP();
            this.setResourceProperties();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.resourceManager = new RFTResourceManager(this.requestId, this.concurrency, this.propSet);
        logger.debug((Object)"Exit initialize()");
    }

    private void initializeOverallStatusRP() throws RftDBException {
        this.overallStatus = this.dbAdapter.getOverallStatus(this.requestId);
        this.overallStatusRP = new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(RFTConstants.OVERALL_STATUS_RESOURCE));
    }

    private void intializeRequestStatusRP() {
        this.requestStatusType = new RequestStatusType();
        this.requestStatusRP = new ResourcePropertyTopic((ResourceProperty)new SimpleResourceProperty(RFTConstants.REQUEST_STATUS_RESOURCE));
        this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Pending);
        int totalTransfers = 0;
        int activeTransfers = this.overallStatus.getTransfersActive();
        int failedTransfers = this.overallStatus.getTransfersFailed();
        int pendingTransfers = this.overallStatus.getTransfersPending();
        int finishedTransfers = this.overallStatus.getTransfersFinished();
        int restartedTransfers = this.overallStatus.getTransfersRestarted();
        totalTransfers = activeTransfers + failedTransfers + pendingTransfers + finishedTransfers + restartedTransfers;
        if (activeTransfers > 0) {
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Active);
        }
        if (failedTransfers + finishedTransfers == totalTransfers && failedTransfers != 0) {
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Failed);
        }
        if (totalTransfers == finishedTransfers) {
            this.requestStatusType.setRequestStatus(RequestStatusTypeEnumeration.Done);
        }
    }

    private void setResourceProperties() throws Exception {
        this.propSet.add(this.overallStatusRP);
        this.propSet.add(this.totalBytesTransferredRP);
        this.propSet.add(this.requestStatusRP);
        this.propSet.add(this.totalTimeTakenResourceRP);
        this.topicList.addTopic((Topic)this.overallStatusRP);
        this.topicList.addTopic((Topic)this.totalBytesTransferredRP);
        this.topicList.addTopic((Topic)this.requestStatusRP);
        this.topicList.addTopic((Topic)this.totalTimeTakenResourceRP);
        this.overallStatusRP.add((Object)this.overallStatus);
        this.totalBytesTransferredRP.add((Object)this.totalBytesTransferred);
        this.requestStatusRP.add((Object)this.requestStatusType);
        this.totalTimeTakenResourceRP.add((Object)this.totalTimeTakenType);
        ReflectionResourceProperty prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.TERMINATION_TIME, (Object)this);
        this.propSet.add((ResourceProperty)prop);
        this.topicList.addTopic((Topic)new SimpleTopic(WSRFConstants.TERMINATION_TOPIC));
        prop = new ReflectionResourceProperty((ResourcePropertyMetaData)SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this);
        this.propSet.add((ResourceProperty)prop);
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public RFTResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return this.desc;
    }

    public List getStoredResourceKeyValues() throws RftDBException {
        List activeTransfers = this.dbAdapter.getActiveRequestIds();
        return activeTransfers;
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    public Object getID() {
        return this.key;
    }

    public void setTerminationTime(Calendar time) {
        this.terminationTime = time;
        try {
            this.dbAdapter.updateRequest(this.requestId, time.getTimeInMillis());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getRequestIdFromKey() {
        SimpleResourceKey simpleResourceKey = (SimpleResourceKey)this.key;
        String value = (String)simpleResourceKey.getValue();
        return Integer.parseInt(value);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    protected Class getResourceBeanClass() {
        return class$org$globus$rft$generated$ReliableTransferProperties == null ? (class$org$globus$rft$generated$ReliableTransferProperties = ReliableFileTransferResource.class$("org.globus.rft.generated.ReliableTransferProperties")) : class$org$globus$rft$generated$ReliableTransferProperties;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void load(ResourceKey key) throws ResourceException {
        this.requestId = Integer.parseInt((String)key.getValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to reload RFT resource with id: " + this.requestId));
        }
        Boolean isStarted = null;
        try {
            isStarted = this.dbAdapter.isStarted(this.requestId);
        }
        catch (RftDBException rftdbe) {
            logger.error((Object)(i18n.getMessage("resourceLoadErr") + rftdbe.getMessage()), (Throwable)((Object)rftdbe));
            throw new ResourceException(i18n.getMessage("resourceLoadErr") + rftdbe.getMessage(), (Throwable)((Object)rftdbe));
        }
        if (isStarted == null) {
            throw new NoSuchResourceException((String)key.getValue());
        }
        this.started = isStarted;
        if (this.started) {
            try {
                RFTRecoveryData recoveryData = this.dbAdapter.getRecoveryData(this.requestId);
                InitialContext initialCtx = new InitialContext();
                this.workManager = (WorkManager)initialCtx.lookup("java:comp/env/wm/ContainerWorkManager");
                Collection activeTransferJobs = recoveryData.getRecoveredTransfers();
                this.concurrency = activeTransferJobs.size();
                this.initialize(ReliableFileTransferResource.createResourceBean(null, this.terminationTime), RFTConstants.RFT_KEY_QNAME, key);
                this.loadSecurityContext(recoveryData);
                this.resourceManager.startTransfers();
            }
            catch (Exception e) {
                logger.error((Object)(i18n.getMessage("resourceLoadErr") + e.getMessage()), (Throwable)e);
                throw new ResourceException(i18n.getMessage("resourceLoadErr") + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.initialize(ReliableFileTransferResource.createResourceBean(null, this.terminationTime), RFTConstants.RFT_KEY_QNAME, key);
            RFTRecoveryData recoveryData = this.dbAdapter.getSecurityRecoveryData(this.requestId);
            this.loadSecurityContext(recoveryData);
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing", (Throwable)e);
        }
    }

    public synchronized void setStartedTrue() {
        this.started = true;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void remove() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing the resource with id: " + this.requestId));
        }
        try {
            String fileName = SUBSCRIPTION_FILE + this.requestId + ".tmp";
            File subscriptionsFile = new File(this.getPersistenceHelper().getStorageDirectory(), fileName);
            if (subscriptionsFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"deleting subscriptions file");
                }
                subscriptionsFile.delete();
            }
            this.resourceManager.removeDelegatedCredListeners();
            this.dbAdapter.deleteAll(this.requestId);
            if (this.delete) {
                TransferWork.closeDeleteClients(this.requestId);
            } else {
                TransferWork.closeTransferClients(this.requestId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PerformanceLog RFT Resource with key: " + this.requestId + " Destroyed"));
            }
        }
        catch (Exception e) {
            logger.error((Object)(i18n.getMessage("resourceRemoveErr") + e.getMessage()), (Throwable)e);
            throw new ResourceException(i18n.getMessage("resourceRemoveErr") + e.getMessage(), (Throwable)e);
        }
        this.sendUsagePacket();
    }

    public static ReliableTransferProperties createResourceBean(Calendar initialTerminationTime, Calendar currentTime) {
        ReliableTransferProperties reliableTransferProperties = new ReliableTransferProperties();
        reliableTransferProperties.setTotalBytes(new TotalBytesTransferredResource());
        reliableTransferProperties.setTotalTime(new TotalTimeTakenResource());
        reliableTransferProperties.setOverallStatusProperty(new OverallStatus());
        reliableTransferProperties.setCurrentTime(currentTime);
        reliableTransferProperties.setTerminationTime(initialTerminationTime);
        return reliableTransferProperties;
    }

    private void sendUsagePacket() {
        try {
            RFTUsageMonitorPacket usagePacket = new RFTUsageMonitorPacket();
            if (this.delete) {
                usagePacket.setRequestType(this.delete);
            }
            usagePacket.setTotalNumberOfFiles(this.dbAdapter.getTotalNumberOfTransfers());
            usagePacket.setTotalNumberOfBytes(this.dbAdapter.getTotalNumberOfBytes());
            usagePacket.setNumberOfFiles((long)this.size);
            usagePacket.setNumberOfBytes(this.totalBytesTransferred.getTotalBytes());
            usagePacket.setResourceCreationTime(this.resourceCreationTime.getTime());
            usagePacket.setFactoryStartTime(this.getCurrentTime().getTime());
            UsageConfig usageConfig = UsageConfig.getUsageConfig();
            if (usageConfig != null) {
                List targets = usageConfig.getTargets();
                usagePacket.setHostIP(usageConfig.getContainerHost());
                if (targets != null) {
                    usagePacket.sendPacket(targets);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not send usage stat " + e.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

