/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.Cancel;
import org.globus.rft.generated.CancelResponse;
import org.globus.rft.generated.GetStatus;
import org.globus.rft.generated.GetStatusResponse;
import org.globus.rft.generated.GetStatusSet;
import org.globus.rft.generated.GetStatusSetResponse;
import org.globus.rft.generated.RFTDatabaseFaultType;
import org.globus.rft.generated.RepeatedlyStartedFaultType;
import org.globus.rft.generated.Start;
import org.globus.rft.generated.StartOutputType;
import org.globus.rft.generated.TransferStatusType;
import org.globus.transfer.reliable.service.FaultUtil;
import org.globus.transfer.reliable.service.MyPerformanceLog;
import org.globus.transfer.reliable.service.RFTConfiguration;
import org.globus.transfer.reliable.service.ReliableFileTransferResource;
import org.globus.transfer.reliable.service.TransferWork;
import org.globus.transfer.reliable.service.database.RFTDatabaseOptions;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.oasis.wsn.ResourceUnknownFaultType;

public class ReliableFileTransferImpl {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$ReliableFileTransferImpl == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferImpl = ReliableFileTransferImpl.class$("org.globus.transfer.reliable.service.ReliableFileTransferImpl")) : class$org$globus$transfer$reliable$service$ReliableFileTransferImpl).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$ReliableFileTransferImpl == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferImpl = ReliableFileTransferImpl.class$("org.globus.transfer.reliable.service.ReliableFileTransferImpl")) : class$org$globus$transfer$reliable$service$ReliableFileTransferImpl).getClassLoader());
    private ReliableFileTransferDbAdapter dbAdapter;
    private static RFTDatabaseOptions dbConfiguration;
    private static RFTConfiguration serviceConfiguration;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$ReliableFileTransferImpl;
    static /* synthetic */ Class class$org$globus$rft$generated$RepeatedlyStartedFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$RFTDatabaseFaultType;

    public ReliableFileTransferImpl() {
        block7: {
            String lookupString;
            InitialContext initialContext;
            ResourceContext ctx;
            try {
                ctx = ResourceContext.getResourceContext();
                initialContext = new InitialContext();
                lookupString = "java:comp/env//services/" + ctx.getService() + "/dbConfiguration";
                dbConfiguration = (RFTDatabaseOptions)initialContext.lookup(lookupString);
            }
            catch (Exception e) {
                logger.error((Object)(i18n.getMessage("dbConfigFileErr") + e.getMessage()), (Throwable)e);
                throw new RuntimeException(i18n.getMessage("dbConfigFileErr"), e);
            }
            try {
                ctx = ResourceContext.getResourceContext();
                initialContext = new InitialContext();
                lookupString = "java:comp/env//services/" + ctx.getService() + "/configuration";
                serviceConfiguration = (RFTConfiguration)initialContext.lookup(lookupString);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("maximum active allowed:" + serviceConfiguration.getMaxActiveAllowed()));
                }
            }
            catch (Exception e) {
                logger.error((Object)(i18n.getMessage("serviceConfigErr") + e.getMessage()), (Throwable)e);
                throw new RuntimeException(i18n.getMessage("serviceConfigErr") + e.getMessage(), e);
            }
            try {
                this.dbAdapter = ReliableFileTransferDbAdapter.setup();
            }
            catch (Exception db) {
                logger.error((Object)(i18n.getMessage("dbSetupErr") + db.getMessage()));
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)(i18n.getMessage("dbSetupErr") + db.getMessage()), (Throwable)db);
            }
        }
    }

    public StartOutputType start(Start params) throws RemoteException, RepeatedlyStartedFaultType {
        int requestId = 0;
        ReliableFileTransferResource rftResource = null;
        MyPerformanceLog perf = new MyPerformanceLog("RFT start resource (complete)");
        if (logger.isDebugEnabled()) {
            perf.start();
        }
        try {
            ResourceContext resourceContext = ResourceContext.getResourceContext();
            ResourceHome resourceHome = resourceContext.getResourceHome();
            ResourceKey resourceKey = resourceContext.getResourceKey();
            rftResource = (ReliableFileTransferResource)resourceHome.find(resourceKey);
            requestId = Integer.parseInt((String)resourceKey.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PerformanceLog Enter start() " + requestId));
            }
            if (requestId == 0 || rftResource == null) {
                throw new ResourceUnknownFaultType();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start called for : " + requestId));
            }
            if (rftResource.isStarted()) {
                throw (RepeatedlyStartedFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RepeatedlyStartedFaultType == null ? (class$org$globus$rft$generated$RepeatedlyStartedFaultType = ReliableFileTransferImpl.class$("org.globus.rft.generated.RepeatedlyStartedFaultType")) : class$org$globus$rft$generated$RepeatedlyStartedFaultType, requestId, i18n.getMessage("startRepeatedlyCalledErr"), null);
            }
            rftResource.setStartedTrue();
            this.dbAdapter.updateStarted(requestId, true);
            rftResource.getResourceManager().startTransfers();
            StartOutputType res = new StartOutputType();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PerformanceLog Exit start() for " + requestId));
            }
            if (logger.isDebugEnabled()) {
                perf.stop();
            }
            return res;
        }
        catch (Exception e) {
            if (e instanceof RepeatedlyStartedFaultType) {
                logger.info((Object)i18n.getMessage("startRepeatedlyCalledErr"));
                throw (RepeatedlyStartedFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RepeatedlyStartedFaultType == null ? (class$org$globus$rft$generated$RepeatedlyStartedFaultType = ReliableFileTransferImpl.class$("org.globus.rft.generated.RepeatedlyStartedFaultType")) : class$org$globus$rft$generated$RepeatedlyStartedFaultType, requestId, i18n.getMessage("startRepeatedlyCalledErr"), null);
            }
            logger.error((Object)i18n.getMessage("startErr"), (Throwable)e);
            throw new RemoteException(i18n.getMessage("startErr"), e);
        }
    }

    public GetStatusResponse getStatus(GetStatus params) throws RemoteException, ResourceUnknownFaultType, RFTDatabaseFaultType {
        String sourceUrl = params.getSourceUrl();
        TransferStatusType statusType = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finding status of " + sourceUrl));
        }
        int requestId = -1;
        try {
            requestId = this.getRequestId();
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("getStatusErr"), e);
        }
        if (requestId == -1) {
            logger.error((Object)i18n.getMessage("resourceNotFoundErr"));
            throw new ResourceUnknownFaultType();
        }
        try {
            statusType = this.dbAdapter.getStatus(requestId, sourceUrl);
        }
        catch (RftDBException e) {
            throw (RFTDatabaseFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTDatabaseFaultType == null ? (class$org$globus$rft$generated$RFTDatabaseFaultType = ReliableFileTransferImpl.class$("org.globus.rft.generated.RFTDatabaseFaultType")) : class$org$globus$rft$generated$RFTDatabaseFaultType, requestId, i18n.getMessage("dbRetrieveErr"), (Exception)((Object)e));
        }
        if (statusType == null) {
            throw new RemoteException(i18n.getMessage("getStatusErr"));
        }
        return new GetStatusResponse(statusType);
    }

    public GetStatusSetResponse getStatusSet(GetStatusSet params) throws RemoteException, ResourceUnknownFaultType, RFTDatabaseFaultType {
        GetStatusSetResponse response = null;
        TransferStatusType[] statusSet = null;
        Vector statusSetVector = null;
        int requestId = -1;
        int initial = params.getFrom();
        int offset = params.getOffset();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("GetStatus of " + offset + " transfers starting from " + initial));
        }
        try {
            requestId = this.getRequestId();
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("getStatusSetErr"), e);
        }
        if (requestId == -1) {
            logger.error((Object)i18n.getMessage("resourceNotFoundErr"));
            throw new ResourceUnknownFaultType();
        }
        try {
            statusSetVector = this.dbAdapter.getStatusSet(requestId, initial, offset);
            int statusSetSize = statusSetVector.size();
            if (statusSetSize > 0) {
                statusSet = new TransferStatusType[statusSetSize];
                for (int i = 0; i < statusSetSize; ++i) {
                    statusSet[i] = (TransferStatusType)statusSetVector.elementAt(i);
                }
                response = new GetStatusSetResponse();
                response.setTransferStatusSet(statusSet);
            } else {
                logger.error((Object)i18n.getMessage("getStatusSetErr"));
            }
        }
        catch (RftDBException e) {
            throw (RFTDatabaseFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTDatabaseFaultType == null ? (class$org$globus$rft$generated$RFTDatabaseFaultType = ReliableFileTransferImpl.class$("org.globus.rft.generated.RFTDatabaseFaultType")) : class$org$globus$rft$generated$RFTDatabaseFaultType, requestId, i18n.getMessage("dbRetrieveErr"), (Exception)((Object)e));
        }
        if (statusSet == null) {
            throw new RemoteException(i18n.getMessage("getStatusSetErr"));
        }
        return response;
    }

    public CancelResponse cancel(Cancel params) throws RemoteException, ResourceUnknownFaultType, RFTDatabaseFaultType {
        CancelResponse response = null;
        int fromId = -1;
        int toId = -1;
        int requestId = -1;
        int transferId = -1;
        fromId = params.getFromId();
        toId = params.getToId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoked cancel for transfer from " + fromId + " to " + toId));
        }
        try {
            requestId = this.getRequestId();
            if (requestId == -1) {
                throw new ResourceUnknownFaultType();
            }
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("unableToCancelErr"), e);
        }
        try {
            transferId = this.dbAdapter.getFirstTransferId(requestId);
            if (fromId != -1 && toId != -1) {
                fromId = transferId + fromId - 1;
                toId = transferId + toId - 1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cancelling from:" + fromId + " to " + toId));
            }
            TransferWork.stopActiveTransfers(requestId, fromId, toId);
            this.dbAdapter.updateToCancelled(requestId, fromId, toId);
        }
        catch (RftDBException e) {
            logger.error((Object)i18n.getMessage("dbRetrieveErr"), (Throwable)((Object)e));
            throw (RFTDatabaseFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTDatabaseFaultType == null ? (class$org$globus$rft$generated$RFTDatabaseFaultType = ReliableFileTransferImpl.class$("org.globus.rft.generated.RFTDatabaseFaultType")) : class$org$globus$rft$generated$RFTDatabaseFaultType, requestId, i18n.getMessage("dbRetrieveErr"), (Exception)((Object)e));
        }
        response = new CancelResponse();
        return response;
    }

    private int getRequestId() throws Exception {
        int requestId = -1;
        ResourceContext resourceContext = ResourceContext.getResourceContext();
        ResourceKey resourceKey = resourceContext.getResourceKey();
        requestId = Integer.parseInt((String)resourceKey.getValue());
        return requestId;
    }

    public static RFTDatabaseOptions getDatabaseConfiguration() {
        return dbConfiguration;
    }

    public static RFTConfiguration getRFTConfiguration() {
        return serviceConfiguration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

