/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.BaseRequestType;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.transfer.reliable.service.ReliableFileTransferResource;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;

public class ReliableFileTransferHome
extends ResourceHomeImpl {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$ReliableFileTransferHome == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferHome = ReliableFileTransferHome.class$("org.globus.transfer.reliable.service.ReliableFileTransferHome")) : class$org$globus$transfer$reliable$service$ReliableFileTransferHome).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$ReliableFileTransferHome == null ? (class$org$globus$transfer$reliable$service$ReliableFileTransferHome = ReliableFileTransferHome.class$("org.globus.transfer.reliable.service.ReliableFileTransferHome")) : class$org$globus$transfer$reliable$service$ReliableFileTransferHome).getClassLoader());
    ReliableFileTransferDbAdapter dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$ReliableFileTransferHome;

    public synchronized void initialize() {
        block9: {
            try {
                super.initialize();
                this.keyTypeName = RFTConstants.RFT_KEY_QNAME;
                List resourceKeyValueList = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Loading the RFT home's list of resource keys");
                }
                if ((resourceKeyValueList = new ReliableFileTransferResource().getStoredResourceKeyValues()) != null) {
                    Iterator it = resourceKeyValueList.iterator();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Number of RFT resources to be recovered:" + resourceKeyValueList.size()));
                    }
                    while (it.hasNext()) {
                        Integer keyValue = (Integer)it.next();
                        if (keyValue != null) {
                            ReliableFileTransferResource res = new ReliableFileTransferResource();
                            res.load((ResourceKey)ReliableFileTransferHome.getResourceKey(keyValue));
                            this.add((ResourceKey)ReliableFileTransferHome.getResourceKey(keyValue), res);
                            this.dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
                            res.setTerminationTime(this.dbAdapter.getTerminationTime(keyValue));
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"no RFT Resources to recover");
                    }
                }
            }
            catch (RftDBException ex) {
                logger.warn((Object)(i18n.getMessage("termErrorString") + ex.getMessage()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(i18n.getMessage("termErrorString") + ex.getMessage()), (Throwable)((Object)ex));
                }
            }
            catch (Exception re) {
                logger.warn((Object)(i18n.getMessage("termErrorString") + re.getMessage()));
                if (!logger.isDebugEnabled()) break block9;
                logger.debug((Object)(i18n.getMessage("termErrorString") + re.getMessage()), (Throwable)re);
            }
        }
    }

    public SimpleResourceKey create(Calendar initialTerminationTime, Calendar currentTime, BaseRequestType transferRequest, String userSubject, String localUserId) throws Exception {
        ReliableFileTransferResource res = new ReliableFileTransferResource(transferRequest, userSubject, localUserId, initialTerminationTime);
        SimpleResourceKey key = ReliableFileTransferHome.getResourceKey(res.getRequestId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created a ReliableTransferResource with key " + key.getValue()));
        }
        res.initialize(ReliableFileTransferResource.createResourceBean(initialTerminationTime, currentTime), RFTConstants.RFT_RP_SET, key);
        res.store();
        this.add((ResourceKey)key, res);
        res.processDelegatedCredential();
        return key;
    }

    public static SimpleResourceKey getResourceKey(int requestId) {
        return new SimpleResourceKey(RFTConstants.RFT_KEY_QNAME, (Object)Integer.toString(requestId));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

