/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import commonj.work.Work;
import commonj.work.WorkManager;
import java.io.StringReader;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.service.DelegationResource;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.SimplePrincipal;
import org.globus.rft.generated.OverallStatus;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.rft.generated.TransferStatusTypeEnumeration;
import org.globus.rft.generated.TransferType;
import org.globus.transfer.reliable.service.TransferWork;
import org.globus.transfer.reliable.service.database.RFTDatabaseSetup;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.xml.sax.InputSource;

public class RFTResourceManager {
    private int requestId = 0;
    Vector transferSet;
    private int cacheSize = 0;
    private OverallStatus overallStatus = null;
    int concurrency = 0;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$RFTResourceManager == null ? (class$org$globus$transfer$reliable$service$RFTResourceManager = RFTResourceManager.class$("org.globus.transfer.reliable.service.RFTResourceManager")) : class$org$globus$transfer$reliable$service$RFTResourceManager).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$RFTResourceManager == null ? (class$org$globus$transfer$reliable$service$RFTResourceManager = RFTResourceManager.class$("org.globus.transfer.reliable.service.RFTResourceManager")) : class$org$globus$transfer$reliable$service$RFTResourceManager).getClassLoader());
    private ReliableFileTransferDbAdapter dbAdapter;
    private int maxAttempts = 0;
    private GSSCredential credential = null;
    private EndpointReferenceType delegationEPR = null;
    private Subject userSubject;
    private String delegationListenerId = null;
    private String userName = null;
    private int pending = 0;
    private static final String getNextQuery = "SELECT * FROM transfer WHERE request_id= ?  AND (status=4 or status=1 or status=8) AND retry_time < ? order by id ";
    private static final String updateTransferQuery = "UPDATE transfer set status=?, attempts=? where id=?";
    private static final String updateTransferQuery1 = "UPDATE transfer set status=? where id=?";
    private int activeTransfers = 0;
    private ResourcePropertySet propSet = null;
    private static final String getOverallStatusQuery = "SELECT status from transfer where request_id=? ";
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$RFTResourceManager;
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;

    public RFTResourceManager(int requestId, int concurrency, ResourcePropertySet propSet) {
        this.requestId = requestId;
        this.concurrency = concurrency;
        this.cacheSize = 2 * concurrency;
        this.transferSet = new Vector();
        this.dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
        this.overallStatus = new OverallStatus();
        this.propSet = propSet;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setNumberOfTransfers(int numberOfTransfers) {
        if (numberOfTransfers > 0) {
            this.pending += numberOfTransfers;
        }
    }

    public int getMaxAttempts() throws RftDBException {
        if (this.maxAttempts == 0) {
            this.maxAttempts = this.dbAdapter.getMaxAttempts(this.requestId);
        }
        return this.maxAttempts;
    }

    public void setDelegationListenerId(String delegationListenerId) {
        this.delegationListenerId = delegationListenerId;
    }

    private EndpointReferenceType getDelegationEPR() throws Exception {
        StringReader delegationEPRStringReader = new StringReader(this.dbAdapter.getDelegationEPR(this.requestId));
        String userDN = this.dbAdapter.getSubject(this.requestId);
        this.userSubject = new Subject();
        SimplePrincipal principal = new SimplePrincipal(userDN);
        this.userSubject.getPrincipals().add((Principal)principal);
        InputSource in = new InputSource(delegationEPRStringReader);
        this.delegationEPR = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)in, (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = RFTResourceManager.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType));
        return this.delegationEPR;
    }

    public synchronized void incrementActive() {
        ++this.activeTransfers;
    }

    public synchronized void decrementActive() {
        --this.activeTransfers;
    }

    public synchronized boolean checkForConcurrency() {
        return this.activeTransfers < this.concurrency;
    }

    public int getActive() {
        return this.activeTransfers;
    }

    public GSSCredential getCredential() throws RftException {
        if (this.credential != null) {
            return this.credential;
        }
        try {
            this.delegationEPR = this.getDelegationEPR();
            DelegationResource resource = DelegationUtil.getDelegationResource((EndpointReferenceType)this.delegationEPR);
            this.setCredential(resource.getCredential(this.userSubject));
        }
        catch (Exception e) {
            throw new RftException(i18n.getMessage("delegationCredErr"), e);
        }
        return this.credential;
    }

    public void removeDelegatedCredListeners() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing delegation listeners for id: " + this.requestId));
            }
            if (this.delegationListenerId == null) {
                this.delegationListenerId = this.dbAdapter.getDelegationListenerId(this.requestId);
            }
            if (this.delegationEPR == null) {
                this.delegationEPR = this.getDelegationEPR();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delegation listener to be destroyed:" + this.delegationListenerId));
            }
            DelegationUtil.removeDelegationListener((EndpointReferenceType)this.delegationEPR, (String)this.delegationListenerId);
        }
        catch (NoSuchResourceException nsre) {
            logger.error((Object)"Delegation resource already destroyed");
        }
        catch (Exception e) {
            logger.error((Object)"error deleting a deleg resource", (Throwable)e);
        }
    }

    public void setCredential(GlobusCredential credential) throws GSSException {
        this.credential = new GlobusGSSCredentialImpl(credential, 0);
    }

    public String getUserName() throws RftDBException {
        if (this.userName != null) {
            return this.userName;
        }
        return this.dbAdapter.getUserName(this.requestId);
    }

    public synchronized TransferType getNext() throws RftDBException {
        if (!this.checkForConcurrency()) {
            logger.debug((Object)"reached concurrency.no more transfers");
            return null;
        }
        if (this.transferSet.size() > 0) {
            this.incrementActive();
            return (TransferType)this.transferSet.remove(0);
        }
        this.getNextSet();
        if (this.transferSet.size() > 0) {
            this.incrementActive();
            return (TransferType)this.transferSet.remove(0);
        }
        return null;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    /*
     * Loose catch block
     */
    public OverallStatus getOverallStatus() throws RftDBException {
        OverallStatus overallStatus;
        block22: {
            ResultSet rs;
            PreparedStatement preparedStatement;
            Connection c;
            block21: {
                c = null;
                preparedStatement = null;
                rs = null;
                int status = -1;
                overallStatus = null;
                int finished = 0;
                int active = 0;
                int pending = 0;
                int retrying = 0;
                int cancelled = 0;
                int failed = 0;
                c = RFTDatabaseSetup.getDBConnection();
                preparedStatement = c.prepareStatement(getOverallStatusQuery);
                preparedStatement.setObject(1, new Integer(this.requestId));
                rs = preparedStatement.executeQuery();
                while (rs != null && rs.next()) {
                    status = rs.getInt(1);
                    if (status == 0) {
                        ++finished;
                        continue;
                    }
                    if (status == 1) {
                        ++retrying;
                        continue;
                    }
                    if (status == 2) {
                        ++failed;
                        continue;
                    }
                    if (status == 3) {
                        ++active;
                        continue;
                    }
                    if (status == 4 || status == 10 || status == 8) {
                        ++pending;
                        continue;
                    }
                    if (status == 5) {
                        ++cancelled;
                        continue;
                    }
                    if (status == 6) {
                        ++active;
                        continue;
                    }
                    if (status != 7) continue;
                    ++finished;
                }
                overallStatus = new OverallStatus();
                overallStatus.setTransfersFinished(finished);
                overallStatus.setTransfersRestarted(retrying);
                overallStatus.setTransfersFailed(failed);
                overallStatus.setTransfersActive(active);
                overallStatus.setTransfersPending(pending);
                overallStatus.setTransfersCancelled(cancelled);
                if (!logger.isDebugEnabled()) break block21;
                logger.debug((Object)("OverallStatus for requestId: " + this.requestId + " Finished:" + finished + " Retrying:" + retrying + " Failed:" + failed + " Active:" + active + " Pending:" + pending + " Cancelled:" + cancelled));
            }
            Object var14_12 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block22;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block22;
            {
                catch (SQLException e) {
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr") + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
        return overallStatus;
    }

    /*
     * Loose catch block
     */
    public void updateTransferJob(int transferId, int status, int attempts) throws RftDBException {
        block13: {
            PreparedStatement preparedStatement = null;
            Connection c = null;
            c = RFTDatabaseSetup.getDBConnection();
            if (attempts != -1) {
                preparedStatement = c.prepareStatement(updateTransferQuery);
                preparedStatement.setObject(1, new Integer(status));
                preparedStatement.setObject(2, new Integer(attempts));
                preparedStatement.setObject(3, new Integer(transferId));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating transfer : " + transferId + " with status: " + status + " and attempts:" + attempts));
                }
            } else {
                preparedStatement = c.prepareStatement(updateTransferQuery1);
                preparedStatement.setObject(1, new Integer(status));
                preparedStatement.setObject(2, new Integer(transferId));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating transfer : " + transferId + " with status: " + status));
                }
            }
            preparedStatement.executeUpdate();
            Object var8_6 = null;
            try {
                RFTDatabaseSetup.returnDBConnection(c);
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block13;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block13;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbUpdateErr", (Object)("" + this.requestId)), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbUpdateErr", (Object)("" + this.requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    RFTDatabaseSetup.returnDBConnection(c);
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void getNextSet() throws RftDBException {
        block17: {
            this.transferSet = new Vector();
            Connection c = null;
            PreparedStatement statement = null;
            ResultSet rs = null;
            TransferType transfer = null;
            c = RFTDatabaseSetup.getDBConnection();
            statement = c.prepareStatement(getNextQuery, 1004, 1008);
            statement.setObject(1, new Integer(this.requestId));
            statement.setObject(2, new Long(Calendar.getInstance().getTimeInMillis()));
            statement.setMaxRows(this.cacheSize);
            rs = statement.executeQuery();
            for (int i = 0; i < this.cacheSize; ++i) {
                while (rs != null && rs.next()) {
                    transfer = new TransferType();
                    int tempTransferId = rs.getInt(1);
                    transfer.setTransferId(new Integer(tempTransferId));
                    transfer.setSourceUrl(rs.getString(3));
                    transfer.setDestinationUrl(rs.getString(4));
                    int status = rs.getInt(5);
                    transfer.setAttempts(new Integer(rs.getInt(6)));
                    RFTOptionsType rftOptions = new RFTOptionsType();
                    rftOptions.setUserName(rs.getString(7));
                    rftOptions.setDcau(new Boolean(rs.getBoolean(8)));
                    rftOptions.setParallelStreams(new Integer(rs.getInt(9)));
                    rftOptions.setTcpBufferSize(new Integer(rs.getInt(10)));
                    rftOptions.setBlockSize(new Integer(rs.getInt(11)));
                    rftOptions.setNotpt(new Boolean(rs.getBoolean(12)));
                    boolean binary = rs.getBoolean(13);
                    if (rs.wasNull()) {
                        binary = true;
                    }
                    rftOptions.setBinary(new Boolean(binary));
                    rftOptions.setSourceSubjectName(rs.getString(14));
                    rftOptions.setDestinationSubjectName(rs.getString(15));
                    rftOptions.setIgnoreFilePermErr(new Boolean(rs.getBoolean(20)));
                    transfer.setRftOptions(rftOptions);
                    transfer.setStatus(TransferStatusTypeEnumeration.Pending);
                    if (status == 8) {
                        transfer.setStatus(TransferStatusTypeEnumeration.Dirty);
                    }
                    this.transferSet.add(transfer);
                }
            }
            Object var11_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (c != null) {
                    RFTDatabaseSetup.returnDBConnection(c);
                }
                break block17;
            }
            catch (SQLException sql) {
                logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
            }
            break block17;
            {
                catch (SQLException e) {
                    logger.error((Object)i18n.getMessage("dbRetrieveErr", (Object)("" + this.requestId)), (Throwable)e);
                    throw new RftDBException(i18n.getMessage("dbRetrieveErr", (Object)("" + this.requestId)), e);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (c != null) {
                        RFTDatabaseSetup.returnDBConnection(c);
                    }
                }
                catch (SQLException sql) {
                    logger.warn((Object)i18n.getMessage("dbStatementErr"), (Throwable)sql);
                }
                throw throwable;
            }
        }
    }

    public void startTransfers() throws Exception {
        InitialContext initialCtx = new InitialContext();
        WorkManager workManager = (WorkManager)initialCtx.lookup("java:comp/env/wm/ContainerWorkManager");
        for (int tempCount = 0; tempCount <= this.concurrency; ++tempCount) {
            TransferType transferType = this.getNext();
            if (transferType == null) continue;
            TransferWork transferWork = new TransferWork(this.requestId, this.propSet, transferType);
            transferWork.setWorkManager(workManager);
            transferWork.setResourceManager(this);
            workManager.schedule((Work)transferWork);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

