/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import org.apache.log4j.Logger;
import org.globus.ftp.ByteRangeList;
import org.globus.ftp.GridFTPRestartMarker;
import org.globus.ftp.Marker;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.PerfMarker;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;

public class MyMarkerListener
implements MarkerListener {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$transfer$reliable$service$MyMarkerListener == null ? (class$org$globus$transfer$reliable$service$MyMarkerListener = MyMarkerListener.class$("org.globus.transfer.reliable.service.MyMarkerListener")) : class$org$globus$transfer$reliable$service$MyMarkerListener).getName());
    private ReliableFileTransferDbAdapter dbAdapter;
    private ByteRangeList list;
    private long size;
    private int transferid;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$MyMarkerListener;

    public MyMarkerListener() {
        this.list = new ByteRangeList();
    }

    public MyMarkerListener(int transferId, long size) {
        try {
            this.dbAdapter = ReliableFileTransferDbAdapter.getDbAdapter();
            this.list = new ByteRangeList();
            this.size = size;
            this.transferid = transferId;
        }
        catch (Exception re) {
            logger.error((Object)("Error creating marker listener" + re.getMessage()));
        }
    }

    public ByteRangeList getByteRangeList() {
        return this.list;
    }

    public void markerArrived(Marker m) {
        if (m instanceof GridFTPRestartMarker) {
            this.restartMarkerArrived((GridFTPRestartMarker)m);
        } else if (m instanceof PerfMarker) {
            this.perfMarkerArrived((PerfMarker)m);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unknown format of restart marker");
        }
    }

    private void perfMarkerArrived(PerfMarker perfMarker) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--> perf marker arrived " + perfMarker.getTimeStamp()));
        }
    }

    private void restartMarkerArrived(GridFTPRestartMarker marker) {
        try {
            this.list.merge(marker.toVector());
            String temp = this.list.toFtpCmdArgument();
            temp = temp.substring(temp.lastIndexOf("-") + 1);
            temp = "0-" + temp;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Current transfer state: " + temp + " for transferId: " + this.transferid));
            }
            this.dbAdapter.setRestartMarker(this.transferid, temp);
        }
        catch (Exception e) {
            logger.error((Object)("Exception in MarkerListener" + e.getMessage()), (Throwable)e);
        }
    }

    public void setSize(long size) {
        this.size = size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

