/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.util.Calendar;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rft.generated.RFTAuthenticationFaultType;
import org.globus.rft.generated.RFTAuthorizationFaultType;
import org.globus.rft.generated.RFTDatabaseFaultType;
import org.globus.rft.generated.RFTFaultResourcePropertyType;
import org.globus.rft.generated.RepeatedlyStartedFaultType;
import org.globus.rft.generated.TransferFaultType;
import org.globus.rft.generated.TransferTransientFaultType;
import org.globus.transfer.reliable.service.RFTConstants;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.faults.BaseFaultTypeDescription;
import org.oasis.wsrf.faults.BaseFaultTypeErrorCode;
import org.w3c.dom.CharacterData;

public class FaultUtil {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$FaultUtil == null ? (class$org$globus$transfer$reliable$service$FaultUtil = FaultUtil.class$("org.globus.transfer.reliable.service.FaultUtil")) : class$org$globus$transfer$reliable$service$FaultUtil).getName());
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$FaultUtil;
    static /* synthetic */ Class class$org$globus$rft$generated$RepeatedlyStartedFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$RFTDatabaseFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$TransferTransientFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$TransferFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$RFTAuthenticationFaultType;
    static /* synthetic */ Class class$org$globus$rft$generated$RFTAuthorizationFaultType;

    public static RFTFaultResourcePropertyType createRepeatedlyStartedFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        String description = "Repeatedly Started fault";
        RepeatedlyStartedFaultType fault = (RepeatedlyStartedFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RepeatedlyStartedFaultType == null ? (class$org$globus$rft$generated$RepeatedlyStartedFaultType = FaultUtil.class$("org.globus.rft.generated.RepeatedlyStartedFaultType")) : class$org$globus$rft$generated$RepeatedlyStartedFaultType, resourceKey, description, cause);
        faultRP.setRftRepeatedlyStartedFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createRFTDatabaseFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        String description = "RFT Database Fault";
        RFTDatabaseFaultType fault = (RFTDatabaseFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTDatabaseFaultType == null ? (class$org$globus$rft$generated$RFTDatabaseFaultType = FaultUtil.class$("org.globus.rft.generated.RFTDatabaseFaultType")) : class$org$globus$rft$generated$RFTDatabaseFaultType, resourceKey, description, cause);
        faultRP.setRftDatabaseFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createTransferTransientFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        String description = "RFT Transient Fault";
        TransferTransientFaultType fault = (TransferTransientFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$TransferTransientFaultType == null ? (class$org$globus$rft$generated$TransferTransientFaultType = FaultUtil.class$("org.globus.rft.generated.TransferTransientFaultType")) : class$org$globus$rft$generated$TransferTransientFaultType, resourceKey, description, cause);
        faultRP.setTransferTransientFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createTransferTransientFault(int resourceKey, String description, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        TransferTransientFaultType fault = (TransferTransientFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$TransferTransientFaultType == null ? (class$org$globus$rft$generated$TransferTransientFaultType = FaultUtil.class$("org.globus.rft.generated.TransferTransientFaultType")) : class$org$globus$rft$generated$TransferTransientFaultType, resourceKey, description, cause);
        faultRP.setTransferTransientFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createTransferFault(int resourceKey, String description, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        TransferFaultType fault = (TransferFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$TransferFaultType == null ? (class$org$globus$rft$generated$TransferFaultType = FaultUtil.class$("org.globus.rft.generated.TransferFaultType")) : class$org$globus$rft$generated$TransferFaultType, resourceKey, description, cause);
        faultRP.setRftTransferFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createTransferFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        String description = "RFT Transfer Fault";
        TransferFaultType fault = (TransferFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$TransferFaultType == null ? (class$org$globus$rft$generated$TransferFaultType = FaultUtil.class$("org.globus.rft.generated.TransferFaultType")) : class$org$globus$rft$generated$TransferFaultType, resourceKey, description, cause);
        faultRP.setRftTransferFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createAuthenticationFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        RFTAuthenticationFaultType fault = (RFTAuthenticationFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTAuthenticationFaultType == null ? (class$org$globus$rft$generated$RFTAuthenticationFaultType = FaultUtil.class$("org.globus.rft.generated.RFTAuthenticationFaultType")) : class$org$globus$rft$generated$RFTAuthenticationFaultType, resourceKey, null, cause);
        faultRP.setRftAuthenticationFaultType(fault);
        return faultRP;
    }

    public static RFTFaultResourcePropertyType createAuthorizationFault(int resourceKey, Exception cause) {
        RFTFaultResourcePropertyType faultRP = new RFTFaultResourcePropertyType();
        RFTAuthorizationFaultType fault = (RFTAuthorizationFaultType)FaultUtil.makeFault(class$org$globus$rft$generated$RFTAuthorizationFaultType == null ? (class$org$globus$rft$generated$RFTAuthorizationFaultType = FaultUtil.class$("org.globus.rft.generated.RFTAuthorizationFaultType")) : class$org$globus$rft$generated$RFTAuthorizationFaultType, resourceKey, null, cause);
        faultRP.setRftAuthorizationFaultType(fault);
        return faultRP;
    }

    public static BaseFaultType makeFault(Class faultClass, int requestId, String description, Exception cause) {
        Calendar timestamp = Calendar.getInstance();
        SimpleResourceKey resourceKey = new SimpleResourceKey(RFTConstants.RFT_KEY_QNAME, (Object)Integer.toString(requestId));
        EndpointReferenceType originator = FaultUtil.getEndpointReference((ResourceKey)resourceKey);
        BaseFaultTypeErrorCode errorCode = new BaseFaultTypeErrorCode();
        if (cause != null) {
            MessageElement[] any = new MessageElement[]{new MessageElement((CharacterData)new Text(JavaUtils.stackToString((Throwable)cause)))};
            errorCode.set_any(any);
        }
        errorCode.setDialect(FaultHelper.STACK_TRACE);
        BaseFaultTypeDescription[] faultDescription = new BaseFaultTypeDescription[]{new BaseFaultTypeDescription(description)};
        BaseFaultType[] faultCause = cause != null ? new BaseFaultType[]{FaultHelper.toBaseFault((Throwable)cause)} : new BaseFaultType[]{};
        BaseFaultType f = null;
        try {
            f = (BaseFaultType)faultClass.newInstance();
            f.setTimestamp(timestamp);
            f.setOriginator(originator);
            f.setErrorCode(errorCode);
            f.setDescription(faultDescription);
            f.setFaultCause(faultCause);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return f;
    }

    private static EndpointReferenceType getEndpointReference(ResourceKey resourceKey) {
        try {
            EndpointReferenceType epr = AddressingUtils.createEndpointReference((String)(ServiceHost.getBaseURL() + "ReliableFileTransferFactoryService"), (ResourceKey)resourceKey);
            return epr;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

