/*
 * Decompiled with CFR 0.152.
 */
package org.globus.transfer.reliable.service;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.rft.generated.RFTOptionsType;
import org.globus.transfer.reliable.service.URLExpander;
import org.globus.transfer.reliable.service.database.ReliableFileTransferDbAdapter;
import org.globus.transfer.reliable.service.database.RftDBException;
import org.globus.transfer.reliable.service.exception.RftException;
import org.globus.transfer.reliable.service.exception.RftTransientException;
import org.globus.util.GlobusURL;
import org.globus.util.I18n;
import org.ietf.jgss.GSSCredential;

public class DeleteClient {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$transfer$reliable$service$DeleteClient == null ? (class$org$globus$transfer$reliable$service$DeleteClient = DeleteClient.class$("org.globus.transfer.reliable.service.DeleteClient")) : class$org$globus$transfer$reliable$service$DeleteClient).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.transfer.reliable.errors", (ClassLoader)(class$org$globus$transfer$reliable$service$DeleteClient == null ? (class$org$globus$transfer$reliable$service$DeleteClient = DeleteClient.class$("org.globus.transfer.reliable.service.DeleteClient")) : class$org$globus$transfer$reliable$service$DeleteClient).getClassLoader());
    private String filePath = null;
    private GlobusURL fileURL;
    private GridFTPClient gridFtpHost = null;
    private String host = null;
    private int port = 0;
    private int status = -1;
    private GSSCredential credential = null;
    private String subjectName = null;
    private URLExpander expander = null;
    private int requestId = 0;
    static /* synthetic */ Class class$org$globus$transfer$reliable$service$DeleteClient;

    public DeleteClient(String url, String subjectName, GSSCredential credential, String userName) throws RftException, RftTransientException, RftDBException {
        try {
            this.fileURL = new GlobusURL(url);
            if (!this.fileURL.getProtocol().equalsIgnoreCase("gsiftp")) {
                throw new RftException(i18n.getMessage("thirdPartyOnlyErr", (Object[])new String[]{this.fileURL.getURL()}));
            }
            this.host = this.fileURL.getHost();
            this.port = this.fileURL.getPort();
            this.filePath = "/" + this.fileURL.getPath();
            this.gridFtpHost = new GridFTPClient(this.host, this.port);
            if (subjectName != null && !subjectName.equalsIgnoreCase("null")) {
                this.subjectName = subjectName;
                this.gridFtpHost.setAuthorization((Authorization)new IdentityAuthorization(this.subjectName));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Subject name is null in DeleteClient");
            }
            this.setCredential(credential);
            if (userName != null && !userName.equalsIgnoreCase("null")) {
                this.gridFtpHost.authenticate(this.credential, userName);
            } else {
                this.gridFtpHost.authenticate(this.credential);
            }
        }
        catch (MalformedURLException mue) {
            this.status = 2;
            throw new RftException(mue);
        }
        catch (ConnectException ce) {
            this.status = 1;
            ReliableFileTransferDbAdapter.getDbAdapter().backOff(this.host + ":" + this.port);
            throw new RftTransientException(i18n.getMessage("unableToConnectErr", new Object[]{this.host, String.valueOf(this.port)}));
        }
        catch (ServerException se) {
            this.status = 2;
            throw new RftException(se);
        }
        catch (IOException ie) {
            this.status = 2;
            throw new RftException(ie);
        }
    }

    public void setFileURL(String filePath) {
        this.filePath = "/" + filePath;
    }

    public URLExpander getUrlExpander() {
        return this.expander;
    }

    public synchronized void delete() throws RftException {
        block11: {
            try {
                if (this.filePath.endsWith("/")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting a directory " + this.filePath));
                    }
                    this.status = 6;
                    RFTOptionsType rftOptions = new RFTOptionsType();
                    rftOptions.setSourceSubjectName(this.subjectName);
                    String recursiveDeleteArgs = "rdel " + this.filePath;
                    try {
                        if (this.gridFtpHost.exists(this.filePath)) {
                            Reply reply = this.gridFtpHost.site(recursiveDeleteArgs);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Recursive dir delete complete " + this.filePath));
                            }
                            this.status = 0;
                        } else {
                            logger.debug((Object)("This dir: " + this.filePath + " is deleted"));
                            this.status = 0;
                        }
                        break block11;
                    }
                    catch (Exception urce) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("site rdel is not supported" + urce.getMessage()));
                        }
                        this.expander = new URLExpander(this.gridFtpHost, this.fileURL, rftOptions);
                        this.expander.setRequestId(this.requestId);
                        this.expander.start();
                        return;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting " + this.filePath));
                }
                this.gridFtpHost.deleteFile(this.filePath);
                this.status = 0;
            }
            catch (Exception e) {
                this.status = 1;
                throw new RftException(i18n.getMessage("deleteFileErr", (Object)this.filePath), e);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setCredential(GSSCredential credential) {
        this.credential = credential;
    }

    public boolean checkForReuse(String url, int requestId) throws RftException {
        GlobusURL newUrl = null;
        try {
            newUrl = new GlobusURL(url);
        }
        catch (MalformedURLException mue) {
            throw new RftException(mue);
        }
        String newHost = newUrl.getHost();
        int newPort = newUrl.getPort();
        return newHost.equals(this.host) && newPort == this.port && this.requestId == requestId;
    }

    public void close() {
        try {
            this.gridFtpHost.close();
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("closeClientErr"), (Throwable)e);
        }
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

