/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rendezvous.service.test;

import java.io.PrintStream;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.rendezvous.client.CompletionNotifyCallbackImpl;
import org.globus.rendezvous.client.RendezvousConstants;
import org.globus.rendezvous.client.RendezvousHelper;
import org.globus.rendezvous.generated.CapacityReachedFaultType;
import org.globus.rendezvous.generated.CreateSync;
import org.globus.rendezvous.generated.CreateSyncResponse;
import org.globus.rendezvous.generated.RankTakenFaultType;
import org.globus.rendezvous.generated.RendezvousFactoryPortType;
import org.globus.rendezvous.generated.service.RendezvousFactoryServiceAddressingLocator;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class TestClient {
    private RendezvousFactoryServiceAddressingLocator locator = new RendezvousFactoryServiceAddressingLocator();
    private String hostName = "localhost";
    private byte[] applicationData;
    private byte[] inputData;
    private EndpointReferenceType eprTop;
    private byte[] wholeData;
    private EndpointReferenceType eprSub1;
    private EndpointReferenceType eprSub2;
    private RendezvousHelper invocationHelper = new RendezvousHelper();
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$rendezvous$service$test$TestClient == null ? (class$org$globus$rendezvous$service$test$TestClient = TestClient.class$("org.globus.rendezvous.service.test.TestClient")) : class$org$globus$rendezvous$service$test$TestClient).getName());
    static /* synthetic */ Class class$org$globus$rendezvous$service$test$TestClient;

    private static byte[] makeInputData(byte[] applicationData) {
        return RendezvousHelper.prependHeader(applicationData, applicationData.length);
    }

    public TestClient(String hostName, byte[] applicationData) {
        this.hostName = hostName;
        this.applicationData = applicationData;
        this.inputData = TestClient.makeInputData(this.applicationData);
    }

    private String getServiceURL() {
        return "https://" + this.hostName + ":8443/wsrf/services/RendezvousFactoryService";
    }

    public static void main(String[] args) throws Exception {
        String hostName = "localhost";
        if (args.length >= 1) {
            hostName = args[0];
        }
        TestClient.executeTestSuite(hostName, TestApplicationData.BINARY_DATA_1);
        TestClient.executeTestSuite(hostName, TestApplicationData.BINARY_DATA_EMPTY);
    }

    private static void executeTestSuite(String hostName, byte[] applicationData) throws Exception {
        new TestClient(hostName, applicationData).testRegistrationWhenCapacityIsZero();
        System.out.println("=================================================");
        new TestClient(hostName, applicationData).testRegistrationWithDesiredRank();
        System.out.println("=================================================");
        new TestClient(hostName, applicationData).testRegistrationWithTakenRank();
        System.out.println("=================================================");
        new TestClient(hostName, applicationData).testRegisterToCompletion();
        System.out.println("=================================================");
    }

    private EndpointReferenceType createRendezvous(int capacity) throws Exception {
        RendezvousFactoryPortType portFactory = this.getFactory();
        CreateSyncResponse createResponse = portFactory.createSync(new CreateSync(capacity));
        EndpointReferenceType epr = createResponse.getEndpointReference();
        return epr;
    }

    private RendezvousFactoryPortType getFactory() throws Exception {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String serviceURL = this.getServiceURL();
        System.out.println("Rendezvous(Factory) service: " + serviceURL);
        endpoint.setAddress((AttributedURI)new Address(serviceURL));
        this.setSecurityTypeFromEndpoint(endpoint);
        RendezvousFactoryPortType portFactory = this.locator.getRendezvousFactoryPortTypePort(endpoint);
        this.setFactorySecurityProperties((Stub)portFactory);
        return portFactory;
    }

    public void testRegistrationWhenCapacityIsZero() throws Exception {
        System.out.println("Test registration when capacity is zero");
        EndpointReferenceType epr = this.createRendezvous(0);
        boolean exceptionWasThrown = false;
        try {
            System.out.println("Trying to register when capacity is zero. This should fail.");
            int rank = this.registerData(epr, TestClient.makeInputData(this.applicationData));
        }
        catch (CapacityReachedFaultType e) {
            System.out.println("Should see exception on server side for rendezvous full");
            System.out.println("Fault Description: " + e.getDescription(0).get_value());
            exceptionWasThrown = true;
        }
        TestClient.check(exceptionWasThrown);
    }

    public void testRegistrationWithDesiredRank() throws Exception {
        System.out.println("Test registration with desired rank");
        EndpointReferenceType epr = this.createRendezvous(10);
        int rank1 = this.registerData(epr, this.inputData, 0);
        TestClient.check(rank1 == 0);
        int rank2 = this.registerData(epr, this.inputData, 1);
        TestClient.check(rank2 == 1);
        int rank3 = this.registerData(epr, this.inputData, 3);
        TestClient.check(rank3 == 3);
        int rank4 = this.registerData(epr, this.inputData, 5);
        TestClient.check(rank4 == 5);
        int rank5 = this.registerData(epr, this.inputData);
        TestClient.check(rank5 == 4, "rank was " + rank5 + " instead of 4");
        int rank6 = this.registerData(epr, this.inputData);
        TestClient.check(rank6 == 2);
        int rank7 = this.registerData(epr, this.inputData);
        TestClient.check(rank7 == 6);
    }

    public void testRegistrationWithTakenRank() throws Exception {
        System.out.println("Test registration with already taken chosen rank");
        EndpointReferenceType epr = this.createRendezvous(10);
        boolean RANK = false;
        int rank1 = this.registerData(epr, this.inputData, 0);
        TestClient.check(rank1 == 0);
        boolean exceptionWasThrown = false;
        try {
            int rank2 = this.registerData(epr, this.inputData, 0);
        }
        catch (RankTakenFaultType e) {
            exceptionWasThrown = true;
            System.out.println("Should see exception on server side for rank already taken");
            System.out.println("Fault Description: " + e.getDescription(0).get_value());
        }
        TestClient.check(exceptionWasThrown);
    }

    public void testRegisterToCompletion() throws Exception {
        System.out.println("TESTING OF register():");
        this.createRendezvousResources();
        int rank = 0;
        rank = this.registerData(this.eprSub1, this.inputData);
        TestClient.check(rank == 0);
        rank = this.registerData(this.eprSub1, this.inputData);
        TestClient.check(rank == 1);
        rank = this.registerData(this.eprSub2, this.inputData);
        TestClient.check(rank == 0);
        rank = this.registerData(this.eprSub2, this.inputData);
        TestClient.check(rank == 1);
        this.waitAndSee();
    }

    private static void check(boolean assertion) {
        TestClient.check(assertion, null);
    }

    private static void check(boolean assertion, String messageIfFailure) {
        if (!assertion) {
            throw new RuntimeException(messageIfFailure);
        }
    }

    private void createRendezvousResources() throws Exception {
        RendezvousFactoryPortType factoryPort = this.getFactory();
        CreateSyncResponse createResponse = factoryPort.createSync(new CreateSync(2));
        this.eprTop = createResponse.getEndpointReference();
        this.eprTop.getProperties().get_any()[0].getValue();
        RendezvousFactoryPortType portTop = this.locator.getRendezvousFactoryPortTypePort(this.eprTop);
        this.invocationHelper.subscribeForCompletionNotifications(this.eprTop, new TopRendezvousCallback());
        createResponse = factoryPort.createSync(new CreateSync(2));
        this.eprSub1 = createResponse.getEndpointReference();
        this.invocationHelper.subscribeForCompletionNotifications(this.eprSub1, new SubRendezvousCallback("1"));
        createResponse = factoryPort.createSync(new CreateSync(2));
        this.eprSub2 = createResponse.getEndpointReference();
        this.invocationHelper.subscribeForCompletionNotifications(this.eprSub2, new SubRendezvousCallback("2"));
        GetResourcePropertyResponse getRPResponse = portTop.getResourceProperty(RendezvousConstants.RP_CAPACITY);
        System.out.println("I see a multijob capacity of: " + getRPResponse.get_any()[0].getValue());
    }

    private int registerData(EndpointReferenceType endpoint, byte[] data) throws Exception {
        return this.registerData(endpoint, data, -1);
    }

    private int registerData(EndpointReferenceType endpoint, byte[] data, int desiredRank) throws Exception {
        System.out.println("About to register data with rank " + desiredRank);
        int rank = this.invocationHelper.registerWithRendezvous(endpoint, data, desiredRank);
        System.out.println("Got rank " + rank);
        return rank;
    }

    private void waitAndSee() throws Exception {
        int timeout = 10000;
        if (!this.isDataReceived()) {
            System.out.println("Waiting for top-level notification for " + timeout + " seconds...");
            Thread.sleep(timeout);
        }
        boolean dataReceived = this.isDataReceived();
        System.out.println("Has data for the whole rendezvous been received? " + dataReceived);
        if (!dataReceived) {
            boolean allDone = this.invocationHelper.isRendezvousDone(this.eprTop);
            TestClient.check(allDone, "Test failed: global rendezvous has not completed after " + timeout + " milliseconds of waiting time.");
        }
        byte[] pulledData = this.invocationHelper.getRegistrantData(this.eprTop);
        if (dataReceived) {
            boolean sameDataInNotificationAndQuery = true;
            if (this.wholeData.length != pulledData.length) {
                sameDataInNotificationAndQuery = false;
            } else {
                for (int i = 0; i < this.wholeData.length; ++i) {
                    if (this.wholeData[i] == pulledData[i]) continue;
                    sameDataInNotificationAndQuery = false;
                    break;
                }
            }
            TestClient.check(sameDataInNotificationAndQuery, "pulled registrant data is different than notified!");
        }
        this.readWholeData2(pulledData);
    }

    private synchronized boolean isDataReceived() {
        return this.wholeData != null;
    }

    private boolean isTopRendezvousDone() throws Exception {
        return this.invocationHelper.isRendezvousDone(this.eprTop);
    }

    private void readWholeData2(byte[] wholeData) {
        this.readItemData(0, wholeData, 2, new String[]{"process", "sub-job"});
    }

    private int readItemData(int offset, byte[] data, int depth, String[] itemNames) {
        System.out.println("depth = " + depth);
        byte[] header = RendezvousHelper.extractHeader(data, offset);
        offset += header.length + 1;
        int numberOfItems = RendezvousHelper.readCount(header);
        System.out.println("Number of items at this depth: " + numberOfItems);
        if (depth == 0) {
            int numberOfBytes = numberOfItems;
            System.out.print("\t" + itemNames[depth] + " data: ");
            for (int i = 0; i < numberOfBytes; ++i) {
                byte dataByte = data[offset + i];
                System.out.print(dataByte + " ");
                TestClient.check(dataByte == this.applicationData[i], "Extracted and registered data bytes do not match");
            }
            System.out.println();
            offset += numberOfBytes;
        } else {
            for (int itemCount = 0; itemCount < numberOfItems; ++itemCount) {
                System.out.println("reading " + itemNames[depth - 1] + " " + itemCount);
                offset = this.readItemData(offset, data, depth - 1, itemNames);
            }
        }
        return offset;
    }

    private void setFactorySecurityProperties(Stub stub) {
    }

    private void setSecurityTypeFromEndpoint(EndpointReferenceType epr) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Endpoint Address URL Scheme:\n" + epr.getAddress().getScheme()));
        }
        if (epr.getAddress().getScheme().equals("http")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using message-level security");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"using transport-level security");
            }
            Util.registerTransport();
        }
    }

    static /* synthetic */ byte[] access$002(TestClient x0, byte[] x1) {
        x0.wholeData = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SubRendezvousCallback
    extends CompletionNotifyCallbackImpl {
        private String id;

        public SubRendezvousCallback(String id) {
            super(null);
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRendezvousCompleted(byte[] dataSet) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                int rank;
                System.out.println("sub-rendezvous " + this.id + " has completed");
                try {
                    rank = TestClient.this.registerData(TestClient.this.eprTop, dataSet);
                }
                catch (Exception e) {
                    String errorMessage = "could not register sub data with top rendezvous";
                    throw new RuntimeException(e);
                }
                System.out.println("Registered whole data set of sub-rendezvous " + this.id + " to top-level rendezvous. Returned rank = " + rank);
            }
        }
    }

    private class TopRendezvousCallback
    extends CompletionNotifyCallbackImpl {
        public TopRendezvousCallback() {
            super(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRendezvousCompleted(byte[] bytes) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("Notification: Top-level rendezvous completed");
                String byteString = "all bytes received: ";
                for (int i = 0; i < bytes.length; ++i) {
                    byteString = byteString + bytes[i] + " ";
                }
                System.out.println(byteString);
                TestClient.access$002(TestClient.this, bytes);
            }
        }
    }

    private static interface TestApplicationData {
        public static final byte[] BINARY_DATA_1 = new byte[]{1, 2, 3};
        public static final byte[] BINARY_DATA_EMPTY = new byte[0];
    }
}

