/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rendezvous.service;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rendezvous.client.RendezvousConstants;
import org.globus.rendezvous.client.RendezvousHelper;
import org.globus.rendezvous.generated.RankTakenFaultType;
import org.globus.rendezvous.generated.RendezvousDataType;
import org.globus.rendezvous.generated.StateChangeNotificationMessageType;
import org.globus.rendezvous.generated.StateChangeNotificationMessageWrapperType;
import org.globus.rendezvous.service.RendezvousResource;
import org.globus.rendezvous.service.utils.FaultUtils;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.impl.ReflectionResource;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleTopic;
import org.globus.wsrf.impl.SimpleTopicList;
import org.globus.wsrf.utils.PerformanceLog;

public class RendezvousResourceImpl
extends ReflectionResource
implements RendezvousResource,
TopicListAccessor {
    private static final SimpleResourcePropertyMetaData RP_DATA_METADATA = new SimpleResourcePropertyMetaData(RendezvousConstants.RP_DATA, 1, 1, false, class$java$lang$Object == null ? (class$java$lang$Object = RendezvousResourceImpl.class$("java.lang.Object")) : class$java$lang$Object, false, Constants.XSD_BASE64);
    private int tally = 0;
    private byte[][] internalBinaryData;
    private TopicList topicList;
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$rendezvous$service$RendezvousResourceImpl == null ? (class$org$globus$rendezvous$service$RendezvousResourceImpl = RendezvousResourceImpl.class$("org.globus.rendezvous.service.RendezvousResourceImpl")) : class$org$globus$rendezvous$service$RendezvousResourceImpl).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$rendezvous$service$utils$Resources == null ? (class$org$globus$rendezvous$service$utils$Resources = RendezvousResourceImpl.class$("org.globus.rendezvous.service.utils.Resources")) : class$org$globus$rendezvous$service$utils$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$rendezvous$service$RendezvousResourceImpl == null ? (class$org$globus$rendezvous$service$RendezvousResourceImpl = RendezvousResourceImpl.class$("org.globus.rendezvous.service.RendezvousResourceImpl")) : class$org$globus$rendezvous$service$RendezvousResourceImpl).getName() + ".performance");
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$globus$rendezvous$generated$RankTakenFaultType;
    static /* synthetic */ Class class$org$globus$rendezvous$service$RendezvousResourceImpl;
    static /* synthetic */ Class class$org$globus$rendezvous$service$utils$Resources;

    public void initialize(Object resourceBean, QName resourceElementQName, Object key) throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"initialize called");
        }
        super.initialize(resourceBean, resourceElementQName, key);
        int capacity = this.getCapacity();
        this.initializeTopics();
    }

    protected ResourceProperty createNewResourceProperty(ResourcePropertyMetaData metaData, Object resourceBean) throws Exception {
        QName rpQName = metaData.getName();
        if (rpQName.equals(RendezvousConstants.RP_DATA)) {
            return super.createNewResourceProperty((ResourcePropertyMetaData)RP_DATA_METADATA, resourceBean);
        }
        return super.createNewResourceProperty(metaData, resourceBean);
    }

    protected void initializeTopics() {
        logger.debug((Object)"Initializing Rendezvous topics");
        this.topicList = new SimpleTopicList((ResourceProperties)this);
        SimpleTopic rendezvousCompletedChangeTopic = new SimpleTopic(RendezvousConstants.RP_COMPLETED);
        this.topicList.addTopic((Topic)rendezvousCompletedChangeTopic);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added topic for rendezvous completion:" + rendezvousCompletedChangeTopic.getName() + " to resource " + this));
        }
    }

    protected void setInternalRendezvousState(RendezvousDataType internalState) {
        if (internalState != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting internal rendezvous state");
            }
            this.tally = internalState.getTally();
            this.internalBinaryData = internalState.getInternalRegistrantData();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No internal rendezvous state to set");
        }
    }

    protected RendezvousDataType getInternalRendezvousState() {
        RendezvousDataType internalState = new RendezvousDataType();
        internalState.setTally(this.tally);
        internalState.setInternalRegistrantData(this.internalBinaryData);
        return internalState;
    }

    private byte[] getMungedData() {
        int capacity = this.getCapacity();
        if (this.tally != capacity) {
            throw new RuntimeException("Tally != capacity");
        }
        int totalDataLength = 0;
        byte[][] dataElements = this.getInternalBinaryData();
        if (capacity != dataElements.length) {
            throw new RuntimeException();
        }
        totalDataLength = 0;
        for (int i = 0; i < capacity; ++i) {
            int dataLength = dataElements[i].length;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("length of data element " + i + ": " + dataLength));
            }
            totalDataLength += dataLength;
        }
        byte[] mungedData = new byte[totalDataLength];
        int idxMunged = 0;
        for (int i = 0; i < capacity; ++i) {
            for (int j = 0; j < dataElements[i].length; ++j) {
                mungedData[idxMunged++] = dataElements[i][j];
            }
        }
        if (idxMunged != totalDataLength) {
            throw new RuntimeException("idxMunged != totalLength");
        }
        byte[] finalData = RendezvousHelper.prependHeader(mungedData, this.tally);
        return finalData;
    }

    public synchronized int register(byte[] data, int desiredRank) throws RankTakenFaultType {
        if (this.isFull()) {
            throw new RuntimeException("Precondition violation: rendezvous resource full");
        }
        int rank = desiredRank;
        if (desiredRank == -1) {
            rank = this.determineRank();
        } else if (this.getInternalBinaryData()[desiredRank] != null) {
            String errorMessage = i18n.getMessage("RankTakenError", (Object)Integer.toString(rank));
            logger.error((Object)errorMessage);
            RankTakenFaultType fault = (RankTakenFaultType)FaultUtils.makeFault(class$org$globus$rendezvous$generated$RankTakenFaultType == null ? (class$org$globus$rendezvous$generated$RankTakenFaultType = RendezvousResourceImpl.class$("org.globus.rendezvous.generated.RankTakenFaultType")) : class$org$globus$rendezvous$generated$RankTakenFaultType, errorMessage, null);
            throw fault;
        }
        this.addData(rank, data);
        if (this.isFull()) {
            this.onBecomingFull();
        }
        return rank;
    }

    private int determineRank() {
        int rank;
        byte[][] internalData = this.getInternalBinaryData();
        if (internalData[rank = this.tally] != null) {
            int max = this.getCapacity();
            for (int i = 0; i < max; ++i) {
                if (internalData[i] != null) continue;
                rank = i;
                break;
            }
        }
        return rank;
    }

    private void addData(int rank, byte[] data) {
        byte[][] contactData = this.getInternalBinaryData();
        contactData[rank] = data;
        ++this.tally;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("number of registrants is " + this.tally));
            String dataString = "";
            for (int i = 0; i < data.length; ++i) {
                dataString = dataString + contactData[rank][i] + " ";
            }
            logger.debug((Object)("Registered the following data: " + dataString));
        }
    }

    private synchronized void onBecomingFull() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Rendezvous completed.");
        }
        this.setRegistrantData(this.getMungedData());
        this.setRendezvousCompletedAndNotify(true);
    }

    public synchronized boolean isFull() {
        return this.tally == this.getCapacity();
    }

    private synchronized byte[][] getInternalBinaryData() {
        int capacity = this.getCapacity();
        if (this.internalBinaryData == null) {
            this.internalBinaryData = new byte[capacity][];
        }
        return this.internalBinaryData;
    }

    public TopicList getTopicList() {
        return this.topicList;
    }

    private int getCapacity() {
        return (Integer)this.getResourcePropertySet().get(RendezvousConstants.RP_CAPACITY).get(0);
    }

    private void setRendezvousCompleted(boolean value) {
        this.getResourcePropertySet().get(RendezvousConstants.RP_COMPLETED).set(0, (Object)new Boolean(value));
    }

    private void setRendezvousCompletedAndNotify(boolean isCompleted) {
        if (!isCompleted) {
            throw new RuntimeException("rendezvous set as not done? weird");
        }
        this.setRendezvousCompleted(isCompleted);
        StateChangeNotificationMessageType message = new StateChangeNotificationMessageType();
        message.setRendezvousCompleted(isCompleted);
        message.setRegistrantData(this.getMungedData());
        StateChangeNotificationMessageWrapperType messageWrapper = new StateChangeNotificationMessageWrapperType();
        messageWrapper.setStateChangeNotificationMessage(message);
        LinkedList<QName> topicPath = new LinkedList<QName>();
        QName topicQName = RendezvousConstants.RP_COMPLETED;
        topicPath.add(topicQName);
        Topic completionTopic = this.getTopicList().getTopic(topicPath);
        logger.debug((Object)"Notifying of rendezvous completion to topic listeners");
        try {
            completionTopic.notify((Object)messageWrapper);
        }
        catch (Exception e) {
            String errorMessage = "Could not notify " + topicQName + " listeners";
            throw new RuntimeException(errorMessage, e);
        }
    }

    private void setRegistrantData(byte[] value) {
        this.getResourcePropertySet().get(RendezvousConstants.RP_DATA).set(0, (Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

