/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rendezvous.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import org.apache.axis.Constants;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rendezvous.client.ClientSecurityStrategy;
import org.globus.rendezvous.client.RendezvousConstants;
import org.globus.rendezvous.generated.RankTakenFaultType;
import org.globus.rendezvous.generated.RegisterInput;
import org.globus.rendezvous.generated.RegisterResponse;
import org.globus.rendezvous.generated.RendezvousPortType;
import org.globus.rendezvous.generated.service.RendezvousServiceAddressingLocator;
import org.globus.util.I18n;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class RendezvousHelper {
    public static final int NO_DESIRED_RANK = -1;
    private ClientSecurityStrategy security;
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$rendezvous$client$RendezvousHelper == null ? (class$org$globus$rendezvous$client$RendezvousHelper = RendezvousHelper.class$("org.globus.rendezvous.client.RendezvousHelper")) : class$org$globus$rendezvous$client$RendezvousHelper).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$rendezvous$client$Resources == null ? (class$org$globus$rendezvous$client$Resources = RendezvousHelper.class$("org.globus.rendezvous.client.Resources")) : class$org$globus$rendezvous$client$Resources).getName());
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$globus$rendezvous$client$RendezvousHelper;
    static /* synthetic */ Class class$org$globus$rendezvous$client$Resources;

    public RendezvousHelper() {
        this(null);
    }

    public RendezvousHelper(ClientSecurityStrategy security) {
        this.security = security;
    }

    private static byte[] makeHeader(int count) {
        String stringHeader = Integer.toString(count) + " ";
        byte[] bytesHeader = stringHeader.getBytes();
        return bytesHeader;
    }

    public static byte[] prependHeader(byte[] data, int count) {
        if (count < 0) {
            throw new RuntimeException();
        }
        byte[] header = RendezvousHelper.makeHeader(count);
        if (count == 0) {
            return header;
        }
        byte[] finalData = new byte[header.length + data.length];
        System.arraycopy(header, 0, finalData, 0, header.length);
        System.arraycopy(data, 0, finalData, header.length, data.length);
        return finalData;
    }

    public static byte[] extractHeader(byte[] data, int beginIndex) {
        byte readByte;
        ArrayList<Byte> byteList = new ArrayList<Byte>(0);
        for (int i = beginIndex; i < data.length && (readByte = data[i]) != 32; ++i) {
            byteList.add(new Byte(readByte));
        }
        byte[] byteArray = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            byteArray[i] = (Byte)byteList.get(i);
        }
        return byteArray;
    }

    public static int readCount(byte[] bytes) {
        String header = new String(bytes);
        System.out.println("Parsing header string " + header);
        int count = 0;
        try {
            count = Integer.parseInt(header);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return count;
    }

    public boolean isRendezvousDone(EndpointReferenceType rendezvousEndpoint) throws Exception {
        RendezvousServiceAddressingLocator locator = new RendezvousServiceAddressingLocator();
        RendezvousPortType port = locator.getRendezvousPortTypePort(rendezvousEndpoint);
        if (this.security != null) {
            this.security.setStubPropertiesForGetResourceProperty((Stub)port);
        }
        GetResourcePropertyResponse getRPResponse = port.getResourceProperty(RendezvousConstants.RP_COMPLETED);
        Boolean done = (Boolean)ObjectDeserializer.toObject((SOAPElement)getRPResponse.get_any()[0], (Class)(class$java$lang$Boolean == null ? (class$java$lang$Boolean = RendezvousHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        return done;
    }

    public byte[] getRegistrantData(EndpointReferenceType rendezvousEndpoint) throws Exception {
        RendezvousServiceAddressingLocator locator = new RendezvousServiceAddressingLocator();
        RendezvousPortType port = locator.getRendezvousPortTypePort(rendezvousEndpoint);
        if (this.security != null) {
            this.security.setStubPropertiesForGetResourceProperty((Stub)port);
        }
        GetResourcePropertyResponse getRPResponse = port.getResourceProperty(RendezvousConstants.RP_DATA);
        getRPResponse.get_any()[0].setType(Constants.XSD_BASE64);
        byte[] data = (byte[])ObjectDeserializer.toObject((SOAPElement)getRPResponse.get_any()[0]);
        return data;
    }

    public void subscribeForCompletionNotifications(EndpointReferenceType rendezvousEndpoint, NotifyCallback notificationCallback) throws Exception {
        this.subscribeForNotifications(rendezvousEndpoint, notificationCallback, RendezvousConstants.RP_COMPLETED);
    }

    public void subscribeForNotifications(EndpointReferenceType rendezvousEndpoint, NotifyCallback notificationCallback, QName topicQName) throws Exception {
        Subscribe request = new Subscribe();
        request.setUseNotify(Boolean.TRUE);
        NotificationConsumerManager notificationConsumerManager = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
        notificationConsumerManager = NotificationConsumerManager.getInstance(properties);
        notificationConsumerManager.startListening();
        EndpointReferenceType notificationConsumerEPR = null;
        ResourceSecurityDescriptor securityDescriptor = null;
        if (this.security != null) {
            securityDescriptor = this.security.getSecurityDescriptor();
        }
        LinkedList<QName> topicPath = new LinkedList<QName>();
        topicPath.add(topicQName);
        notificationConsumerEPR = notificationConsumerManager.createNotificationConsumer(topicPath, notificationCallback, securityDescriptor);
        request.setConsumerReference(notificationConsumerEPR);
        TopicExpressionType topicExpression = new TopicExpressionType();
        topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
        topicExpression.setValue((Object)topicQName);
        request.setTopicExpression(topicExpression);
        RendezvousServiceAddressingLocator locator = new RendezvousServiceAddressingLocator();
        RendezvousPortType port = locator.getRendezvousPortTypePort(rendezvousEndpoint);
        if (this.security != null) {
            this.security.setStubPropertiesForSubscribe((Stub)port);
        }
        port.subscribe(request);
    }

    public int registerWithRendezvous(EndpointReferenceType rendezvousEndpoint, byte[] data) throws Exception {
        int rank = -1;
        try {
            rank = this.registerWithRendezvous(rendezvousEndpoint, data, -1);
        }
        catch (RankTakenFaultType e) {
            String errorMessage = i18n.getMessage("InvalidRankTakenError");
            logger.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage);
        }
        return rank;
    }

    public int registerWithRendezvous(EndpointReferenceType rendezvousEndpoint, byte[] data, int desiredRank) throws Exception {
        RendezvousServiceAddressingLocator locator = new RendezvousServiceAddressingLocator();
        RendezvousPortType parentPort = locator.getRendezvousPortTypePort(rendezvousEndpoint);
        if (this.security != null) {
            this.security.setStubPropertiesForRegister((Stub)parentPort);
        }
        RegisterResponse response = parentPort.register(new RegisterInput(data, desiredRank));
        int rank = response.getRank();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Obtained rank: " + rank));
        }
        return rank;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

