/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rendezvous.client;

import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.rendezvous.client.ClientSecurityStrategy;
import org.globus.rendezvous.generated.StateChangeNotificationMessageType;
import org.globus.util.I18n;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.utils.PerformanceLog;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Element;

public abstract class CompletionNotifyCallbackImpl
implements NotifyCallback {
    private ClientSecurityStrategy security;
    private static final Log logger = LogFactory.getLog((String)(class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl == null ? (class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl = CompletionNotifyCallbackImpl.class$("org.globus.rendezvous.client.CompletionNotifyCallbackImpl")) : class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl).getName());
    private static I18n i18n = I18n.getI18n((String)(class$org$globus$rendezvous$client$Resources == null ? (class$org$globus$rendezvous$client$Resources = CompletionNotifyCallbackImpl.class$("org.globus.rendezvous.client.Resources")) : class$org$globus$rendezvous$client$Resources).getName());
    private static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl == null ? (class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl = CompletionNotifyCallbackImpl.class$("org.globus.rendezvous.client.CompletionNotifyCallbackImpl")) : class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl).getName() + ".performance");
    static /* synthetic */ Class class$org$globus$rendezvous$generated$StateChangeNotificationMessageType;
    static /* synthetic */ Class class$org$globus$rendezvous$client$CompletionNotifyCallbackImpl;
    static /* synthetic */ Class class$org$globus$rendezvous$client$Resources;

    public CompletionNotifyCallbackImpl(ClientSecurityStrategy security) {
        this.security = security;
    }

    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        StateChangeNotificationMessageType changeNotification;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"receiving notification");
            if (message instanceof Element) {
                logger.debug((Object)("message is of type " + message.getClass().getName()));
                logger.debug((Object)("message contents: \n" + XmlUtils.toString((Element)((Element)message))));
            }
        }
        try {
            changeNotification = (StateChangeNotificationMessageType)ObjectDeserializer.toObject((Element)((Element)message), (Class)(class$org$globus$rendezvous$generated$StateChangeNotificationMessageType == null ? (class$org$globus$rendezvous$generated$StateChangeNotificationMessageType = CompletionNotifyCallbackImpl.class$("org.globus.rendezvous.generated.StateChangeNotificationMessageType")) : class$org$globus$rendezvous$generated$StateChangeNotificationMessageType));
        }
        catch (Exception e) {
            String errorMessage = i18n.getMessage("NotificationDeserializationError");
            logger.error((Object)errorMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
        if (!changeNotification.isRendezvousCompleted()) {
            throw new RuntimeException("notification for rendezvous: not complete!");
        }
        byte[] bytes = changeNotification.getRegistrantData();
        if (logger.isDebugEnabled()) {
            String wholeDataString = "";
            for (int i = 0; i < bytes.length; ++i) {
                wholeDataString = wholeDataString + bytes[i] + " ";
            }
            logger.debug((Object)("Value of received binary data: " + wholeDataString));
        }
        this.onRendezvousCompleted(bytes);
    }

    public abstract void onRendezvousCompleted(byte[] var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

