/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationListener;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.service.TestListener;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.Util;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.utils.FilePersistenceHelper;
import org.xml.sax.InputSource;

public class TestResource
implements Resource,
ResourceIdentifier,
PersistenceCallback {
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$service$TestResource == null ? (class$org$globus$delegation$service$TestResource = TestResource.class$("org.globus.delegation.service.TestResource")) : class$org$globus$delegation$service$TestResource).getName());
    QName qName = new QName("", "DelegatedEPR");
    int callbackCount = 0;
    String resourceId;
    GlobusCredential credential = null;
    EndpointReferenceType delegatedEpr = null;
    String listenerId = null;
    private FilePersistenceHelper persistenceHelper;
    String HOME_LOCATION = "java:comp/env//services/DelegationTestService/home";
    static /* synthetic */ Class class$org$globus$delegation$service$TestResource;
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;

    public TestResource() {
    }

    public TestResource(String resId) {
        this.resourceId = resId;
    }

    public Object getID() {
        return this.resourceId;
    }

    public void initialize(EndpointReferenceType epr, int counter, ResourceKey key) throws Exception {
        this.delegatedEpr = epr;
        TestListener listener = new TestListener(this.HOME_LOCATION, key);
        if (counter == 2) {
            DelegationUtil.registerDelegationListener((EndpointReferenceType)epr, (DelegationListener)listener, null);
        } else if (counter == 3) {
            Subject testSubject = new Subject();
            testSubject.getPrincipals().add((Principal)new GlobusPrincipal("test user"));
            DelegationUtil.registerDelegationListener((EndpointReferenceType)epr, (DelegationListener)listener, (Subject)testSubject);
        } else {
            DelegationUtil.registerDelegationListener((EndpointReferenceType)epr, (DelegationListener)listener);
        }
        this.listenerId = listener.getId();
        this.store();
    }

    public void setCredential(GlobusCredential _credential) {
        System.out.println("Called set credential");
        this.credential = _credential;
        ++this.callbackCount;
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new RuntimeException("Error storing resource " + exp.getMessage());
        }
    }

    public GlobusCredential getCredential() {
        return this.credential;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store() throws ResourceException {
        File file;
        File tmpFile;
        block9: {
            FileOutputStream fos = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("testDelegation", ".tmp", this.getPersistenceHelper().getStorageDirectory());
                    fos = new FileOutputStream(tmpFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeInt(this.callbackCount);
                    oos.writeObject(this.listenerId);
                    oos.writeObject(ObjectSerializer.toString((Object)this.delegatedEpr, (QName)this.qName));
                    this.credential.save((OutputStream)oos);
                }
                catch (Exception e) {
                    tmpFile.delete();
                    throw new ResourceException("Error storing resource ", (Throwable)e);
                }
                Object var5_5 = null;
                if (fos == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fos.close();
        }
        if ((file = this.getKeyAsFile(this.resourceId)).exists()) {
            file.delete();
        }
        if (!tmpFile.renameTo(file)) {
            tmpFile.delete();
            throw new ResourceException("Errpr storing resource");
        }
        if (Util.setFilePermissions((String)file.getAbsolutePath(), (int)700)) return;
        System.out.println("Check file permissions " + file.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        this.resourceId = (String)key.getValue();
        File file = this.getKeyAsFile(this.resourceId);
        if (!file.exists()) {
            throw new NoSuchResourceException();
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.callbackCount = ois.readInt();
                this.listenerId = (String)ois.readObject();
                String delStr = (String)ois.readObject();
                System.out.println("Loading delegated EPR");
                InputSource is = new InputSource(new StringReader(delStr));
                this.delegatedEpr = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)is, (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = TestResource.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType));
                this.credential = new GlobusCredential((InputStream)ois);
                System.out.println("On load " + key + " " + this.callbackCount);
            }
            catch (Exception e) {
                logger.error((Object)"Error loading resource trace ", (Throwable)e);
                throw new ResourceException("Error loading resource", (Throwable)e);
            }
            Object var8_8 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ee) {}
        fis.close();
        return;
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(this.getClass(), ".ser");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }

    private File getKeyAsFile(Object key) throws InvalidResourceKeyException {
        if (key instanceof String) {
            return this.getPersistenceHelper().getKeyAsFile(key);
        }
        throw new InvalidResourceKeyException();
    }

    public void remove() throws ResourceException {
        System.out.println("Remove called");
        this.getPersistenceHelper().remove((Object)this.resourceId);
    }

    public int getCallbackCount() throws RemoteException {
        if (this.callbackCount == 4) {
            System.out.println("Calling remove on " + this.listenerId);
            try {
                DelegationUtil.removeDelegationListener((EndpointReferenceType)this.delegatedEpr, (String)this.listenerId);
            }
            catch (Exception exp) {
                throw new RemoteException(exp.getMessage());
            }
        }
        return this.callbackCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

