/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.delegation.DelegationUtil;
import org.globus.delegationService.DelegationPortType;
import org.globus.delegationService.DelegationServiceAddressingLocator;
import org.globus.delegationService.test.DelegationTestPortType;
import org.globus.delegationService.test.DelegationTestServiceAddressingLocator;
import org.globus.delegationService.test.DelegationTestServiceLocator;
import org.globus.delegationService.test.VoidType;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.ws.trust.RequestSecurityTokenType;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.test.GridTestCase;
import org.globus.wsrf.utils.AddressingUtils;
import org.xml.sax.InputSource;

public class DelegationServiceTest
extends GridTestCase {
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$service$DelegationServiceTest == null ? (class$org$globus$delegation$service$DelegationServiceTest = DelegationServiceTest.class$("org.globus.delegation.service.DelegationServiceTest")) : class$org$globus$delegation$service$DelegationServiceTest).getName());
    public static String DELEG_EPR_FILE_NAME = "delegationTestEpr";
    public static String TEST_EPR_FILE_NAME = "testServiceEpr";
    String SERVICE_NAME = "DelegationService";
    String FACTORY_NAME = "DelegationFactoryService";
    String TEST_SERVICE_NAME = "DelegationTestService";
    private static boolean postPackage = false;
    String factoryUrl;
    String serviceUrl;
    String testServiceUrl;
    int lifetime = 30000;
    GlobusCredential credential;
    X509Certificate[] certsToDelegateOn;
    X509Certificate certToSign;
    static String mechanism = null;
    static Object protection = null;
    static /* synthetic */ Class class$org$globus$delegation$service$DelegationServiceTest;
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;

    public static void setPostPackage(boolean _postPackage) {
        postPackage = _postPackage;
    }

    public static void setParameters(String authObj, Object authVal) {
        mechanism = authObj;
        protection = authVal;
    }

    public DelegationServiceTest(String name) {
        super(name);
    }

    public void test() throws Exception {
        DelegationServiceTest.assertTrue((TEST_CONTAINER != null ? 1 : 0) != 0);
        this.factoryUrl = TEST_CONTAINER.getBaseURL() + this.FACTORY_NAME;
        this.serviceUrl = TEST_CONTAINER.getBaseURL() + this.SERVICE_NAME;
        this.testServiceUrl = TEST_CONTAINER.getBaseURL() + this.TEST_SERVICE_NAME;
        System.out.println("Test service " + this.testServiceUrl);
        this.credential = GlobusCredential.getDefaultCredential();
        logger.debug((Object)("Factory: " + this.factoryUrl));
        EndpointReferenceType delegEpr = AddressingUtils.createEndpointReference((String)this.factoryUrl, null);
        logger.debug((Object)("EPR " + delegEpr));
        this.certsToDelegateOn = DelegationUtil.getCertificateChainRP((EndpointReferenceType)delegEpr, (ClientSecurityDescriptor)this.getClientSecDesc());
        logger.debug((Object)"Certs from server");
        for (int i = 0; i < this.certsToDelegateOn.length; ++i) {
            logger.debug((Object)("Certs " + this.certsToDelegateOn[i].getSubjectDN()));
        }
        this.certToSign = this.certsToDelegateOn[0];
        if (!postPackage) {
            logger.debug((Object)"First test");
            EndpointReferenceType ref = this.delegate();
            this.testDelegationService(ref);
            this.saveEprToFile(ref, DELEG_EPR_FILE_NAME);
        } else {
            logger.debug((Object)"Second test");
            EndpointReferenceType delegatedRef = this.readEprFromFile(DELEG_EPR_FILE_NAME);
            AttributedURI uri = delegatedRef.getAddress();
            uri.setPort(TEST_CONTAINER.getPort());
            delegatedRef.setAddress(uri);
            this.testDelegationService(delegatedRef);
            File file = new File(DELEG_EPR_FILE_NAME);
            file.delete();
            file = new File(TEST_EPR_FILE_NAME);
            file.delete();
        }
    }

    private EndpointReferenceType delegate() throws Exception {
        ClientSecurityDescriptor desc = this.getClientSecDesc();
        EndpointReferenceType ref = DelegationUtil.delegate((String)this.factoryUrl, (GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)false, (ClientSecurityDescriptor)desc);
        return ref;
    }

    private void testDelegationService(EndpointReferenceType delegatedRef) throws Exception {
        DelegationTestServiceLocator testLocator = new DelegationTestServiceLocator();
        DelegationTestPortType testPort = testLocator.getDelegationTestPortTypePort(new URL(this.testServiceUrl));
        ((Stub)testPort)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)new NoAuthorization());
        EndpointReferenceType testResource = testPort.create(delegatedRef);
        if (!postPackage) {
            this.saveEprToFile(testResource, TEST_EPR_FILE_NAME);
        }
        DelegationTestServiceAddressingLocator testLocator1 = new DelegationTestServiceAddressingLocator();
        DelegationTestPortType testPort1 = testLocator1.getDelegationTestPortTypePort(testResource);
        ((Stub)testPort1)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
        ((Stub)testPort1)._setProperty("org.globus.security.authorization", (Object)new NoAuthorization());
        DelegationServiceTest.assertTrue((testPort1.getCallbackCount(new VoidType()) == 1 ? 1 : 0) != 0);
        DelegationServiceAddressingLocator locator1 = new DelegationServiceAddressingLocator();
        DelegationPortType delegationPort1 = locator1.getDelegationPortTypePort(delegatedRef);
        RequestSecurityTokenType requestToken = DelegationUtil.getTokenToDelegate((GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)true);
        boolean exception = false;
        try {
            delegationPort1.refresh(requestToken);
        }
        catch (Exception exp) {
            exception = true;
        }
        DelegationServiceTest.assertTrue((boolean)exception);
        DelegationServiceTest.assertTrue((testPort1.getCallbackCount(new VoidType()) == 1 ? 1 : 0) != 0);
        DelegationUtil.refresh((GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)true, (ClientSecurityDescriptor)this.getClientSecDesc(), (EndpointReferenceType)delegatedRef);
        DelegationServiceTest.assertTrue((testPort1.getCallbackCount(new VoidType()) == 2 ? 1 : 0) != 0);
        if (postPackage) {
            EndpointReferenceType testRef = this.readEprFromFile(TEST_EPR_FILE_NAME);
            AttributedURI uri = testRef.getAddress();
            uri.setPort(TEST_CONTAINER.getPort());
            testRef.setAddress(uri);
            System.out.println("test ref " + testRef);
            DelegationTestServiceAddressingLocator testServiceLoc = new DelegationTestServiceAddressingLocator();
            testPort = testServiceLoc.getDelegationTestPortTypePort(testRef);
            ((Stub)testPort)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
            ((Stub)testPort)._setProperty("org.globus.security.authorization", (Object)new NoAuthorization());
            DelegationServiceTest.assertTrue((testPort.getCallbackCount(new VoidType()) == 3 ? 1 : 0) != 0);
            DelegationUtil.refresh((GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)true, (ClientSecurityDescriptor)this.getClientSecDesc(), (EndpointReferenceType)delegatedRef);
            DelegationTestServiceLocator newTestLocator = new DelegationTestServiceLocator();
            DelegationTestPortType newTestPort = newTestLocator.getDelegationTestPortTypePort(new URL(this.testServiceUrl));
            ((Stub)newTestPort)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
            ((Stub)newTestPort)._setProperty("org.globus.security.authorization", (Object)new NoAuthorization());
            this.testFailure(newTestPort, delegatedRef);
            EndpointReferenceType newTestResource = newTestPort.create(delegatedRef);
            DelegationTestServiceAddressingLocator newTestLocator1 = new DelegationTestServiceAddressingLocator();
            DelegationTestPortType newTestPort1 = newTestLocator1.getDelegationTestPortTypePort(newTestResource);
            ((Stub)newTestPort1)._setProperty("org.globus.security.secMsg.msg.type", (Object)GSIConstants.SIGNATURE);
            ((Stub)newTestPort1)._setProperty("org.globus.security.authorization", (Object)new NoAuthorization());
            DelegationServiceTest.assertTrue((newTestPort1.getCallbackCount(new VoidType()) == 1 ? 1 : 0) != 0);
            DelegationServiceTest.assertTrue((testPort.getCallbackCount(new VoidType()) == 4 ? 1 : 0) != 0);
            DelegationUtil.refresh((GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)true, (ClientSecurityDescriptor)this.getClientSecDesc(), (EndpointReferenceType)delegatedRef);
            DelegationServiceTest.assertTrue((newTestPort1.getCallbackCount(new VoidType()) == 2 ? 1 : 0) != 0);
            DelegationUtil.refresh((GlobusCredential)this.credential, (X509Certificate)this.certToSign, (int)this.lifetime, (boolean)true, (ClientSecurityDescriptor)this.getClientSecDesc(), (EndpointReferenceType)delegatedRef);
            DelegationServiceTest.assertTrue((testPort.getCallbackCount(new VoidType()) == 4 ? 1 : 0) != 0);
            DelegationServiceTest.assertTrue((newTestPort1.getCallbackCount(new VoidType()) == 3 ? 1 : 0) != 0);
        } else {
            this.testFailure(testPort, delegatedRef);
        }
    }

    private void testFailure(DelegationTestPortType testPort, EndpointReferenceType delegatedRef) throws Exception {
        boolean exp = false;
        try {
            testPort.create(delegatedRef);
            DelegationServiceTest.fail((String)"Did not throw exception as expected");
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Unable to retrieve caller") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        DelegationServiceTest.assertTrue((boolean)exp);
        exp = false;
        try {
            testPort.create(delegatedRef);
            DelegationServiceTest.fail((String)"Did not throw exception as expected");
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("is not authorized to access this resource") != -1) {
                exp = true;
            }
            e.printStackTrace();
        }
        DelegationServiceTest.assertTrue((boolean)exp);
        testPort.create(delegatedRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveEprToFile(EndpointReferenceType ref, String fileName) throws Exception {
        String eprStr = ObjectSerializer.toString((Object)ref, (QName)new QName("", "EPR"));
        FileWriter writer = null;
        try {
            writer = new FileWriter(fileName);
            writer.write(eprStr);
            Object var6_5 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EndpointReferenceType readEprFromFile(String fileName) throws Exception {
        FileInputStream in = null;
        EndpointReferenceType ref = null;
        try {
            in = new FileInputStream(fileName);
            ref = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)new InputSource(in), (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = DelegationServiceTest.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType));
            Object var5_4 = null;
            if (in == null) return ref;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return ref;
        }
        catch (Exception e) {}
        return ref;
    }

    private ClientSecurityDescriptor getClientSecDesc() {
        ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
        if (mechanism.equals("org.globus.security.secMsg.msg.type")) {
            desc.setGSISecureMsg((Integer)protection);
        } else if (mechanism.equals("org.globus.security.secConv.msg.type")) {
            desc.setGSISecureConv((Integer)protection);
        } else if (mechanism.equals("org.globus.security.transport.type")) {
            desc.setGSITransport((Integer)protection);
        }
        System.out.println("Desc " + mechanism);
        desc.setAuthz((Authorization)new NoAuthorization());
        return desc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

