/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.globus.delegation.DelegationException;
import org.globus.delegation.DelegationListener;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.service.DelegationHome;
import org.globus.gsi.GlobusCredential;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.util.Util;
import org.globus.wsrf.InvalidResourceKeyException;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.PersistenceCallback;
import org.globus.wsrf.RemoveCallback;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.FilePersistenceHelper;

public class DelegationResource
implements Resource,
ResourceIdentifier,
ResourceLifetime,
SecureResource,
RemoveCallback,
PersistenceCallback {
    private ResourceSecurityDescriptor desc = null;
    private static I18n i18n = I18n.getI18n((String)"org.globus.delegation.errors", (ClassLoader)(class$org$globus$delegation$service$DelegationResource == null ? (class$org$globus$delegation$service$DelegationResource = DelegationResource.class$("org.globus.delegation.service.DelegationResource")) : class$org$globus$delegation$service$DelegationResource).getClassLoader());
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$service$DelegationResource == null ? (class$org$globus$delegation$service$DelegationResource = DelegationResource.class$("org.globus.delegation.service.DelegationResource")) : class$org$globus$delegation$service$DelegationResource).getName());
    private FilePersistenceHelper persistenceHelper;
    private GlobusCredential credential = null;
    private String callerDN = null;
    private String localName = null;
    private String resourceDescPath = null;
    private Calendar terminationTime = null;
    private HashMap listeners = new HashMap();
    private String resourceId;
    static /* synthetic */ Class class$org$globus$delegation$service$DelegationResource;

    public void create(BinarySecurity _token, String _callerDN, String _localName, String _resourceDescPath, String id) throws DelegationException {
        logger.debug((Object)"Create called");
        if (_token == null) {
            logger.error((Object)i18n.getMessage("tokenNull"));
            throw new DelegationException(i18n.getMessage("tokenNull"));
        }
        this.resourceId = id;
        this.callerDN = _callerDN;
        this.resourceDescPath = _resourceDescPath;
        String baseDir = null;
        MessageContext msgCtx = MessageContext.getCurrentContext();
        if (msgCtx != null) {
            baseDir = (String)msgCtx.getProperty("configPath");
        }
        if (baseDir != null) {
            this.resourceDescPath = baseDir + File.separator + this.resourceDescPath;
        }
        logger.debug((Object)this.resourceDescPath);
        this.localName = _localName;
        this.setToken(_token);
        this.initialize();
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new DelegationException(exp);
        }
    }

    private void initialize() throws DelegationException {
        logger.debug((Object)"Setting expiration time and security desc");
        this.setExpirationTime();
        this.setResourceDescriptor();
    }

    public Object getID() {
        return this.resourceId;
    }

    public void storeToken(BinarySecurity token) throws DelegationException {
        this.setToken(token);
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new DelegationException(exp);
        }
    }

    private void setToken(BinarySecurity token) throws DelegationException {
        X509Certificate[] certChain = this.getCertificateChain(token);
        PrivateKey privateKey = DelegationUtil.getServicePrivateKey("DelegationService", true);
        this.credential = new GlobusCredential(privateKey, certChain);
        this.setExpirationTime();
        this.notifyListeners();
    }

    public GlobusCredential getCredential() throws DelegationException {
        this.authorize();
        return this.credential;
    }

    public GlobusCredential getCredential(Subject subject) throws DelegationException {
        this.authorize(subject);
        return this.credential;
    }

    public void addRefreshListener(DelegationListener listener) throws DelegationException {
        this.authorize();
        this.addListener(listener);
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new DelegationException(exp);
        }
    }

    public void addRefreshListener(DelegationListener listener, Subject subject) throws DelegationException {
        this.authorize(subject);
        this.addListener(listener);
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new DelegationException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(DelegationListener listener) throws DelegationException {
        if (listener == null) {
            logger.error((Object)i18n.getMessage("listenerNull"));
            throw new DelegationException(i18n.getMessage("listenerNull"));
        }
        String listenerId = DelegationHome.uuidGen.nextUUID();
        listener.setId(listenerId);
        DelegationResource delegationResource = this;
        synchronized (delegationResource) {
            this.listeners.put(listenerId, listener);
        }
        try {
            listener.setCredential(this.credential);
        }
        catch (RuntimeException e) {
            logger.warn((Object)i18n.getMessage("setCredError"), (Throwable)e);
        }
    }

    public synchronized void removeRefreshListener(String listenerId) {
        if (this.listeners.remove(listenerId) == null) {
            logger.warn((Object)i18n.getMessage("removeErr"));
        } else {
            try {
                this.store();
            }
            catch (ResourceException exp) {
                throw new RuntimeException(exp.getMessage());
            }
        }
    }

    public void setTerminationTime(Calendar _terminationTime) {
        this.terminationTime = _terminationTime;
        try {
            this.store();
        }
        catch (ResourceException exp) {
            throw new RuntimeException(exp.getMessage());
        }
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    private X509Certificate[] getCertificateChain(BinarySecurity token) throws DelegationException {
        X509Certificate[] certificates = null;
        if (token instanceof PKIPathSecurity) {
            try {
                certificates = ((PKIPathSecurity)token).getX509Certificates(false, (Crypto)new ContextCrypto());
            }
            catch (IOException exp) {
                logger.error((Object)exp);
                throw new DelegationException(exp);
            }
        } else if (token instanceof X509Security) {
            certificates = new X509Certificate[1];
            try {
                certificates[0] = ((X509Security)token).getX509Certificate((Crypto)new ContextCrypto());
            }
            catch (WSSecurityException e) {
                logger.error((Object)e);
                throw new DelegationException(e);
            }
        } else {
            String err = i18n.getMessage("unsupportedToken", new Object[]{token.getClass().getName()});
            logger.error((Object)err);
            throw new DelegationException(err);
        }
        return certificates;
    }

    private void setExpirationTime() {
        X509Certificate[] certs = this.credential.getCertificateChain();
        Date earliestTime = null;
        for (int i = 0; i < certs.length; ++i) {
            Date time = certs[i].getNotAfter();
            if (earliestTime != null && !time.before(earliestTime)) continue;
            earliestTime = time;
        }
        if (this.terminationTime == null) {
            this.terminationTime = Calendar.getInstance();
        }
        this.terminationTime.setTime(earliestTime);
        logger.debug((Object)("termination time set to: " + this.terminationTime.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() throws DelegationException {
        HashMap clone = null;
        DelegationResource delegationResource = this;
        synchronized (delegationResource) {
            clone = (HashMap)this.listeners.clone();
        }
        Iterator iter = clone.entrySet().iterator();
        while (iter.hasNext()) {
            DelegationListener refListener = (DelegationListener)iter.next().getValue();
            try {
                refListener.setCredential(this.credential);
            }
            catch (RuntimeException e) {
                logger.warn((Object)i18n.getMessage("setCredError"), (Throwable)e);
            }
        }
    }

    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return this.desc;
    }

    private void setResourceDescriptor() throws DelegationException {
        ResourceSecurityConfig securityConfig = new ResourceSecurityConfig(this.resourceDescPath);
        try {
            securityConfig.init();
        }
        catch (ConfigException exp) {
            logger.error((Object)i18n.getMessage("securityDescInitErr"), (Throwable)exp);
            throw new DelegationException(i18n.getMessage("securityDescInitErr"), exp);
        }
        this.desc = securityConfig.getSecurityDescriptor();
        GridMap gridMap = new GridMap();
        gridMap.map(this.callerDN, this.localName);
        this.desc.setGridMap(gridMap);
    }

    private void authorize(Subject subject) throws DelegationException {
        Principal principal = SecurityManager.getManager().getCallerPrincipal(subject);
        String callerDN = null;
        if (principal != null) {
            callerDN = principal.getName();
        }
        this.authorize(callerDN);
    }

    private void authorize() throws DelegationException {
        String callerDN = SecurityManager.getManager().getCaller();
        logger.debug((Object)("Caller DN from message context is " + callerDN));
        this.authorize(callerDN);
    }

    private void authorize(String callerDN) throws DelegationException {
        if (callerDN == null) {
            logger.error((Object)i18n.getMessage("unknownCaller"));
            throw new DelegationException(i18n.getMessage("unknownCaller"));
        }
        if (this.desc == null) {
            logger.error((Object)i18n.getMessage("securityDescNull"));
            throw new IllegalStateException(i18n.getMessage("securityDescNull"));
        }
        GridMap gridMap = this.desc.getGridMap();
        if (gridMap == null) {
            logger.error((Object)i18n.getMessage("gridMapNull"));
            throw new IllegalStateException(i18n.getMessage("gridMapNull"));
        }
        String[] username = gridMap.getUserIDs(callerDN);
        if (username == null || username.length < 1) {
            logger.error((Object)i18n.getMessage("unAuthzCaller", new Object[]{callerDN}));
            throw new DelegationException(i18n.getMessage("unAuthzCaller", new Object[]{callerDN}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(ResourceKey key) throws ResourceException, NoSuchResourceException, InvalidResourceKeyException {
        this.resourceId = (String)key.getValue();
        File file = this.getKeyAsFile(this.resourceId);
        if (!file.exists()) {
            throw new NoSuchResourceException();
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.callerDN = (String)ois.readObject();
                this.localName = (String)ois.readObject();
                this.resourceDescPath = (String)ois.readObject();
                this.terminationTime = (Calendar)ois.readObject();
                this.listeners = (HashMap)ois.readObject();
                this.credential = new GlobusCredential((InputStream)ois);
                this.initialize();
            }
            catch (Exception e) {
                throw new ResourceException(i18n.getMessage("resourceLoadErr"), (Throwable)e);
            }
            Object var6_6 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ee) {}
        fis.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void store() throws ResourceException {
        File file;
        File tmpFile;
        block10: {
            FileOutputStream fos = null;
            tmpFile = null;
            try {
                try {
                    tmpFile = File.createTempFile("delegation", ".tmp", this.getPersistenceHelper().getStorageDirectory());
                    if (!Util.setFilePermissions((String)tmpFile.getAbsolutePath(), (int)700)) {
                        logger.warn((Object)i18n.getMessage("checkFilePerms", new Object[]{tmpFile.getAbsolutePath()}));
                    }
                    fos = new FileOutputStream(tmpFile);
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.callerDN);
                    oos.writeObject(this.localName);
                    oos.writeObject(this.resourceDescPath);
                    oos.writeObject(this.terminationTime);
                    oos.writeObject(this.listeners);
                    this.credential.save((OutputStream)oos);
                }
                catch (Exception e) {
                    if (tmpFile == null) throw new ResourceException(i18n.getMessage("resourceStoreErr"), (Throwable)e);
                    tmpFile.delete();
                    throw new ResourceException(i18n.getMessage("resourceStoreErr"), (Throwable)e);
                }
                Object var5_5 = null;
                if (fos == null) break block10;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ee) {}
            fos.close();
        }
        if ((file = this.getKeyAsFile(this.resourceId)).exists()) {
            file.delete();
        }
        if (!tmpFile.renameTo(file)) {
            tmpFile.delete();
            throw new ResourceException(i18n.getMessage("resourceStoreErr"));
        }
        if (Util.setFilePermissions((String)file.getAbsolutePath(), (int)700)) return;
        logger.warn((Object)i18n.getMessage("checkFilePerms", new Object[]{file.getAbsolutePath()}));
    }

    protected synchronized FilePersistenceHelper getPersistenceHelper() {
        if (this.persistenceHelper == null) {
            try {
                this.persistenceHelper = new FilePersistenceHelper(this.getClass(), ".ser");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.persistenceHelper;
    }

    private File getKeyAsFile(Object key) throws InvalidResourceKeyException {
        if (key instanceof String) {
            return this.getPersistenceHelper().getKeyAsFile(key);
        }
        throw new InvalidResourceKeyException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCredentialDelete() {
        logger.debug((Object)"notify removal");
        HashMap clone = null;
        DelegationResource delegationResource = this;
        synchronized (delegationResource) {
            clone = (HashMap)this.listeners.clone();
        }
        Iterator iter = clone.entrySet().iterator();
        while (iter.hasNext()) {
            DelegationListener refListener = (DelegationListener)iter.next().getValue();
            refListener.credentialDeleted();
        }
    }

    public synchronized void remove() throws ResourceException {
        logger.debug((Object)"Remove called");
        this.notifyCredentialDelete();
        this.listeners.clear();
        this.getPersistenceHelper().remove((Object)this.resourceId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

