/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.service;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.token.BinarySecurity;
import org.globus.delegation.DelegationException;
import org.globus.delegation.service.DelegationResource;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.ResourceSweeper;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AddressingUtils;

public class DelegationHome
extends ResourceHomeImpl {
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$service$DelegationHome == null ? (class$org$globus$delegation$service$DelegationHome = DelegationHome.class$("org.globus.delegation.service.DelegationHome")) : class$org$globus$delegation$service$DelegationHome).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.delegation.errors", (ClassLoader)(class$org$globus$delegation$service$DelegationHome == null ? (class$org$globus$delegation$service$DelegationHome = DelegationHome.class$("org.globus.delegation.service.DelegationHome")) : class$org$globus$delegation$service$DelegationHome).getClassLoader());
    String resourceDescPath;
    public static UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    static /* synthetic */ Class class$org$globus$delegation$service$DelegationHome;

    public Resource find(ResourceKey key) throws ResourceException {
        Resource resource = null;
        try {
            resource = super.find(key);
        }
        catch (NoSuchResourceException exp) {
            resource = this.createNewInstance();
            ((DelegationResource)resource).load(key);
        }
        if (ResourceSweeper.isExpired((Resource)resource)) {
            this.remove(key);
            throw new NoSuchResourceException();
        }
        if (resource == null) {
            throw new NoSuchResourceException();
        }
        return resource;
    }

    public EndpointReferenceType create(BinarySecurity token, String callerDN, String localName) throws DelegationException {
        DelegationResource resource = null;
        try {
            resource = (DelegationResource)this.createNewInstance();
        }
        catch (ResourceException exp) {
            logger.error((Object)i18n.getMessage("createTokenErr"), (Throwable)exp);
            throw new DelegationException(i18n.getMessage("createTokenErr"), exp);
        }
        resource.create(token, callerDN, localName, this.resourceDescPath, uuidGen.nextUUID());
        SimpleResourceKey key = new SimpleResourceKey(this.keyTypeName, resource.getID());
        this.add((ResourceKey)key, resource);
        logger.debug((Object)("Added " + key));
        EndpointReferenceType epr = null;
        try {
            String addr = ServiceHost.getBaseURL() + "DelegationService";
            epr = AddressingUtils.createEndpointReference((String)addr, (ResourceKey)key);
        }
        catch (Exception exp) {
            throw new DelegationException(exp);
        }
        logger.debug((Object)("EPR for resource: " + epr));
        return epr;
    }

    public void setResourceDescPath(String _resourceDescPath) {
        this.resourceDescPath = _resourceDescPath;
    }

    public String getResourceDescPath() {
        return this.resourceDescPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

