/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.factory;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.globus.delegation.DelegationConstants;
import org.globus.delegation.DelegationException;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.service.DelegationHome;
import org.globus.delegationService.CertType;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;

public class DelegationFactoryResource
implements Resource,
ResourceProperties {
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$factory$DelegationFactoryResource == null ? (class$org$globus$delegation$factory$DelegationFactoryResource = DelegationFactoryResource.class$("org.globus.delegation.factory.DelegationFactoryResource")) : class$org$globus$delegation$factory$DelegationFactoryResource).getName());
    ResourcePropertySet propSet;
    QName RP_SET = new QName(DelegationConstants.NS, "DelegationFactoryRPSet");
    static /* synthetic */ Class class$org$globus$delegation$factory$DelegationFactoryResource;

    public DelegationFactoryResource() throws DelegationException {
        this.setResourceProperties();
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.propSet;
    }

    private void setResourceProperties() throws DelegationException {
        this.propSet = new SimpleResourcePropertySet(this.RP_SET);
        PKIPathSecurity publicCertToken = DelegationUtil.getServiceCertAsToken("DelegationFactoryService", true);
        this.propSet = new SimpleResourcePropertySet(this.RP_SET);
        QName qName = new QName(DelegationConstants.NS, "CertificateChain");
        SimpleResourceProperty prop = new SimpleResourceProperty(qName);
        prop.add((Object)new CertType(new MessageElement[]{new MessageElement(publicCertToken.getElement())}));
        this.propSet.add((ResourceProperty)prop);
    }

    public EndpointReferenceType createServiceResource(BinarySecurity token) throws DelegationException {
        DelegationHome serviceHome = this.getServiceHome();
        SecurityManager manager = SecurityManager.getManager();
        String callerDN = manager.getCaller();
        String localName = null;
        try {
            localName = manager.getLocalUsernames()[0];
        }
        catch (SecurityException exp) {
            throw new DelegationException(exp);
        }
        logger.debug((Object)("Local name " + localName));
        return serviceHome.create(token, callerDN, localName);
    }

    protected DelegationHome getServiceHome() throws DelegationException {
        try {
            InitialContext context = new InitialContext();
            logger.debug((Object)"java:comp/env//services/DelegationService/home");
            return (DelegationHome)((Object)context.lookup("java:comp/env//services/DelegationService/home"));
        }
        catch (Exception exp) {
            throw new DelegationException(exp);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

