/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.globus.delegation.DelegationConstants;
import org.globus.delegation.DelegationException;
import org.globus.delegation.DelegationListener;
import org.globus.delegation.service.DelegationHome;
import org.globus.delegation.service.DelegationResource;
import org.globus.delegationService.DelegationFactoryPortType;
import org.globus.delegationService.DelegationFactoryServiceAddressingLocator;
import org.globus.delegationService.DelegationFactoryServiceLocator;
import org.globus.delegationService.DelegationPortType;
import org.globus.delegationService.DelegationServiceAddressingLocator;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.I18n;
import org.globus.ws.trust.RequestSecurityTokenResponseType;
import org.globus.ws.trust.RequestSecurityTokenType;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DelegationUtil {
    static Log logger = LogFactory.getLog((String)(class$org$globus$delegation$DelegationUtil == null ? (class$org$globus$delegation$DelegationUtil = DelegationUtil.class$("org.globus.delegation.DelegationUtil")) : class$org$globus$delegation$DelegationUtil).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.delegation.errors", (ClassLoader)(class$org$globus$delegation$DelegationUtil == null ? (class$org$globus$delegation$DelegationUtil = DelegationUtil.class$("org.globus.delegation.DelegationUtil")) : class$org$globus$delegation$DelegationUtil).getClassLoader());
    static /* synthetic */ Class class$org$globus$delegation$DelegationUtil;
    static /* synthetic */ Class class$org$globus$delegationService$CertType;

    public static PKIPathSecurity getServiceCertAsToken(String servicePath, boolean useDefault) throws DelegationException {
        GlobusCredential cred = DelegationUtil.getServiceCredential(servicePath, useDefault);
        if (cred == null) {
            throw new DelegationException(i18n.getMessage("insecureService"));
        }
        X509Certificate[] certChain = cred.getCertificateChain();
        PKIPathSecurity publicCertToken = null;
        if (certChain == null) {
            throw new DelegationException(i18n.getMessage("certChainNotFound"));
        }
        publicCertToken = DelegationUtil.getPKIToken(certChain, false);
        return publicCertToken;
    }

    public static PrivateKey getServicePrivateKey(String servicePath, boolean useDefault) throws DelegationException {
        GlobusCredential cred = DelegationUtil.getServiceCredential(servicePath, useDefault);
        if (cred == null) {
            throw new DelegationException(i18n.getMessage("insecureService"));
        }
        return cred.getPrivateKey();
    }

    public static void registerDelegationListener(EndpointReferenceType epr, DelegationListener listener) throws DelegationException {
        DelegationResource resource = DelegationUtil.getDelegationResource(epr);
        resource.addRefreshListener(listener);
    }

    public static void registerDelegationListener(EndpointReferenceType epr, DelegationListener listener, Subject subject) throws DelegationException {
        DelegationResource resource = DelegationUtil.getDelegationResource(epr);
        resource.addRefreshListener(listener, subject);
    }

    public static void removeDelegationListener(EndpointReferenceType epr, String listenerId) throws DelegationException {
        DelegationResource resource = DelegationUtil.getDelegationResource(epr);
        resource.removeRefreshListener(listenerId);
    }

    public static DelegationResource getDelegationResource(EndpointReferenceType epr) throws DelegationException {
        String address = epr.getAddress().toString();
        logger.debug((Object)("Address: " + address));
        String servicePath = address.substring(address.lastIndexOf("/") + 1, address.length());
        logger.debug((Object)("Service path: " + servicePath));
        DelegationHome delegHome = null;
        String lookUp = "java:comp/env//services/" + servicePath + "/" + "/home";
        try {
            InitialContext initialContext = new InitialContext();
            delegHome = (DelegationHome)((Object)initialContext.lookup(lookUp));
        }
        catch (NamingException namingExp) {
            throw new DelegationException(i18n.getMessage("resourceHomeNotFound", new Object[]{lookUp}), namingExp);
        }
        Class keyClass = delegHome.getKeyTypeClass();
        QName keyQName = delegHome.getKeyTypeName();
        String localName = keyQName.getLocalPart();
        String ns = keyQName.getNamespaceURI();
        SimpleResourceKey key = null;
        try {
            ReferencePropertiesType refPropType = epr.getProperties();
            for (int i = 0; i < refPropType.size(); ++i) {
                MessageElement[] elem = refPropType.get_any();
                Element elem0 = elem[0].getAsDOM();
                if (!localName.equals(elem0.getLocalName()) || !ns.equals(elem0.getNamespaceURI())) continue;
                key = new SimpleResourceKey((SOAPElement)elem[i], keyClass);
                break;
            }
        }
        catch (Exception exp) {
            throw new DelegationException(i18n.getMessage("referencePropErr"), exp);
        }
        if (key == null) {
            throw new DelegationException(i18n.getMessage("invalidKey"));
        }
        logger.debug((Object)("Resource key " + key));
        DelegationResource resource = null;
        try {
            resource = (DelegationResource)delegHome.find((ResourceKey)key);
        }
        catch (ResourceException exp) {
            logger.error((Object)i18n.getMessage("unableToGetResource"), (Throwable)exp);
            throw new DelegationException(i18n.getMessage("unableToGetResource"), exp);
        }
        return resource;
    }

    public static RequestSecurityTokenType getTokenToDelegate(GlobusCredential issuingCred, X509Certificate certificate, int lifetime, boolean fullDelegation) throws DelegationException {
        return DelegationUtil.getTokenToDelegate(issuingCred.getCertificateChain(), issuingCred.getPrivateKey(), certificate.getPublicKey(), lifetime, fullDelegation);
    }

    public static RequestSecurityTokenType getTokenToDelegate(X509Certificate[] issuerCertificateChain, PrivateKey issuerKey, PublicKey publicKey, int lifetime, boolean fullDelegation) throws DelegationException {
        BouncyCastleCertProcessingFactory certFactory = BouncyCastleCertProcessingFactory.getDefault();
        X509Certificate newCert = null;
        int delegType = 2;
        if (fullDelegation) {
            delegType = 3;
        }
        try {
            newCert = certFactory.createProxyCertificate(issuerCertificateChain[0], issuerKey, publicKey, lifetime, delegType, (X509ExtensionSet)null, null);
        }
        catch (GeneralSecurityException exp) {
            logger.error((Object)i18n.getMessage("createDelegCred"), (Throwable)exp);
            throw new DelegationException(i18n.getMessage("createDelegCred"), exp);
        }
        X509Certificate[] newChain = new X509Certificate[issuerCertificateChain.length + 1];
        newChain[0] = newCert;
        System.arraycopy(issuerCertificateChain, 0, newChain, 1, issuerCertificateChain.length);
        logger.debug((Object)"New delegated chain");
        for (int i = 0; i < newChain.length; ++i) {
            logger.debug((Object)newChain[i].getSubjectDN());
        }
        PKIPathSecurity token = DelegationUtil.getPKIToken(newChain, false);
        logger.debug((Object)"New certificate chain");
        for (int i = 0; i < newChain.length; ++i) {
            logger.debug((Object)newChain[i].getSubjectDN());
        }
        MessageElement msgElem = new MessageElement(token.getElement());
        RequestSecurityTokenType requestToken = new RequestSecurityTokenType();
        requestToken.set_any(new MessageElement[]{msgElem});
        return requestToken;
    }

    public static EndpointReferenceType delegate(String delegationServiceUrl, GlobusCredential issuingCred, X509Certificate certificate, boolean fullDelegation, ClientSecurityDescriptor desc) throws DelegationException {
        return DelegationUtil.delegate(delegationServiceUrl, issuingCred, certificate, new Long(issuingCred.getTimeLeft()).intValue(), fullDelegation, desc);
    }

    public static EndpointReferenceType delegate(String delegationServiceUrl, GlobusCredential issuingCred, X509Certificate certificate, int lifetime, boolean fullDelegation, ClientSecurityDescriptor desc) throws DelegationException {
        RequestSecurityTokenType token = DelegationUtil.getTokenToDelegate(issuingCred, certificate, lifetime, fullDelegation);
        DelegationFactoryServiceLocator locator = new DelegationFactoryServiceLocator();
        EndpointReference ref = null;
        try {
            URL url = new URL(delegationServiceUrl);
            DelegationFactoryPortType delegationPort = locator.getDelegationFactoryPortTypePort(url);
            if (desc != null) {
                ((Stub)delegationPort)._setProperty("clientDescriptor", (Object)desc);
            }
            RequestSecurityTokenResponseType response = delegationPort.requestSecurityToken(token);
            MessageElement[] elem = response.get_any();
            ref = new EndpointReference(elem[0].getAsDOM());
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        return ref;
    }

    public static void refresh(GlobusCredential issuingCred, X509Certificate certToSign, int lifetime, boolean fullDelegation, ClientSecurityDescriptor desc, EndpointReferenceType epr) throws DelegationException {
        RequestSecurityTokenType requestToken = DelegationUtil.getTokenToDelegate(issuingCred, certToSign, lifetime, fullDelegation);
        DelegationPortType delegationPort = null;
        try {
            DelegationServiceAddressingLocator locator = new DelegationServiceAddressingLocator();
            delegationPort = locator.getDelegationPortTypePort(epr);
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        ((Stub)delegationPort)._setProperty("clientDescriptor", (Object)desc);
        try {
            delegationPort.refresh(requestToken);
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
    }

    public static X509Certificate[] getCertificateChainRP(EndpointReferenceType epr, ClientSecurityDescriptor desc) throws DelegationException {
        QName certChainRp = new QName(DelegationConstants.NS, "CertificateChain");
        return DelegationUtil.getCertificateChainRP(epr, certChainRp, class$org$globus$delegationService$CertType == null ? (class$org$globus$delegationService$CertType = DelegationUtil.class$("org.globus.delegationService.CertType")) : class$org$globus$delegationService$CertType, desc);
    }

    public static X509Certificate[] getCertificateChainRP(EndpointReferenceType epr, QName qName, Class rpClass, ClientSecurityDescriptor desc) throws DelegationException {
        DelegationFactoryPortType delegationPort = null;
        try {
            DelegationFactoryServiceAddressingLocator locator = new DelegationFactoryServiceAddressingLocator();
            delegationPort = locator.getDelegationFactoryPortTypePort(epr);
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        if (desc != null) {
            ((Stub)delegationPort)._setProperty("clientDescriptor", (Object)desc);
        }
        GetResourcePropertyResponse response = null;
        try {
            response = delegationPort.getResourceProperty(qName);
        }
        catch (RemoteException exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        PKIPathSecurity token = null;
        try {
            MessageElement[] elem = response.get_any();
            AnyContentType certType = (AnyContentType)ObjectDeserializer.toObject((SOAPElement)elem[0], (Class)rpClass);
            elem = certType.get_any();
            token = new PKIPathSecurity(WSSConfig.getDefaultWSConfig(), elem[0].getAsDOM());
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        X509Certificate[] certChain = null;
        try {
            certChain = token.getX509Certificates(false, (Crypto)new ContextCrypto());
        }
        catch (IOException exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        GlobusCredential credential = new GlobusCredential(null, certChain);
        try {
            credential.verify();
        }
        catch (Exception exp) {
            throw new DelegationException(exp);
        }
        return certChain;
    }

    private static GlobusCredential getServiceCredential(String servicePath, boolean useDefault) throws DelegationException {
        SecurityManager manager = SecurityManager.getManager();
        Subject subject = null;
        try {
            subject = manager.getServiceSubject(servicePath);
        }
        catch (SecurityException exp) {
            throw new DelegationException(exp);
        }
        if (subject == null) {
            throw new DelegationException(i18n.getMessage("insecureService"));
        }
        GlobusCredential cred = null;
        Iterator<Object> privateCred = subject.getPrivateCredentials().iterator();
        while (privateCred.hasNext()) {
            Object object = privateCred.next();
            if (!(object instanceof GlobusGSSCredentialImpl)) continue;
            cred = ((GlobusGSSCredentialImpl)object).getGlobusCredential();
            break;
        }
        if (useDefault && cred == null) {
            try {
                cred = GlobusCredential.getDefaultCredential();
            }
            catch (GlobusCredentialException exp) {
                throw new DelegationException(exp);
            }
        }
        return cred;
    }

    private static PKIPathSecurity getPKIToken(X509Certificate[] certChain, boolean reverse) throws DelegationException {
        PKIPathSecurity token = null;
        try {
            Document doc = XmlUtils.newDocument();
            token = new PKIPathSecurity(WSSConfig.getDefaultWSConfig(), doc);
            token.setX509Certificates(certChain, reverse, (Crypto)new ContextCrypto());
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new DelegationException(exp);
        }
        return token;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

