/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.client;

import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.client.BaseClient;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.xml.sax.InputSource;

public class Refresh
extends BaseClient {
    static String optionString = " -help/--help prints help message\n -c credential as proxy file, if not default credential is used\n -l lifetime in seconds, defaults to 12 hours\n -d if set to true full delegation is done, any other value \n    liminited delegation is done. If option is not specified,\n     defaults to full delegation \n -a authz, defaults to Host Authorization\n -e eprFileName file that contains delegation credential EPR,\n     defaults to delegatedCredEPR\n -m security mechanism. 'msg' for secure message or 'conv' for \n    secure conversation and 'trans' for transport. Defaults to\n    secure transport.\n -n protection type, 'sig' signature and 'enc' encryption, \n    defaults to signature";
    static String eprFileName = "delegatedCredEPR";
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;

    public static void main(String[] args) throws Exception {
        cmd = args;
        Refresh.parseArgs();
        System.out.println("Arguments: " + lifetime + " " + fullDelegation + " " + eprFileName);
        EndpointReferenceType delegatedCredEPR = Refresh.getEndpoint();
        System.out.println("Delegated epr " + delegatedCredEPR);
        String host = delegatedCredEPR.getAddress().getHost();
        int port = delegatedCredEPR.getAddress().getPort();
        String scheme = delegatedCredEPR.getAddress().getScheme();
        String factoryUrl = scheme + "://" + host + ":" + port + "/wsrf/services/" + "DelegationFactoryService";
        X509Certificate certToSign = Refresh.getCertificateToSign(factoryUrl);
        Refresh.refresh(certToSign, delegatedCredEPR);
        System.out.println("Refresh done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EndpointReferenceType getEndpoint() throws Exception {
        EndpointReferenceType epr = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(eprFileName);
            InputSource in = new InputSource(is);
            epr = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)in, (Class)(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = Refresh.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType));
            Object var4_3 = null;
            if (is == null) return epr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return epr;
        }
        catch (Exception e) {}
        return epr;
    }

    private static void parseArgs() {
        for (int i = 0; i < cmd.length; ++i) {
            if (cmd[i].startsWith("-help") || cmd[i].startsWith("--help")) {
                System.out.println(optionString);
                System.exit(0);
                continue;
            }
            if (cmd[i].equals("-c")) {
                proxyFile = Refresh.getValue(i);
                ++i;
                continue;
            }
            if (cmd[i].equals("-l")) {
                String lifetimeStr = Refresh.getValue(i);
                lifetime = Integer.parseInt(lifetimeStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-d")) {
                String delegStr = Refresh.getValue(i);
                fullDelegation = new Boolean(delegStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-e")) {
                eprFileName = Refresh.getValue(i);
                ++i;
                continue;
            }
            if (cmd[i].equals("-a")) {
                String authzStr = Refresh.getValue(i);
                authzVal = AuthUtil.getClientAuthorization((String)authzStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-m")) {
                String secType = Refresh.getValue(i);
                if (secType.equals("msg")) {
                    authType = "org.globus.security.secMsg.msg.type";
                } else if (secType.equals("conv")) {
                    authType = "org.globus.security.secConv.msg.type";
                } else if (secType.equals("trans")) {
                    authType = "org.globus.security.transport.type";
                } else {
                    System.err.println("Invalid entry for -m: " + secType);
                    System.err.println("-m should be 'msg', 'conv' or 'trans'");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (cmd[i].equals("-n")) {
                String prot = Refresh.getValue(i);
                if (prot.equals("sig")) {
                    authVal = GSIConstants.SIGNATURE;
                } else if (prot.equals("enc")) {
                    authVal = GSIConstants.ENCRYPTION;
                } else {
                    System.err.println("Invalid value for -n: " + prot);
                    System.err.println("-n should be 'sig' or 'enc'");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            System.err.println("Invalid option " + cmd[i]);
            System.err.println("Use -help or --help to look at options");
            System.exit(-1);
        }
    }

    private static void refresh(X509Certificate certToSign, EndpointReferenceType delegatedCredEpr) throws Exception {
        ClientSecurityDescriptor desc = Refresh.getClientSecDesc();
        GlobusCredential credential = null;
        credential = proxyFile == null ? GlobusCredential.getDefaultCredential() : new GlobusCredential(proxyFile);
        DelegationUtil.refresh((GlobusCredential)credential, (X509Certificate)certToSign, (int)lifetime, (boolean)fullDelegation, (ClientSecurityDescriptor)desc, (EndpointReferenceType)delegatedCredEpr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

