/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.client;

import java.io.FileWriter;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.delegation.DelegationUtil;
import org.globus.delegation.client.BaseClient;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.impl.security.util.AuthUtil;

public class Delegate
extends BaseClient {
    static String optionString = "Delegate [options] fileName\n where options can be\n -help/--help Displays usage\n -h host, defaults to localhost. \n -p port, defaults to 8443 if secure transport is used, else \n    defaults to 8080\n -c credential as proxy file, if not default credential is used\n -l lifetime in seconds, defaults to 12 hours\n -d if set to true full delegation is done, any other value \n    limiited delegation is done. If option is not specified, \n    defaults to full delegation \n -m security mechanism. 'msg' for secure message or 'conv' for \n    secure conversation and 'trans' for transport. Defaults to\n    secure transport.\n -n protection type, 'sig' signature and 'enc' encryption, \n    defaults to signature\n -a authz, defaults to Host Authorization (none, host, self or dn\n    for identity authz)\n and fileName is  file to write EPR of delegated credential";
    static String host = "127.0.0.1";
    static String port = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println(optionString);
            System.exit(0);
        }
        cmd = args;
        Delegate.parseArgs();
        if (port == null) {
            port = authType.equals("org.globus.security.transport.type") ? "8443" : "8080";
        }
        String protocol = "http";
        if (authType.equals("org.globus.security.transport.type")) {
            protocol = "https";
        }
        String factoryUrl = protocol + "://" + host + ":" + port + "/wsrf/services/" + "DelegationFactoryService";
        X509Certificate certToSign = Delegate.getCertificateToSign(factoryUrl);
        EndpointReferenceType delegatedCredEPR = Delegate.delegate(factoryUrl, certToSign);
        System.out.println("Delegated credential EPR:\n" + delegatedCredEPR);
        if (outFileName != null) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(outFileName);
                QName qName = new QName("", "DelegatedEPR");
                writer.write(ObjectSerializer.toString((Object)delegatedCredEPR, (QName)qName));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private static void parseArgs() {
        boolean done = false;
        int i = 0;
        for (i = 0; i < cmd.length; ++i) {
            if (done) {
                System.out.println("Invalid parameter, ignored " + cmd[i]);
                continue;
            }
            if (cmd[i].equals("-h")) {
                host = Delegate.getValue(i);
                ++i;
                continue;
            }
            if (cmd[i].equals("-p")) {
                port = Delegate.getValue(i);
                ++i;
                continue;
            }
            if (cmd[i].equals("-c")) {
                proxyFile = Delegate.getValue(i);
                ++i;
                continue;
            }
            if (cmd[i].equals("-l")) {
                String lifetimeStr = Delegate.getValue(i);
                lifetime = Integer.parseInt(lifetimeStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-d")) {
                String delegStr = Delegate.getValue(i);
                fullDelegation = new Boolean(delegStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-a")) {
                String authzStr = Delegate.getValue(i);
                authzVal = AuthUtil.getClientAuthorization((String)authzStr);
                ++i;
                continue;
            }
            if (cmd[i].equals("-m")) {
                String secType = Delegate.getValue(i);
                if (secType.equals("msg")) {
                    authType = "org.globus.security.secMsg.msg.type";
                } else if (secType.equals("conv")) {
                    authType = "org.globus.security.secConv.msg.type";
                } else if (secType.equals("trans")) {
                    authType = "org.globus.security.transport.type";
                } else {
                    System.err.println("Invalid entry for -m: " + secType);
                    System.err.println("-m should be 'msg', 'conv' or 'trans'");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (cmd[i].equals("-n")) {
                String prot = Delegate.getValue(i);
                if (prot.equals("sig")) {
                    authVal = GSIConstants.SIGNATURE;
                } else if (prot.equals("enc")) {
                    authVal = GSIConstants.ENCRYPTION;
                } else {
                    System.err.println("Invalid value for -n: " + prot);
                    System.err.println("-n should be 'sig' or 'enc'");
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (cmd[i].equals("-help") || cmd[i].equals("--help")) {
                System.out.println(optionString);
                System.exit(0);
                continue;
            }
            outFileName = cmd[i];
            System.out.println("EPR will be written to: " + outFileName);
            done = true;
        }
    }

    private static EndpointReferenceType delegate(String factoryUrl, X509Certificate certToSign) throws Exception {
        ClientSecurityDescriptor desc = Delegate.getClientSecDesc();
        GlobusCredential credential = null;
        credential = proxyFile == null ? GlobusCredential.getDefaultCredential() : new GlobusCredential(proxyFile);
        return DelegationUtil.delegate((String)factoryUrl, (GlobusCredential)credential, (X509Certificate)certToSign, (int)lifetime, (boolean)fullDelegation, (ClientSecurityDescriptor)desc);
    }
}

