/*
 * Decompiled with CFR 0.152.
 */
package org.globus.delegation.client;

import java.security.cert.X509Certificate;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.axis.util.Util;
import org.globus.delegation.DelegationUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.utils.AddressingUtils;

public class BaseClient {
    protected static String proxyFile = null;
    protected static int lifetime = 43200;
    protected static Boolean fullDelegation = Boolean.TRUE;
    protected static Authorization authzVal = HostAuthorization.getInstance();
    protected static String[] cmd;
    protected static String outFileName;
    protected static Object authType;
    protected static Object authVal;

    protected static X509Certificate getCertificateToSign(String factoryUrl) throws Exception {
        EndpointReferenceType delegEpr = AddressingUtils.createEndpointReference((String)factoryUrl, null);
        X509Certificate[] certsToDelegateOn = DelegationUtil.getCertificateChainRP((EndpointReferenceType)delegEpr, (ClientSecurityDescriptor)BaseClient.getClientSecDesc());
        return certsToDelegateOn[0];
    }

    protected static GlobusCredential getCredential() throws Exception {
        GlobusCredential credential = null;
        credential = proxyFile == null ? GlobusCredential.getDefaultCredential() : new GlobusCredential(proxyFile);
        return credential;
    }

    protected static String getValue(int i) {
        if (i + 1 >= cmd.length) {
            System.err.println(cmd[i] + " needs a argument");
            System.exit(-1);
        }
        return cmd[i + 1];
    }

    protected static ClientSecurityDescriptor getClientSecDesc() {
        ClientSecurityDescriptor desc = new ClientSecurityDescriptor();
        if (authType.equals("org.globus.security.secMsg.msg.type")) {
            desc.setGSISecureMsg((Integer)authVal);
        } else if (authType.equals("org.globus.security.secConv.msg.type")) {
            desc.setGSISecureConv((Integer)authVal);
        } else if (authType.equals("org.globus.security.transport.type")) {
            desc.setGSITransport((Integer)authVal);
            Util.registerTransport();
        }
        desc.setAuthz(authzVal);
        return desc;
    }

    static {
        outFileName = null;
        authType = "org.globus.security.transport.type";
        authVal = GSIConstants.SIGNATURE;
    }
}

