/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected boolean _defaultReadOnly = false;
    protected boolean _defaultAutoCommit = true;
    protected AbandonedConfig _config = null;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) throws Exception {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PoolableConnection) {
            try {
                ((PoolableConnection)obj).reallyClose();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean validateObject(Object obj) {
        block23: {
            block19: {
                block22: {
                    block18: {
                        if (obj instanceof Connection == false) return false;
                        query = this._validationQuery;
                        conn = (Connection)obj;
                        try {
                            if (conn.isClosed()) {
                                return false;
                            }
                        }
                        catch (SQLException e) {
                            return false;
                        }
                        if (null == query) return true;
                        stmt = null;
                        rset = null;
                        try {
                            try {
                                stmt = conn.createStatement();
                                rset = stmt.executeQuery(query);
                                if (rset.next()) {
                                    var6_7 = true;
                                    var9_10 = null;
                                    break block18;
                                }
                                var6_8 = false;
                                break block19;
                            }
                            catch (Exception e) {
                                var7_18 = false;
                                var9_12 = null;
                                try {
                                    rset.close();
                                }
                                catch (Exception t) {
                                    // empty catch block
                                }
                                try {
                                    stmt.close();
                                    return var7_18;
                                }
                                catch (Exception t) {
                                    // empty catch block
                                }
                                return var7_18;
                            }
                        }
                        catch (Throwable var8_19) {
                            block21: {
                                var9_13 = null;
                                ** try [egrp 3[TRYBLOCK] [6 : 113->123)] { 
lbl45:
                                // 1 sources

                                rset.close();
                                break block21;
lbl47:
                                // 1 sources

                                catch (Exception t) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [7 : 125->135)] { 
lbl51:
                            // 1 sources

                            stmt.close();
                            throw var8_19;
lbl53:
                            // 1 sources

                            catch (Exception t) {
                                // empty catch block
                            }
                            throw var8_19;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 113->123)] { 
lbl58:
                    // 1 sources

                    rset.close();
                    break block22;
lbl60:
                    // 1 sources

                    catch (Exception t) {
                        // empty catch block
                    }
                }
                ** try [egrp 4[TRYBLOCK] [7 : 125->135)] { 
lbl64:
                // 1 sources

                stmt.close();
                return var6_7;
lbl66:
                // 1 sources

                catch (Exception t) {
                    // empty catch block
                }
                return var6_7;
            }
            var9_11 = null;
            ** try [egrp 3[TRYBLOCK] [6 : 113->123)] { 
lbl72:
            // 1 sources

            rset.close();
            break block23;
lbl74:
            // 1 sources

            catch (Exception t) {
                // empty catch block
            }
        }
        ** try [egrp 4[TRYBLOCK] [7 : 125->135)] { 
lbl78:
        // 1 sources

        stmt.close();
        return var6_8;
lbl80:
        // 1 sources

        catch (Exception t) {
            // empty catch block
        }
        return var6_8;
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public void activateObject(Object obj) throws Exception {
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).activate();
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            try {
                conn.setAutoCommit(this._defaultAutoCommit);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                conn.setReadOnly(this._defaultReadOnly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

