/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected boolean defaultAutoCommit = true;
    protected boolean defaultReadOnly = false;
    protected String driverClassName = null;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected long maxWait = -1L;
    protected String password = null;
    protected String url = null;
    protected String username = null;
    protected String validationQuery = null;
    protected GenericObjectPool connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.createDataSource().getConnection(username, password);
    }

    public int getLoginTimeout() throws SQLException {
        return this.createDataSource().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.createDataSource().setLoginTimeout(loginTimeout);
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    public boolean getRemoveAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandoned();
        }
        return false;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandoned(removeAbandoned);
    }

    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(logAbandoned);
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
    }

    public void close() throws SQLException {
        GenericObjectPool oldpool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            oldpool.close();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Class<?> driverClass = null;
        try {
            driverClass = Class.forName(this.driverClassName);
        }
        catch (Throwable t) {
            String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLException(message);
        }
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(this.url);
        }
        catch (Throwable t) {
            String message = "Cannot create JDBC driver of class '" + this.driverClassName + "' for connect URL '" + this.url + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLException(message);
        }
        this.connectionPool = new AbandonedObjectPool(null, this.abandonedConfig);
        this.connectionPool.setMaxActive(this.maxActive);
        this.connectionPool.setMaxIdle(this.maxIdle);
        this.connectionPool.setMaxWait(this.maxWait);
        if (this.validationQuery != null) {
            this.connectionPool.setTestOnBorrow(true);
        }
        if (this.username != null) {
            this.connectionProperties.put("user", this.username);
        } else {
            System.out.println("DBCP DataSource configured without a 'username'");
        }
        if (this.password != null) {
            this.connectionProperties.put("password", this.password);
        } else {
            System.out.println("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, (ObjectPool)this.connectionPool, null, this.validationQuery, this.defaultReadOnly, this.defaultAutoCommit, this.abandonedConfig);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        this.dataSource.setLogWriter(this.logWriter);
        return this.dataSource;
    }
}

