/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.RecurringDurationBase;
import org.exolab.castor.types.TimeDuration;
import org.exolab.castor.xml.ValidationException;

public class RecurringDuration
extends RecurringDurationBase {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final boolean DEBUG = false;
    private short _century = 0;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private static final short OMITED = Short.parseShort("-1");

    public RecurringDuration() {
    }

    public RecurringDuration(TimeDuration duration, TimeDuration period) {
        super(duration, period);
    }

    public RecurringDuration(String duration, String period) {
        super(duration, period);
    }

    public RecurringDuration(String duration, String period, short[] values) throws OperationNotSupportedException {
        this(duration, period);
        if (values.length != 10) {
            throw new IllegalArgumentException("Wrong numbers of values");
        }
        this.setValues(values);
    }

    public void setCentury(short century) {
        String err = "";
        if (century < -1) {
            err = "century : " + century + " must not be a negative value.";
            throw new IllegalArgumentException(err);
        }
        this._century = century;
    }

    public void setYear(short year) throws OperationNotSupportedException {
        String err = "";
        if (year < -1) {
            err = "year : " + year + " must not be a negative value.";
            throw new IllegalArgumentException(err);
        }
        if (year == -1 && this._century != -1) {
            err = "year can not be omitted if century is not omitted.";
            throw new IllegalArgumentException(err);
        }
        if (year == 0 && this._century == 0) {
            err = "0000 is not an allowed year";
            throw new IllegalArgumentException(err);
        }
        this._year = year;
    }

    public void setMonth(short month) throws OperationNotSupportedException {
        String err = "";
        if (month == -1) {
            if (this._century != -1) {
                err = "month cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException(err);
            }
        } else {
            if (month < 1) {
                err = "month : " + month + " is not a correct value." + "\n 1<month<12";
                throw new IllegalArgumentException(err);
            }
            if (month > 12) {
                err = "month : " + month + " is not a correct value.";
                err = err + "\n 1<month<12";
                throw new IllegalArgumentException(err);
            }
        }
        this._month = month;
    }

    public void setDay(short day) throws OperationNotSupportedException {
        String err = "";
        if (day == -1) {
            if (this._month != -1) {
                err = "day cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException(err);
            }
        } else if (day < 1) {
            err = "day : " + day + " is not a correct value.";
            err = err + "\n 1<day";
            throw new IllegalArgumentException(err);
        }
        if (this._month == 2) {
            if (this.isLeap()) {
                if (day > 29) {
                    err = "day : " + day + " is not a correct value.";
                    err = err + "\n day<30 (leap year and month is february)";
                    throw new IllegalArgumentException(err);
                }
            } else if (day > 28) {
                err = "day : " + day + " is not a correct value.";
                err = err + "\n day<30 (not a leap year and month is february)";
                throw new IllegalArgumentException(err);
            }
        } else if (this._month == 4 || this._month == 6 || this._month == 9 || this._month == 11) {
            if (day > 30) {
                err = "day : " + day + " is not a correct value.";
                err = err + "\n day<31 ";
                throw new IllegalArgumentException(err);
            }
        } else if (day > 31) {
            err = "day : " + day + " is not a correct value.";
            err = err + "\n day<=31 ";
            throw new IllegalArgumentException(err);
        }
        this._day = day;
    }

    public boolean isLeap() {
        int temp = this._century * 100 + this._year;
        boolean result = temp % 4 == 0 && temp % 100 != 0;
        result = result || temp % 400 == 0;
        return result;
    }

    public void setValues(short[] values) throws OperationNotSupportedException {
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
        this.setDay(values[3]);
        this.setHour(values[4]);
        this.setMinute(values[5]);
        this.setSecond(values[6], values[7]);
        this.setZone(values[8], values[9]);
    }

    public short getCentury() {
        return this._century;
    }

    public short getYear() {
        return this._year;
    }

    public short getMonth() {
        return this._month;
    }

    public short getDay() {
        return this._day;
    }

    public short[] getValues() {
        short[] result = null;
        result = new short[10];
        result[0] = this.getCentury();
        result[1] = this.getYear();
        result[2] = this.getMonth();
        result[3] = this.getDay();
        result[4] = this.getHour();
        result[5] = this.getMinute();
        result[6] = this.getSeconds();
        result[7] = this.getMilli();
        result[8] = this.getZoneHour();
        result[5] = this.getZoneMinute();
        return result;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
        }
        df.setTimeZone(timeZone);
        date = df.parse(this.toPrivateString());
        return date;
    }

    public String toString() {
        return this.toPrivateString();
    }

    private final String toPrivateString() {
        StringBuffer result = new StringBuffer();
        StringBuffer timeZone = null;
        if (this.getCentury() == -1) {
            result.append('-');
        } else {
            if (this.getCentury() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getCentury());
            if (this.getYear() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getYear());
        }
        result.append('-');
        if (this.getMonth() == -1) {
            result.append('-');
        } else {
            if (this.getMonth() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getMonth());
        }
        result.append('-');
        if (this.getDay() == -1) {
            result.append('-');
        } else {
            if (this.getDay() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getDay());
        }
        result.append("T");
        if (this.getHour() == -1) {
            result.append('-');
        } else {
            if (this.getHour() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getHour());
        }
        result.append(':');
        if (this.getMinute() == -1) {
            result.append('-');
        } else {
            if (this.getMinute() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getMinute());
        }
        result.append(':');
        if (this.getSeconds() == -1) {
            result.append('-');
        } else {
            if (this.getSeconds() / 10 == 0) {
                result.append(0);
            }
            result.append(this.getSeconds());
        }
        result.append('.');
        result.append(this.getMilli());
        if (this.isNegative()) {
            result.append('-');
        }
        if (!this.isUTC()) {
            timeZone = new StringBuffer();
            if (this.getZoneHour() / 10 == 0) {
                timeZone.append(0);
            }
            timeZone.append(this.getZoneHour());
            timeZone.append(':');
            if (this.getZoneMinute() / 10 == 0) {
                timeZone.append(0);
            }
            timeZone.append(this.getZoneMinute());
            if (this.isZoneNegative()) {
                timeZone.insert(0, '-');
            } else {
                timeZone.insert(0, '+');
            }
            result.append(timeZone.toString());
        }
        if (this.isNegative()) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return RecurringDuration.parseRecurringDuration(str);
    }

    public static RecurringDuration parseRecurringDuration(String str) throws ParseException {
        String zoneStr;
        boolean timeZone;
        RecurringDuration result = new RecurringDuration();
        if (str.endsWith("Z")) {
            str = str.substring(0, str.indexOf("Z"));
        }
        if (str.startsWith("-") && !str.startsWith("--")) {
            result.setNegative();
        }
        boolean bl = timeZone = ((zoneStr = str.substring(str.length() - 6, str.length())).lastIndexOf("-") != -1 || zoneStr.lastIndexOf("+") != -1) && zoneStr.lastIndexOf(":") != -1;
        if (!timeZone) {
            zoneStr = null;
        } else {
            int index = str.lastIndexOf("+") != -1 ? str.lastIndexOf("+") : str.lastIndexOf("-");
            str = str.substring(0, index);
        }
        if (str.indexOf(84) == -1) {
            throw new ParseException("The 'T' element is required", 0);
        }
        String date = str.substring(0, str.indexOf("T"));
        String time = str.substring(str.indexOf("T"));
        StringTokenizer token = new StringTokenizer(date, "-");
        if (token.countTokens() > 3) {
            throw new ParseException(str + ": Bad date format", 0);
        }
        try {
            String temp;
            boolean process = false;
            if (token.countTokens() == 3) {
                temp = token.nextToken();
                if (temp.length() != 4) {
                    throw new ParseException(str + ":Bad year format", 1);
                }
                result.setCentury(Short.parseShort(temp.substring(0, 2)));
                result.setYear(Short.parseShort(temp.substring(2, 4)));
                process = true;
            }
            if (!process) {
                result.setCentury(OMITED);
            }
            if (token.countTokens() == 2) {
                temp = token.nextToken();
                if (temp.length() != 2) {
                    throw new ParseException(str + ": Bad month format", 5);
                }
                result.setMonth(Short.parseShort(temp));
                process = true;
            }
            if (!process) {
                result.setMonth(OMITED);
            }
            if (token.countTokens() == 1) {
                temp = token.nextToken();
                if (temp.length() != 2) {
                    throw new ParseException(str + ":Bad day format", 8);
                }
                result.setDay(Short.parseShort(temp));
                process = true;
            }
            if (!process) {
                result.setDay(OMITED);
            }
            token = new StringTokenizer(time, ":");
            process = false;
            if (token.countTokens() > 5) {
                throw new ParseException(str + ": Bad time format", 11);
            }
            if (token.countTokens() == 3) {
                temp = token.nextToken();
                if ((temp = temp.substring(temp.indexOf("T") + 1)).length() != 2) {
                    throw new ParseException(str + ": Bad hour format", 11);
                }
                result.setHour(Short.parseShort(temp));
                process = true;
            }
            if (!process) {
                if (result.getDay() == OMITED) {
                    result.setHour(OMITED);
                } else {
                    throw new IllegalArgumentException("hour cannot be omitted");
                }
            }
            if (token.countTokens() == 2) {
                temp = token.nextToken();
                if (temp.length() != 2) {
                    throw new ParseException(str + ": Bad minute format", 14);
                }
                result.setMinute(Short.parseShort(temp));
                process = true;
            }
            if (!process) {
                if (result.getDay() == OMITED) {
                    result.setHour(OMITED);
                    result.setMinute(OMITED);
                } else {
                    throw new IllegalArgumentException("hour cannot be omitted");
                }
            }
            if (token.countTokens() == 1) {
                temp = token.nextToken();
                String milsecond = "0";
                if (temp.indexOf(".") != -1) {
                    milsecond = temp.substring(temp.indexOf(".") + 1);
                    temp = temp.substring(0, temp.indexOf("."));
                }
                if (temp.length() != 2) {
                    throw new ParseException(str + ": Bad second format", 17);
                }
                result.setSecond(Short.parseShort(temp.substring(0, 2)), Short.parseShort(milsecond));
                process = true;
            }
            if (!process) {
                if (result.getDay() == OMITED) {
                    result.setHour(OMITED);
                    result.setMinute(OMITED);
                    result.setSecond(OMITED, OMITED);
                } else {
                    throw new IllegalArgumentException("hour cannot be omitted");
                }
            }
            if (timeZone) {
                if (zoneStr.startsWith("-")) {
                    result.setZoneNegative();
                }
                if (zoneStr.length() != 6) {
                    throw new ParseException(str + ": Bad time zone format", 20);
                }
                result.setZone(Short.parseShort(zoneStr.substring(1, 3)), Short.parseShort(zoneStr.substring(4, 6)));
            } else {
                result.isUTC();
            }
            temp = null;
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof RecurringDuration) {
            try {
                return this.equal((RecurringDuration)object);
            }
            catch (ValidationException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean equal(RecurringDuration reccD) throws ValidationException {
        boolean result = false;
        if (reccD == null) {
            return false;
        }
        if (!this.getPeriod().equals(reccD.getPeriod()) || !this.getDuration().equals(reccD.getDuration())) {
            String err = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(err);
        }
        result = this.getCentury() == reccD.getCentury();
        result = result && this.getYear() == reccD.getYear();
        result = result && this.getMonth() == reccD.getMonth();
        result = result && this.getDay() == reccD.getDay();
        result = result && this.getHour() == reccD.getHour();
        result = result && this.getMinute() == reccD.getMinute();
        result = result && this.getSeconds() == reccD.getSeconds();
        result = result && this.getMilli() == reccD.getMilli();
        boolean bl = result = result && this.isNegative() == this.isNegative();
        if (!reccD.isUTC()) {
            result = result && !this.isUTC();
            result = result && this.getZoneHour() == reccD.getZoneHour();
            result = result && this.getZoneMinute() == reccD.getZoneMinute();
        }
        return result;
    }

    public boolean isGreater(RecurringDuration reccD) throws ValidationException {
        boolean result = false;
        if (!this.getPeriod().equals(reccD.getPeriod()) || !this.getDuration().equals(reccD.getDuration())) {
            String err = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(err);
        }
        short[] val_this = this.getValues();
        short[] val_reccD = reccD.getValues();
        for (int i = 0; !result && i < val_this.length - 1; ++i) {
            boolean bl = result = val_this[i] > val_reccD[i];
            if (val_this[i] >= val_reccD[i]) continue;
            return false;
        }
        return result;
    }
}

