/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.TxSynchronizable;

public class RelationCollection
implements Collection,
Lazy,
TxSynchronizable {
    private TransactionContext _tx;
    private LockEngine _engine;
    private ClassMolder _molder;
    private AccessMode _accessMode;
    private OID _oid;
    private ArrayList _ids;
    private ArrayList _deleted;
    private ArrayList _added;
    private Map _loaded;
    private int _changecount;
    private int _size;

    public RelationCollection(TransactionContext tx, OID enclosing, LockEngine engine, ClassMolder molder, AccessMode amode, ArrayList ids) {
        this._tx = tx;
        this._oid = enclosing;
        this._molder = molder;
        this._engine = engine;
        this._accessMode = amode;
        if (ids == null) {
            ids = new ArrayList();
        }
        this._ids = ids;
        this._size = this._ids.size();
        this._deleted = new ArrayList();
        this._added = new ArrayList();
        this._loaded = new HashMap();
    }

    public boolean add(Object o) {
        Object id = this._molder.getIdentity(this._tx, o);
        if (this._ids.contains(id)) {
            if (this._deleted.contains(id)) {
                this._deleted.remove(id);
                this._loaded.put(id, o);
                ++this._changecount;
                ++this._size;
                return true;
            }
            return this._loaded.put(id, o) != o;
        }
        if (this._deleted.contains(id)) {
            throw new RuntimeException("Illegal Internal State.");
        }
        if (this._added.add(id)) {
            this._loaded.put(id, o);
            ++this._changecount;
            ++this._size;
            return true;
        }
        return this._loaded.put(id, o) != o;
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator a = c.iterator();
        while (a.hasNext()) {
            if (!this.add(a.next())) continue;
            changed = true;
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    public void clear() {
        Iterator itor = this.iterator();
        while (itor.hasNext()) {
            itor.next();
            itor.remove();
        }
    }

    public boolean contains(Object o) {
        Object ids = this._molder.getIdentity(this._tx, o);
        if (this._added.contains(ids)) {
            return true;
        }
        return this._ids.contains(ids) && !this._deleted.contains(ids);
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new IteratorImp(this);
    }

    public boolean remove(Object o) {
        Object id = this._molder.getIdentity(this._tx, o);
        boolean changed = false;
        if (this._deleted.contains(id)) {
            return false;
        }
        if (this._added.contains(id)) {
            this._added.remove(id);
            ++this._changecount;
            --this._size;
            return true;
        }
        if (this._ids.contains(id)) {
            this._loaded.put(id, o);
            this._deleted.add(id);
            ++this._changecount;
            --this._size;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        Iterator org = this.iterator();
        while (org.hasNext()) {
            Object o = org.next();
            if (c.contains(o)) continue;
            changed = true;
            org.remove();
        }
        if (changed) {
            ++this._changecount;
        }
        return changed;
    }

    public int size() {
        return this._size;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator itor = this.iterator();
        int count = 0;
        while (itor.hasNext()) {
            result[count++] = itor.next();
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        int size = this.size();
        Object[] result = size <= a.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator itor = this.iterator();
        int count = 0;
        while (itor.hasNext()) {
            result[count++] = itor.next();
        }
        while (count < result.length) {
            result[count++] = null;
        }
        return result;
    }

    public ArrayList getIdentitiesList() {
        ArrayList result = new ArrayList();
        result.addAll(this._ids);
        result.addAll(this._added);
        result.removeAll(this._deleted);
        return result;
    }

    public Object find(Object ids) {
        return this._loaded.get(ids);
    }

    public ArrayList getDeleted() {
        return (ArrayList)this._deleted.clone();
    }

    public ArrayList getAdded() {
        return (ArrayList)this._added.clone();
    }

    public void committed(TransactionContext tx) {
        if (tx == this._tx) {
            this._added = new ArrayList();
            this._deleted = new ArrayList();
            this._changecount = 0;
            tx.removeTxSynchronizable(this);
        }
    }

    public void rolledback(TransactionContext tx) {
        this.committed(tx);
    }

    private class IteratorImp
    implements Iterator {
        private int changestamp;
        private int cursor;
        private int iterationsize;
        private RelationCollection parent;

        private IteratorImp(RelationCollection rc) {
            this.parent = rc;
            this.changestamp = rc._changecount;
            this.iterationsize = this.parent._added.size() + this.parent._ids.size();
        }

        public boolean hasNext() {
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (this.cursor >= RelationCollection.this._added.size()) {
                while (this.cursor < this.iterationsize && this.isSkipped(RelationCollection.this._ids.get(this.cursor - RelationCollection.this._added.size()))) {
                    ++this.cursor;
                }
            }
            return this.cursor < this.iterationsize;
        }

        public Object next() {
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Read after the end of iterator!");
            }
            if (this.cursor < RelationCollection.this._added.size()) {
                Object id = RelationCollection.this._added.get(this.cursor++);
                Object o = RelationCollection.this._loaded.get(id);
                if (o != null) {
                    return o;
                }
                return this.lazyLoad(id);
            }
            Object id = RelationCollection.this._ids.get(this.cursor++ - RelationCollection.this._added.size());
            Object o = RelationCollection.this._loaded.get(id);
            if (o != null) {
                return o;
            }
            return this.lazyLoad(id);
        }

        private boolean isSkipped(Object id) {
            if (RelationCollection.this._deleted.contains(id)) {
                return true;
            }
            OID oid = new OID(this.parent._engine, this.parent._molder, id);
            return this.parent._tx.isDeletedByOID(oid);
        }

        private Object lazyLoad(Object ids) {
            if (!RelationCollection.this._tx.isOpen()) {
                throw new RuntimeException("Transaction is closed!");
            }
            try {
                ProposedObject proposedValue = new ProposedObject();
                Object o = this.parent._tx.load(this.parent._engine, this.parent._molder, ids, proposedValue, null);
                this.parent._loaded.put(ids, o);
                return o;
            }
            catch (LockNotGrantedException e) {
                throw new RuntimeException("Lock Not Granted for lazy loaded object\n" + e);
            }
            catch (PersistenceException e) {
                throw new RuntimeException("PersistenceException for lazy loaded object\n" + e);
            }
        }

        public void remove() {
            if (this.cursor <= 0) {
                throw new IllegalStateException("Method next() must be called before remove!");
            }
            if (this.changestamp != this.parent._changecount) {
                throw new ConcurrentModificationException("Concurrent Modification is not allowed!");
            }
            --this.cursor;
            if (this.cursor < RelationCollection.this._added.size()) {
                this.parent._added.remove(this.cursor);
                this.parent._size--;
                --this.iterationsize;
                this.parent._changecount++;
                this.changestamp = this.parent._changecount;
            } else {
                Object id = RelationCollection.this._ids.get(this.cursor);
                while (RelationCollection.this._deleted.contains(id)) {
                    id = RelationCollection.this._ids.get(this.cursor--);
                }
                if (this.cursor < RelationCollection.this._added.size()) {
                    this.parent._added.remove(id);
                    this.parent._size--;
                    --this.iterationsize;
                    this.parent._changecount++;
                    this.changestamp = this.parent._changecount;
                } else {
                    this.parent._deleted.add(id);
                    this.parent._size--;
                    this.parent._changecount++;
                    ++this.cursor;
                    this.changestamp = this.parent._changecount;
                }
            }
        }
    }
}

