/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.Serializable;
import java.util.ArrayList;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;

public final class OID
implements Serializable {
    private final Object _identity;
    private final String _name;
    private final transient LockEngine _engine;
    private final transient ClassMolder _molder;
    private final OID _depends;
    private Object _stamp;
    private boolean _dbLock;
    private final int _hashCode;
    private String _topClassName;
    private String[] _superClassNames;

    public OID(LockEngine engine, ClassMolder molder, Object identity) {
        this(engine, molder, null, identity);
    }

    public OID(LockEngine engine, ClassMolder molder, OID depends, Object identity) {
        ArrayList<String> superClassNames = null;
        if (engine == null) {
            throw new IllegalArgumentException("engine can't be null");
        }
        if (molder == null) {
            throw new IllegalArgumentException("molder can't be null");
        }
        if (identity instanceof Object[]) {
            IllegalArgumentException e = new IllegalArgumentException("identity can't be object array!");
            throw e;
        }
        this._engine = engine;
        this._molder = molder;
        this._identity = identity;
        this._name = molder.getName();
        this._depends = depends;
        while (molder.getExtends() != null) {
            if (superClassNames == null) {
                superClassNames = new ArrayList<String>();
            }
            molder = molder.getExtends();
            superClassNames.add(molder.getName());
        }
        this._topClassName = molder.getName();
        if (superClassNames != null) {
            this._superClassNames = new String[superClassNames.size()];
            superClassNames.toArray(this._superClassNames);
        }
        this._hashCode = this._topClassName.hashCode() + (this._identity == null ? 0 : this._identity.hashCode());
    }

    public OID getDepends() {
        return this._depends;
    }

    ClassMolder getMolder() {
        return this._molder;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    Object getStamp() {
        return this._stamp;
    }

    void setStamp(Object stamp) {
        this._stamp = stamp;
    }

    void setDbLock(boolean dbLock) {
        this._dbLock = dbLock;
    }

    public boolean isDbLock() {
        return this._dbLock;
    }

    public Object getIdentity() {
        return this._identity;
    }

    String getName() {
        return this._name;
    }

    String[] getSuperClassNames() {
        return this._superClassNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        OID other = (OID)obj;
        return this._topClassName.equals(other._topClassName) && this._identity != null && this._identity.equals(other._identity);
    }

    public String toString() {
        return this._name + "/" + (this._identity == null ? "<new>" : this._identity.toString());
    }

    public int hashCode() {
        return this._hashCode;
    }
}

