/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;

public final class TransactionManagerFactoryRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry == null ? (class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry = TransactionManagerFactoryRegistry.class$("org.exolab.castor.jdo.transactionmanager.TransactionManagerFactoryRegistry")) : class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry));
    private static final String PROPERTY_TRANSACTION_MANAGER_FACTORY = "org.exolab.castor.jdo.spi.transactionManagerFactories";
    private static Hashtable _factories = null;
    static /* synthetic */ Class class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry;

    public static String[] getTransactionManagerFactoryNames() {
        TransactionManagerFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration enumeration = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)enumeration.nextElement();
        }
        return names;
    }

    public static TransactionManagerFactory getTransactionManagerFactory(String name) {
        if (_factories == null) {
            TransactionManagerFactoryRegistry.load();
        }
        return (TransactionManagerFactory)_factories.get(name);
    }

    private static void load() {
        if (_factories == null) {
            Hashtable<String, TransactionManagerFactory> factories = new Hashtable<String, TransactionManagerFactory>();
            LocalConfiguration cfg = LocalConfiguration.getInstance();
            String prop = cfg.getProperty(PROPERTY_TRANSACTION_MANAGER_FACTORY, "");
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            ClassLoader loader = (class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry == null ? (class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry = TransactionManagerFactoryRegistry.class$("org.exolab.castor.jdo.transactionmanager.TransactionManagerFactoryRegistry")) : class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry).getClassLoader();
            while (tokenizer.hasMoreTokens()) {
                String classname = tokenizer.nextToken();
                try {
                    Class<?> cls = loader.loadClass(classname);
                    Object obj = cls.newInstance();
                    TransactionManagerFactory factory = (TransactionManagerFactory)obj;
                    factories.put(factory.getName(), factory);
                }
                catch (Exception except) {
                    LOG.error((Object)Messages.format("jdo.transaction.failToCreateFactory", classname));
                }
            }
            _factories = factories;
        }
    }

    private TransactionManagerFactoryRegistry() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

