/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import org.castor.persist.resolver.ManyToManyRelationResolver;
import org.castor.persist.resolver.OneToManyRelationResolver;
import org.castor.persist.resolver.PersistanceCapableRelationResolver;
import org.castor.persist.resolver.PrimitiveResolver;
import org.castor.persist.resolver.ResolverStrategy;
import org.castor.persist.resolver.SerializableResolver;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;

public final class ResolverFactory {
    private ResolverFactory() {
    }

    public static ResolverStrategy createRelationResolver(FieldMolder fieldMolder, ClassMolder classMolder, boolean debug) {
        ResolverStrategy relationResolver = null;
        short fieldType = fieldMolder.getFieldType();
        switch (fieldType) {
            case 0: {
                relationResolver = new PrimitiveResolver(classMolder, fieldMolder, debug);
                break;
            }
            case 1: {
                relationResolver = new SerializableResolver(classMolder, fieldMolder, debug);
                break;
            }
            case 2: {
                relationResolver = new PersistanceCapableRelationResolver(classMolder, fieldMolder, debug);
                break;
            }
            case 3: {
                relationResolver = new OneToManyRelationResolver(classMolder, fieldMolder, debug);
                break;
            }
            case 4: {
                relationResolver = new ManyToManyRelationResolver(classMolder, fieldMolder, debug);
                break;
            }
        }
        return relationResolver;
    }
}

