/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.metadata;

import java.util.Map;

public class XPathUtils {
    private static final String LOCAL_REPLACEMENT = "' and local-name()='$1'";
    private static final String URI_REPLACEMENT = "*[namespace-uri()='";
    private static final String NS_START_REGEX = ":([a-zA-Z]+)";

    public static String translateXPath(String prefixedXpath, Map namespaces) {
        if (prefixedXpath == null || prefixedXpath.trim().length() == 0 || prefixedXpath.indexOf(":") < 0) {
            return prefixedXpath;
        }
        if (namespaces == null || namespaces.keySet().size() == 0) {
            throw new IllegalArgumentException("You specified an XPath with prefixes, yet didn't define any prefix mappings.");
        }
        for (String prefix : namespaces.keySet()) {
            String ns = (String)namespaces.get(prefix);
            prefixedXpath = prefixedXpath.replaceAll(prefix + NS_START_REGEX + "[\\s]*$", URI_REPLACEMENT + ns + LOCAL_REPLACEMENT + "]");
            prefixedXpath = prefixedXpath.replaceAll(prefix + NS_START_REGEX + "\\[", URI_REPLACEMENT + ns + LOCAL_REPLACEMENT + " and ");
            prefixedXpath = prefixedXpath.replaceAll(prefix + NS_START_REGEX + "([^\\[]){1,1}", URI_REPLACEMENT + ns + LOCAL_REPLACEMENT + "]$2");
        }
        return prefixedXpath;
    }
}

