/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.metadata;

import gov.nih.nci.cagrid.metadata.exceptions.InternalRuntimeException;
import gov.nih.nci.cagrid.metadata.exceptions.InvalidResourcePropertyException;
import gov.nih.nci.cagrid.metadata.exceptions.QueryInvalidException;
import gov.nih.nci.cagrid.metadata.exceptions.RemoteResourcePropertyRetrievalException;
import gov.nih.nci.cagrid.metadata.exceptions.ResourcePropertyRetrievalException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.globus.axis.util.Util;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.wsrf.utils.AnyHelper;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_PortType;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.UnknownQueryExpressionDialectFaultType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.w3c.dom.Element;

public class ResourcePropertyHelper {
    public static MessageElement[] queryResourceProperties(EndpointReferenceType endpoint, String queryExpression) throws RemoteResourcePropertyRetrievalException, QueryInvalidException {
        QueryResourceProperties_PortType port;
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        QueryExpressionType query = new QueryExpressionType();
        try {
            query.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        }
        catch (URI.MalformedURIException e) {
            throw new InternalRuntimeException(e);
        }
        query.setValue((Object)queryExpression);
        try {
            port = locator.getQueryResourcePropertiesPort(endpoint);
        }
        catch (ServiceException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        ResourcePropertyHelper.setAnonymous((Stub)port);
        QueryResourceProperties_Element request = new QueryResourceProperties_Element();
        request.setQueryExpression(query);
        QueryResourcePropertiesResponse response = null;
        response = ResourcePropertyHelper.issueRPQuery(port, request);
        return response.get_any();
    }

    public static Element getResourceProperties(EndpointReferenceType endpoint) throws ResourcePropertyRetrievalException, RemoteResourcePropertyRetrievalException, QueryInvalidException {
        Element element;
        QueryResourceProperties_PortType port;
        String dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        String queryExpression = "/";
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        QueryExpressionType query = new QueryExpressionType();
        try {
            query.setDialect(dialect);
        }
        catch (URI.MalformedURIException e) {
            throw new InternalRuntimeException(e);
        }
        query.setValue((Object)queryExpression);
        try {
            port = locator.getQueryResourcePropertiesPort(endpoint);
        }
        catch (ServiceException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        ResourcePropertyHelper.setAnonymous((Stub)port);
        QueryResourceProperties_Element request = new QueryResourceProperties_Element();
        request.setQueryExpression(query);
        QueryResourcePropertiesResponse response = ResourcePropertyHelper.issueRPQuery(port, request);
        MessageElement[] messageElements = response.get_any();
        if (messageElements == null) {
            return null;
        }
        if (messageElements.length > 1) {
            throw new ResourcePropertyRetrievalException("Resource property query returned " + Integer.toString(messageElements.length) + " elements; I only know how to deal with one");
        }
        try {
            element = messageElements[0].getAsDOM();
        }
        catch (Exception e) {
            throw new ResourcePropertyRetrievalException("Error parsing message element(" + messageElements[0] + ")", e);
        }
        return element;
    }

    public static Element getResourceProperty(EndpointReferenceType endpoint, QName rpName) throws ResourcePropertyRetrievalException, RemoteResourcePropertyRetrievalException, InvalidResourcePropertyException {
        Element element;
        GetResourceProperty port;
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        try {
            port = locator.getGetResourcePropertyPort(endpoint);
        }
        catch (ServiceException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        ResourcePropertyHelper.setAnonymous((Stub)port);
        GetResourcePropertyResponse response = null;
        try {
            response = port.getResourceProperty(rpName);
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            throw new InvalidResourcePropertyException(e);
        }
        catch (RemoteException e) {
            throw new RemoteResourcePropertyRetrievalException("Error getting resource property; endpoint was '" + endpoint + "', name was '" + rpName.toString(), e);
        }
        MessageElement[] messageElements = response.get_any();
        if (messageElements == null) {
            return null;
        }
        if (messageElements.length > 1) {
            throw new ResourcePropertyRetrievalException("Get resource property returned " + Integer.toString(messageElements.length) + " elements; I only know how to deal with one");
        }
        try {
            element = messageElements[0].getAsDOM();
        }
        catch (Exception e) {
            throw new ResourcePropertyRetrievalException("Error parsing message element(" + messageElements[0] + ")", e);
        }
        return element;
    }

    public static Element[] getResourceProperties(EndpointReferenceType endpoint, QName[] rpNames) throws ResourcePropertyRetrievalException {
        Element[] result;
        GetMultipleResourcePropertiesResponse response;
        GetMultipleResourceProperties_PortType port;
        WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
        try {
            port = locator.getGetMultipleResourcePropertiesPort(endpoint);
        }
        catch (ServiceException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        ResourcePropertyHelper.setAnonymous((Stub)port);
        GetMultipleResourceProperties_Element request = new GetMultipleResourceProperties_Element();
        request.setResourceProperty(rpNames);
        try {
            response = port.getMultipleResourceProperties(request);
        }
        catch (InvalidResourcePropertyQNameFaultType e) {
            throw new InvalidResourcePropertyException(e);
        }
        catch (RemoteException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        try {
            result = AnyHelper.toElement((MessageElement[])response.get_any());
        }
        catch (Exception e) {
            throw new ResourcePropertyRetrievalException("Error converting resource properties to elements: " + e.getMessage(), e);
        }
        return result;
    }

    private static void setAnonymous(Stub stub) {
        stub._setProperty("org.globus.gsi.anonymous", (Object)Boolean.TRUE);
        stub._setProperty("org.globus.security.authorization", (Object)org.globus.wsrf.impl.security.authorization.NoAuthorization.getInstance());
        stub._setProperty("org.globus.gsi.authorization", (Object)NoAuthorization.getInstance());
    }

    private static QueryResourcePropertiesResponse issueRPQuery(QueryResourceProperties_PortType port, QueryResourceProperties_Element request) throws QueryInvalidException, RemoteResourcePropertyRetrievalException {
        QueryResourcePropertiesResponse response = null;
        try {
            response = port.queryResourceProperties(request);
        }
        catch (InvalidQueryExpressionFaultType e) {
            throw new QueryInvalidException(e);
        }
        catch (QueryEvaluationErrorFaultType e) {
            throw new QueryInvalidException(e);
        }
        catch (UnknownQueryExpressionDialectFaultType e) {
            throw new InternalRuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RemoteResourcePropertyRetrievalException(e);
        }
        return response;
    }

    static {
        Util.registerTransport();
    }
}

