/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.encoding;

import gov.nih.nci.cagrid.encoding.AxisContentHandler;
import gov.nih.nci.cagrid.encoding.EncodingUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class SDKSerializer
implements Serializer {
    protected static Log LOG = LogFactory.getLog((String)SDKSerializer.class.getName());

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        long startTime = System.currentTimeMillis();
        AxisContentHandler hand = new AxisContentHandler(context);
        Marshaller marshaller = new Marshaller((ContentHandler)hand);
        try {
            Mapping mapping = EncodingUtils.getMapping(context.getMessageContext());
            marshaller.setMapping(mapping);
            marshaller.setValidation(true);
        }
        catch (MappingException e) {
            LOG.error((Object)"Problem establishing castor mapping!  Using default mapping.", (Throwable)e);
        }
        try {
            marshaller.marshal(value);
        }
        catch (MarshalException e) {
            LOG.error((Object)"Problem using castor marshalling.", (Throwable)e);
            throw new IOException("Problem using castor marshalling." + e.getMessage());
        }
        catch (ValidationException e) {
            LOG.error((Object)"Problem validating castor marshalling; message doesn't comply with the associated XML schema.", (Throwable)e);
            throw new IOException("Problem validating castor marshalling; message doesn't comply with the associated XML schema." + e.getMessage());
        }
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug((Object)("Total time to serialize(" + name.getLocalPart() + "):" + duration + " ms."));
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

