/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.encoding;

import gov.nih.nci.cagrid.encoding.EncodingUtils;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SDKDeserializer
extends DeserializerImpl
implements Deserializer {
    public QName xmlType;
    public Class javaType;
    protected static Log LOG = LogFactory.getLog((String)SDKDeserializer.class.getName());

    public SDKDeserializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) {
        long startTime = System.currentTimeMillis();
        Unmarshaller unmarshall = new Unmarshaller(this.javaType);
        try {
            Mapping mapping = EncodingUtils.getMapping(context.getMessageContext());
            if (mapping != null) {
                unmarshall.setMapping(mapping);
            } else {
                LOG.error((Object)"Castor mapping was null!  Using default mapping.");
            }
        }
        catch (MappingException e) {
            LOG.error((Object)"Problem establishing castor mapping!  Using default mapping.", (Throwable)e);
        }
        MessageElement msgElem = context.getCurElement();
        Element asDOM = null;
        try {
            asDOM = msgElem.getAsDOM();
        }
        catch (Exception e) {
            LOG.error((Object)"Problem extracting message type! Result will be null!", (Throwable)e);
        }
        if (asDOM != null) {
            try {
                this.value = unmarshall.unmarshal((Node)asDOM);
            }
            catch (MarshalException e) {
                LOG.error((Object)"Problem with castor marshalling!", (Throwable)e);
            }
            catch (ValidationException e) {
                LOG.error((Object)"XML does not match schema!", (Throwable)e);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug((Object)("Total time to deserialize(" + localName + "):" + duration + " ms."));
    }
}

