/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis.MessageContext;
import org.apache.axis.utils.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EncodingUtils {
    public static final String CASTOR_MAPPING_DTD = "mapping.dtd";
    public static final String CASTOR_MAPPING_DTD_ENTITY = "-//EXOLAB/Castor Object Mapping DTD Version 1.0//EN";
    public static final String DEFAULT_XML_MAPPING = "/xml-mapping.xml";
    public static final String CASTOR_MAPPING_PROPERTY = "castorMapping";
    protected static Log LOG = LogFactory.getLog((String)EncodingUtils.class.getName());
    protected static Map<String, Mapping> mappingCacheMap = new Hashtable<String, Mapping>();

    public static Mapping getMapping(MessageContext context) {
        long startTime = System.currentTimeMillis();
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals(EncodingUtils.CASTOR_MAPPING_DTD_ENTITY)) {
                    InputStream in = ClassUtils.getResourceAsStream(EncodingUtils.class, (String)EncodingUtils.CASTOR_MAPPING_DTD);
                    return new InputSource(in);
                }
                return null;
            }
        };
        String mappingLocation = DEFAULT_XML_MAPPING;
        if (context != null) {
            String prop = (String)context.getProperty(CASTOR_MAPPING_PROPERTY);
            if (prop != null && !prop.trim().equals("")) {
                mappingLocation = prop;
                LOG.debug((Object)"Loading castor mapping from message context property[castorMapping]");
            } else {
                try {
                    prop = (String)context.getAxisEngine().getConfig().getGlobalOptions().get(CASTOR_MAPPING_PROPERTY);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Error reading global configuration:" + e.getMessage()), (Throwable)e);
                }
                if (prop != null && !prop.trim().equals("")) {
                    mappingLocation = prop;
                    LOG.debug((Object)"Loading castor mapping from globalConfiguration property[castorMapping]");
                } else {
                    LOG.debug((Object)"Unable to locate castor mapping property[castorMapping], using default mapping location:/xml-mapping.xml");
                }
            }
        } else {
            LOG.debug((Object)"Unable to determine message context, using default mapping location:/xml-mapping.xml");
        }
        Mapping mapping = null;
        if (mappingCacheMap.containsKey(mappingLocation)) {
            LOG.debug((Object)("Loading Mapping from cache for location:" + mappingLocation));
            mapping = mappingCacheMap.get(mappingLocation);
        } else {
            LOG.debug((Object)("Unable to loading Mapping from cache for location:" + mappingLocation));
            LOG.debug((Object)("Attempting to load mapping from mapping location:" + mappingLocation));
            InputStream mappingStream = ClassUtils.getResourceAsStream(EncodingUtils.class, (String)mappingLocation);
            if (mappingStream == null) {
                LOG.error((Object)("Mapping file [" + mappingLocation + "] was null!"));
            } else {
                InputSource mappIS = new InputSource(mappingStream);
                mapping = new Mapping();
                mapping.setEntityResolver(resolver);
                try {
                    mapping.loadMapping(mappIS);
                    mappingCacheMap.put(mappingLocation, mapping);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to load mapping file:" + mappingLocation), (Throwable)e);
                    mapping = null;
                }
                catch (MappingException e) {
                    LOG.error((Object)"Problem with mapping!", (Throwable)e);
                    mapping = null;
                }
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug((Object)("Time to load mapping file:" + duration + " ms."));
        return mapping;
    }
}

