/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.globus.gsi.GlobusCredential;
import org.globus.util.ConfigUtil;

public class ProxyUtil {
    public static void saveProxy(GlobusCredential proxy, String file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        proxy.save((OutputStream)fos);
        fos.close();
    }

    public static GlobusCredential getDefaultProxy() throws Exception {
        return ProxyUtil.loadProxy(ConfigUtil.discoverProxyLocation());
    }

    public static void destroyDefaultProxy() {
        File f = new File(ConfigUtil.discoverProxyLocation());
        f.delete();
    }

    public static GlobusCredential loadProxy(String location) throws Exception {
        FileInputStream fis = new FileInputStream(location);
        GlobusCredential proxy = new GlobusCredential((InputStream)fis);
        return proxy;
    }

    public static void deleteDefaultProxy() {
        File f = new File(ConfigUtil.discoverProxyLocation());
        f.delete();
    }

    public static void saveProxyAsDefault(GlobusCredential proxy) throws Exception {
        ProxyUtil.saveProxy(proxy, ConfigUtil.discoverProxyLocation());
    }
}

