/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.portal.validation;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IconFeedbackPanel
extends JLayeredPane {
    private static final int CONTENT_LAYER = 1;
    private static final int FEEDBACK_LAYER = 2;
    private final ValidationResultModel model;
    private final JComponent content;

    public IconFeedbackPanel(ValidationResultModel model, JComponent content) {
        if (model == null) {
            throw new NullPointerException("The validation result model must not be null.");
        }
        if (content == null) {
            throw new NullPointerException("The content must not be null.");
        }
        this.model = model;
        this.content = content;
        this.setLayout(new SimpleLayout());
        this.add((Component)content, 1);
        this.initEventHandling();
    }

    public static JComponent getWrappedComponentTree(ValidationResultModel model, JComponent root) {
        IconFeedbackPanel.wrapComponentTree(model, root);
        return IconFeedbackPanel.isScrollPaneWithUnmarkableView(root) ? root : new IconFeedbackPanel(model, root);
    }

    private static void wrapComponentTree(ValidationResultModel model, Container container) {
        if (!(container instanceof JScrollPane)) {
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component child = container.getComponent(i);
                if (!(child instanceof Container)) continue;
                IconFeedbackPanel.wrapComponentTree(model, (Container)child);
            }
            return;
        }
        JScrollPane scrollPane = (JScrollPane)container;
        JViewport viewport = scrollPane.getViewport();
        JComponent view = (JComponent)viewport.getView();
        if (IconFeedbackPanel.isMarkable(view)) {
            return;
        }
        IconFeedbackPanel wrappedView = new IconFeedbackPanel(model, view);
        viewport.setView(wrappedView);
        IconFeedbackPanel.wrapComponentTree(model, view);
    }

    private static boolean isScrollPaneWithUnmarkableView(Component c) {
        if (!(c instanceof JScrollPane)) {
            return false;
        }
        JScrollPane scrollPane = (JScrollPane)c;
        JViewport viewport = scrollPane.getViewport();
        JComponent view = (JComponent)viewport.getView();
        return !IconFeedbackPanel.isMarkable(view);
    }

    private void initEventHandling() {
        this.model.addPropertyChangeListener("result", (PropertyChangeListener)new ValidationResultChangeHandler());
    }

    private JComponent createFeedbackComponent(ValidationResult result, Component contentComponent) {
        Icon icon = ValidationResultViewFactory.getSmallIcon((Severity)result.getSeverity());
        JLabel label = new JLabel(icon);
        label.setToolTipText(IconFeedbackPanel.getMessagesToolTipText(result));
        label.setSize(label.getPreferredSize());
        return label;
    }

    private static String getMessagesToolTipText(ValidationResult result) {
        StringBuilder builder = new StringBuilder("<html>");
        for (ValidationMessage message : result.getMessages()) {
            if (builder.length() > 0) {
                builder.append("<br>");
            }
            builder.append(message.formattedText());
        }
        builder.append("</html>");
        return builder.toString();
    }

    private Point getFeedbackComponentOrigin(JComponent feedbackComponent, Component contentComponent) {
        boolean isLTR = contentComponent.getComponentOrientation().isLeftToRight();
        int x = contentComponent.getX() + (isLTR ? 0 : contentComponent.getWidth() - 1) - feedbackComponent.getWidth() / 2;
        int y = contentComponent.getY() + contentComponent.getHeight() - feedbackComponent.getHeight() + 2;
        return new Point(x, y);
    }

    private void removeAllFeedbackComponents() {
        int componentCount = this.getComponentCount();
        for (int i = componentCount - 1; i >= 0; --i) {
            Component child = this.getComponent(i);
            int layer = this.getLayer(child);
            if (layer != 2) continue;
            this.remove(i);
        }
    }

    private void visitComponentTree(Container container, Map<Object, ValidationResult> keyMap, int xOffset, int yOffset) {
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = container.getComponent(i);
            if (!child.isVisible()) continue;
            if (IconFeedbackPanel.isMarkable(child)) {
                if (IconFeedbackPanel.isScrollPaneView(child)) {
                    Container containerParent = container.getParent();
                    this.addFeedbackComponent(containerParent, (JComponent)child, keyMap, xOffset - containerParent.getX(), yOffset - containerParent.getY());
                    continue;
                }
                this.addFeedbackComponent(child, (JComponent)child, keyMap, xOffset, yOffset);
                continue;
            }
            if (IconFeedbackPanel.isScrollPaneView(child) || !(child instanceof Container)) continue;
            this.visitComponentTree((Container)child, keyMap, xOffset + child.getX(), yOffset + child.getY());
        }
    }

    private static boolean isScrollPaneView(Component c) {
        Container container = c.getParent();
        Container containerParent = container.getParent();
        return container instanceof JViewport && containerParent instanceof JScrollPane;
    }

    private static boolean isMarkable(Component component) {
        return component instanceof JTextComponent || component instanceof JComboBox;
    }

    private void addFeedbackComponent(Component contentComponent, JComponent messageComponent, Map<Object, ValidationResult> keyMap, int xOffset, int yOffset) {
        ValidationResult result = IconFeedbackPanel.getAssociatedResult(messageComponent, keyMap);
        JComponent feedbackComponent = this.createFeedbackComponent(result, contentComponent);
        if (feedbackComponent == null) {
            return;
        }
        this.add((Component)feedbackComponent, (Object)2);
        Point overlayPosition = this.getFeedbackComponentOrigin(feedbackComponent, contentComponent);
        overlayPosition.translate(xOffset, yOffset);
        feedbackComponent.setLocation(overlayPosition);
    }

    private static ValidationResult getAssociatedResult(JComponent comp, Map<Object, ValidationResult> keyMap) {
        ValidationResult result = ValidationComponentUtils.getAssociatedResult((JComponent)comp, keyMap);
        return result == null ? ValidationResult.EMPTY : result;
    }

    private void updateFeedbackComponents() {
        this.removeAllFeedbackComponents();
        this.visitComponentTree(this.content, this.model.getResult().keyMap(), 0, 0);
        this.repaint();
    }

    private void repositionFeedbackComponents() {
        this.updateFeedbackComponents();
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        if (this.isVisible()) {
            this.repositionFeedbackComponents();
        }
    }

    private final class SimpleLayout
    implements LayoutManager {
        private SimpleLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return IconFeedbackPanel.this.content.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return IconFeedbackPanel.this.content.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            IconFeedbackPanel.this.content.setBounds(0, 0, size.width, size.height);
        }
    }

    private final class ValidationResultChangeHandler
    implements PropertyChangeListener {
        private ValidationResultChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            IconFeedbackPanel.this.updateFeedbackComponents();
        }
    }
}

