/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.portal;

import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow
implements Runnable {
    private String imagePath;
    private BufferedImage bufImage;
    private Rectangle rect;
    private boolean isAlive;

    public SplashScreen(String imagePath) {
        this.imagePath = imagePath;
        this.run();
    }

    public void run() {
        this.isAlive = true;
        Image image = null;
        try {
            image = new ImageIcon(this.getClass().getResource(this.imagePath)).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(this.imagePath + " was not found or is not an image file.");
            return;
        }
        if (image != null) {
            int imageWidth = image.getWidth(this);
            int imageHeight = image.getHeight(this);
            if (imageWidth > 0 && imageHeight > 0) {
                int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
                int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
                this.rect = new Rectangle((screenWidth - imageWidth) / 2, (screenHeight - imageHeight) / 2, imageWidth, imageHeight);
                try {
                    this.bufImage = new Robot().createScreenCapture(this.rect);
                }
                catch (AWTException e) {
                    // empty catch block
                }
                Graphics2D g2D = this.bufImage.createGraphics();
                g2D.drawImage(image, 0, 0, this);
                this.setBounds(this.rect);
                this.setVisible(true);
            } else {
                System.err.println(this.imagePath + " is not a valid image.");
            }
        } else {
            System.err.println(this.imagePath + " not found.");
        }
        this.isAlive = false;
    }

    public void close() throws IllegalStateException {
        if (this.isAlive) {
            throw new IllegalStateException("SplashScreen not yet fully initialized.");
        }
        this.dispose();
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.drawImage((Image)this.bufImage, 0, 0, this);
    }
}

