/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.portal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PromptButtonDialog
extends JDialog {
    public static final String DEFAULT_TITLE = "Select an option";
    public static final int MAX_BUTTON_WIDTH = 4;
    private String[] message;
    private String[] options;
    private String defOption;
    private String selection;
    private JPanel mainPanel = null;
    private JPanel textPanel = null;
    private JPanel buttonPanel = null;

    public PromptButtonDialog(Frame owner, String title, String[] message, String[] options, String def) {
        super(owner, title, true);
        this.message = message;
        this.options = options;
        this.defOption = def;
        this.selection = null;
        this.initialize();
    }

    public PromptButtonDialog(Dialog owner, String title, String[] message, String[] options, String def) {
        super(owner, title, true);
        this.message = message;
        this.options = options;
        this.defOption = def;
        this.selection = null;
        this.initialize();
    }

    public static String prompt(Frame owner, String title, String[] message, String[] options, String def) {
        PromptButtonDialog dialog = new PromptButtonDialog(owner, title, message, options, def);
        return PromptButtonDialog.displayDialog(dialog);
    }

    public static String prompt(Dialog owner, String title, String[] message, String[] options, String def) {
        PromptButtonDialog dialog = new PromptButtonDialog(owner, title, message, options, def);
        return PromptButtonDialog.displayDialog(dialog);
    }

    private static String displayDialog(PromptButtonDialog dialog) {
        dialog.setVisible(true);
        return dialog.getSelection();
    }

    private void initialize() {
        this.initButtons();
        this.initText();
        this.setContentPane(this.getMainPanel());
        this.pack();
    }

    public String getSelection() {
        return this.selection;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setSize(new Dimension(262, 157));
            this.mainPanel.add((Component)this.getTextPanel(), gridBagConstraints);
            this.mainPanel.add((Component)this.getButtonPanel(), gridBagConstraints1);
        }
        return this.mainPanel;
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            this.textPanel = new JPanel();
            this.textPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.textPanel.setLayout(new GridBagLayout());
        }
        return this.textPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
        }
        return this.buttonPanel;
    }

    private void initButtons() {
        ActionListener disposeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PromptButtonDialog.this.selection = ((JButton)e.getSource()).getText();
                PromptButtonDialog.this.dispose();
            }
        };
        Insets insets = new Insets(2, 2, 2, 2);
        for (int i = 0; i < this.options.length; ++i) {
            JButton button = new JButton(this.options[i]);
            if (this.options[i].equals(this.defOption)) {
                this.getRootPane().setDefaultButton(button);
            }
            button.addActionListener(disposeListener);
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridx = i % 4;
            cons.gridy = (int)Math.floor((double)i / 4.0);
            cons.insets = insets;
            this.getButtonPanel().add((Component)button, cons);
        }
        this.pack();
    }

    private void initText() {
        int i = 0;
        while (i < this.message.length) {
            JTextField text = new JTextField(this.message[i]);
            text.setEditable(false);
            text.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridx = 0;
            cons.gridy = i++;
            cons.anchor = 17;
            cons.fill = 2;
            cons.weightx = 1.0;
            this.getTextPanel().add((Component)text, cons);
        }
        this.pack();
    }

    public static void main(String[] args) {
        String[] choices = new String[]{"one", "two", "three", "four", "five"};
        String[] text = new String[]{"hello there", "please choose", "an option!"};
        String selection = PromptButtonDialog.prompt((Frame)null, "choices", text, choices, choices[3]);
        System.out.println(selection);
    }
}

