/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.portal;

import gov.nih.nci.cagrid.common.portal.PortalTableCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public abstract class PortalTable
extends JTable {
    private static final Color DEFAULT_FOREGROUND_1 = Color.BLACK;
    private static final Color DEFAULT_BACKGROUND_1 = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND_2 = Color.BLACK;
    private static final Color DEFAULT_BACKGROUND_2 = Color.WHITE;
    private static final Color DEFAULT_SELECTED_FOREGROUND = Color.BLACK;
    private static final Color DEFAULT_SELECTED_BACKGROUND = Color.WHITE;

    public PortalTable(DefaultTableModel model) {
        this(model, DEFAULT_BACKGROUND_1, DEFAULT_FOREGROUND_1, DEFAULT_BACKGROUND_2, DEFAULT_FOREGROUND_2, DEFAULT_SELECTED_BACKGROUND, DEFAULT_SELECTED_FOREGROUND);
    }

    public PortalTable(DefaultTableModel model, Color bg1, Color fg1, Color bg2, Color fg2, Color sbg, Color sfg) {
        super(model);
        this.setDefaultRenderer(Object.class, new PortalTableCellRenderer(bg1, fg1, bg2, fg2, sbg, sfg));
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        PortalTable.this.doubleClick();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (e.getClickCount() == 1) {
                    try {
                        PortalTable.this.singleClick();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public abstract void doubleClick() throws Exception;

    public abstract void singleClick() throws Exception;

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public synchronized void addRow(Vector v) {
        ((DefaultTableModel)this.getModel()).addRow(v);
    }

    public synchronized void removeRow(int i) {
        ((DefaultTableModel)this.getModel()).removeRow(i);
    }

    public synchronized void clearTable() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        while (model.getRowCount() != 0) {
            model.removeRow(0);
        }
    }
}

