/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common.portal;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class MultiEventProgressBar
extends JProgressBar {
    private Map<Integer, String> events = new HashMap<Integer, String>();
    private int id = 0;
    private boolean hideWhenComplete;

    public MultiEventProgressBar(boolean onlyShowWhenWorking) {
        this.hideWhenComplete = onlyShowWhenWorking;
        this.setVisible(!onlyShowWhenWorking);
        this.setString("");
        this.setStringPainted(true);
    }

    public synchronized int startEvent(String message) {
        this.setVisible(true);
        ++this.id;
        Integer bid = new Integer(this.id);
        this.events.put(bid, message);
        if (this.events.size() == 1) {
            this.updateProgress(true, message);
        }
        return this.id;
    }

    public void updateProgress(final String message, final int min, final int max, final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MultiEventProgressBar.this.setIndeterminate(false);
                MultiEventProgressBar.this.setString(message);
                MultiEventProgressBar.this.setStringPainted(true);
                MultiEventProgressBar.this.setMinimum(min);
                MultiEventProgressBar.this.setMaximum(max);
                MultiEventProgressBar.this.setValue(current);
            }
        });
    }

    public synchronized void stopEvent(int eventID, String message) {
        Integer bid = new Integer(eventID);
        this.events.remove(bid);
        if (this.events.size() == 0) {
            this.updateProgress(false, message);
            this.setVisible(!this.hideWhenComplete);
        } else {
            Integer min = null;
            for (Integer num : this.events.keySet()) {
                if (min != null && num >= min) continue;
                min = num;
            }
            String s = this.events.get(min);
            this.updateProgress(true, s);
        }
    }

    public synchronized void stopAll(String message) {
        this.events.clear();
        this.updateProgress(false, message);
        this.setVisible(!this.hideWhenComplete);
    }

    private void updateProgress(final boolean working, final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (s != null && !s.trim().equals("")) {
                    MultiEventProgressBar.this.setString(s);
                    MultiEventProgressBar.this.setStringPainted(true);
                } else {
                    MultiEventProgressBar.this.setStringPainted(false);
                }
                MultiEventProgressBar.this.setIndeterminate(working);
            }
        });
    }
}

