/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import gov.nih.nci.cagrid.common.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtilities {
    public static void unzip(File zip, File location) throws IOException {
        FileInputStream zipFileInput = new FileInputStream(zip.getAbsoluteFile());
        ZipInputStream zipInput = new ZipInputStream(zipFileInput);
        ZipEntry entry = null;
        String baseDir = null;
        baseDir = location == null ? zip.getParentFile().getAbsolutePath() : location.getAbsolutePath();
        while ((entry = zipInput.getNextEntry()) != null) {
            String name = entry.getName();
            File outFile = new File(baseDir + File.separator + name);
            if (entry.isDirectory()) {
                outFile.mkdirs();
                continue;
            }
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            outFile.createNewFile();
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(outFile));
            ZipUtilities.copyStreams(zipInput, fileOut);
            fileOut.flush();
            fileOut.close();
        }
        zipInput.close();
    }

    public static void unzipInPlace(File zip) throws IOException {
        ZipUtilities.unzip(zip, null);
    }

    public static void zipDirectory(File dir, File zipFile) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
        List<File> files = Utils.recursiveListFiles(dir, new FileFilter(){

            public boolean accept(File name) {
                return true;
            }
        });
        int baseDirNameLength = dir.getAbsolutePath().length();
        for (File fileToAdd : files) {
            String relativeFileName = fileToAdd.getAbsolutePath().substring(baseDirNameLength + 1);
            ZipEntry entry = new ZipEntry(relativeFileName);
            zipOut.putNextEntry(entry);
            if (fileToAdd.isDirectory()) continue;
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(fileToAdd));
            ZipUtilities.copyStreams(fileInput, zipOut);
            fileInput.close();
        }
        zipOut.flush();
        zipOut.close();
    }

    public static byte[] extractEntryContents(File zipFile, String entryName) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ZipFile zip = new ZipFile(zipFile);
        ZipEntry entry = zip.getEntry(entryName);
        InputStream stream = zip.getInputStream(entry);
        ZipUtilities.copyStreams(stream, output);
        stream.close();
        output.flush();
        output.close();
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertEntry(File zipFile, String entryName, byte[] data) throws IOException {
        File tempZip = File.createTempFile(zipFile.getName(), "tmp");
        tempZip.delete();
        FileOutputStream tempOut = new FileOutputStream(tempZip);
        ZipOutputStream zipOut = new ZipOutputStream(tempOut);
        try {
            ZipFile zipIn = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zipIn.entries();
            while (entries.hasMoreElements()) {
                ZipEntry inputEntry = entries.nextElement();
                if (inputEntry.getName().equals(entryName)) continue;
                InputStream entryStream = zipIn.getInputStream(inputEntry);
                zipOut.putNextEntry(inputEntry);
                ZipUtilities.copyStreams(entryStream, zipOut);
                zipOut.closeEntry();
            }
            ZipEntry insert = new ZipEntry(entryName);
            zipOut.putNextEntry(insert);
            ZipUtilities.copyStreams(new ByteArrayInputStream(data), zipOut);
            zipOut.closeEntry();
            zipOut.close();
            zipIn.close();
            zipFile.delete();
            Utils.copyFile(tempZip, zipFile);
        }
        finally {
            tempZip.delete();
        }
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        byte[] temp = new byte[8192];
        int read = -1;
        while ((read = input.read(temp)) != -1) {
            output.write(temp, 0, read);
        }
    }
}

