/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtilities {
    public static String documentToString(Document doc) {
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        return outputter.outputString(doc);
    }

    public static String elementToString(Element element) {
        XMLOutputter outputter = new XMLOutputter(Format.getRawFormat());
        return outputter.outputString(element);
    }

    public static Document fileNameToDocument(String fileName) throws Exception {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(fileName);
            return doc;
        }
        catch (Exception e) {
            throw new Exception("Error creating document: " + e.getMessage(), e);
        }
    }

    public static Document stringToDocument(String string) throws Exception {
        return XMLUtilities.streamToDocument(new ByteArrayInputStream(string.getBytes()));
    }

    public static Document streamToDocument(InputStream stream) throws Exception {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(stream);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Document construction failed:" + e.getMessage(), e);
        }
    }

    public static String formatXML(String s) throws Exception {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(s));
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            return out.outputString(doc);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private static String bufferToString(BufferedReader br) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            String s = null;
            while ((s = br.readLine()) != null) {
                sb.append(s + "\n");
            }
        }
        catch (Exception e) {
            throw new Exception("Error reading the buffer: " + e.getMessage());
        }
        return sb.toString();
    }

    public static String streamToString(InputStream stream) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        return XMLUtilities.bufferToString(br);
    }
}

