/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import gov.nih.nci.cagrid.common.ConfigurableObjectDeserializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.XMLUtils;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static File getCaGridUserHome() {
        String userHome = System.getProperty("user.home");
        File userHomeF = new File(userHome);
        File caGridCache = new File(userHomeF.getAbsolutePath() + File.separator + ".cagrid");
        if (!caGridCache.exists()) {
            caGridCache.mkdirs();
        }
        return caGridCache;
    }

    public static File getTrustedCerificatesDirectory() {
        String caDir = CoGProperties.getDefault().getCaCertLocations();
        if (caDir != null) {
            return new File(caDir);
        }
        String userHome = System.getProperty("user.home");
        File userHomeF = new File(userHome);
        File dir = new File(userHomeF.getAbsolutePath() + File.separator + ".globus" + File.separator + "certificates");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void validateGlobusCredential(GlobusCredential cred) throws ProxyPathValidatorException {
        Utils.validateCertificateChain(cred.getCertificateChain());
    }

    public static void validateCertificateChain(X509Certificate[] chain) throws ProxyPathValidatorException {
        ProxyPathValidator validator = new ProxyPathValidator();
        validator.validate(chain, TrustedCertificates.getDefaultTrustedCertificates().getCertificates(), CertificateRevocationLists.getDefaultCertificateRevocationLists());
    }

    public static String getExceptionMessage(Throwable e) {
        String mess = e.getMessage();
        if (e instanceof AxisFault) {
            AxisFault af = (AxisFault)e;
            if (af.getFaultCode() != null && af.getFaultCode().toString().equals("{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}General")) {
                System.out.println(af.getFaultString());
                mess = af.getFaultString() != null && af.getFaultString().equals("javax.xml.rpc.soap.SOAPFaultException") ? "An error occurred establishing a secure communication channel.  The problem may be that the client's credentials are NOT trusted by the server." : af.getFaultString();
            } else {
                mess = af.getFaultString() != null && af.getFaultString().equals("java.io.EOFException") ? "An error occurred in communicating with the service.  If using credentials to authenticate to the service, the problem may be that the credentials being used are not trusted by the server." : (af.getFaultString() != null && af.getFaultString().equals("java.net.SocketException: Connection reset") ? "An error occurred in communicating with the service.  If using credentials to authenticate to the service, the problem may be that the credentials being used are not trusted by the server." : af.getFaultString());
            }
        }
        return Utils.simplifyErrorMessage(mess);
    }

    public static String simplifyErrorMessage(String m) {
        if (m == null || m.equalsIgnoreCase("null")) {
            m = "Unknown Error";
        } else if (m.indexOf("Connection refused") >= 0) {
            m = "Error establishing a connection to the requested service, the service may not exist or may be down.";
        } else if (m.indexOf("Unknown CA") >= 0) {
            m = "Could establish a connection with the service, the service CA is not trusted.";
        }
        return m;
    }

    public static Object deserializeDocument(String fileName, Class objectType) throws Exception {
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(fileName);
        Document doc = XMLUtils.newDocument((InputStream)inputStream);
        Object obj = ObjectDeserializer.toObject((Element)doc.getDocumentElement(), (Class)objectType);
        ((InputStream)inputStream).close();
        return obj;
    }

    public static void copyFile(File in, File out) throws IOException {
        if (in.equals(out)) {
            return;
        }
        out.getCanonicalFile().getParentFile().mkdirs();
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(in));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(out));
        byte[] tmpBuffer = new byte[8192];
        int len = 0;
        while ((len = fis.read(tmpBuffer)) != -1) {
            fos.write(tmpBuffer, 0, len);
        }
        fis.close();
        fos.flush();
        fos.close();
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                Utils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            Utils.copyFile(srcDir, dstDir);
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                System.err.println("could not remove directory: " + dir.getAbsolutePath());
                return false;
            }
        }
        return dir.delete();
    }

    public static Object concatenateArrays(Class resultClass, Object arr1, Object arr2) throws ArrayStoreException {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        Object newArray = Array.newInstance(resultClass, Array.getLength(arr1) + Array.getLength(arr2));
        System.arraycopy(arr1, 0, newArray, 0, Array.getLength(arr1));
        System.arraycopy(arr2, 0, newArray, Array.getLength(arr1), Array.getLength(arr2));
        return newArray;
    }

    public static Object appendToArray(Object array, Object appendix) {
        Class<?> arrayType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(arrayType, Array.getLength(array) + 1);
        System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
        Array.set(newArray, Array.getLength(newArray) - 1, appendix);
        return newArray;
    }

    public static Object removeFromArray(Object array, Object removal) {
        Class<?> arrayType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        ArrayList<Object> temp = new ArrayList<Object>(length - 1);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(array, i);
            if (o.equals(removal)) continue;
            temp.add(o);
        }
        Object newArray = Array.newInstance(arrayType, temp.size());
        System.arraycopy(temp.toArray(), 0, newArray, 0, temp.size());
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer fileToStringBuffer(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringBuffer sb = new StringBuffer();
        try {
            String s = null;
            while ((s = br.readLine()) != null) {
                sb.append(s + "\n");
            }
        }
        finally {
            br.close();
        }
        return sb;
    }

    public static StringBuffer inputStreamToStringBuffer(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        StringBuffer str = new StringBuffer();
        char[] buff = new char[8192];
        int len = 0;
        while ((len = reader.read(buff)) != -1) {
            str.append(buff, 0, len);
        }
        reader.close();
        return str;
    }

    public static void serializeObject(Object obj, QName qname, Writer writer, InputStream wsdd) throws Exception {
        MessageElement element = (MessageElement)ObjectSerializer.toSOAPElement((Object)obj, (QName)qname);
        FileProvider engineConfig = new FileProvider(wsdd);
        AxisServer axisClient = new AxisServer((EngineConfiguration)engineConfig);
        MessageContext messageContext = new MessageContext((AxisEngine)axisClient);
        messageContext.setEncodingStyle("");
        messageContext.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        messageContext.setProperty("emitAllTypesInWSDL", (Object)Boolean.FALSE);
        messageContext.setProperty("sendXsiTypes", (Object)Boolean.FALSE);
        SerializationContext serializationContext = new SerializationContext(writer, messageContext);
        serializationContext.setPretty(true);
        element.output(serializationContext);
        writer.write("\n");
        writer.flush();
    }

    public static void serializeObject(Object obj, QName qname, Writer writer) throws Exception {
        MessageElement element = (MessageElement)ObjectSerializer.toSOAPElement((Object)obj, (QName)qname);
        MessageContext messageContext = new MessageContext((AxisEngine)new AxisServer());
        messageContext.setEncodingStyle("");
        messageContext.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        messageContext.setProperty("emitAllTypesInWSDL", (Object)Boolean.FALSE);
        messageContext.setProperty("sendXsiTypes", (Object)Boolean.FALSE);
        SerializationContext serializationContext = new SerializationContext(writer, messageContext);
        serializationContext.setPretty(true);
        element.output(serializationContext);
        writer.write("\n");
        writer.flush();
    }

    public static Object deserializeObject(Reader xmlReader, Class clazz, InputStream wsdd) throws SAXException, DeserializationException {
        InputSource xmlSource = new InputSource(xmlReader);
        return ConfigurableObjectDeserializer.toObject(xmlSource, clazz, wsdd);
    }

    public static Object deserializeObject(Reader xmlReader, Class clazz) throws Exception {
        Document doc = XMLUtils.newDocument((InputSource)new InputSource(xmlReader));
        Object obj = ObjectDeserializer.toObject((Element)doc.getDocumentElement(), (Class)clazz);
        return obj;
    }

    public static void serializeDocument(String fileName, Object object, QName qname) throws Exception {
        FileWriter fw = null;
        fw = new FileWriter(fileName);
        ObjectSerializer.serialize((Writer)fw, (Object)object, (QName)qname);
        fw.close();
    }

    public static String clean(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    public static void stringBufferToFile(StringBuffer string, String fileName) throws IOException {
        FileWriter fw = new FileWriter(new File(fileName));
        fw.write(string.toString());
        fw.close();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static QName getRegisteredQName(Class clazz) {
        return MessageContext.getCurrentContext().getTypeMapping().getTypeQName(clazz);
    }

    public static Class getRegisteredClass(QName qname) {
        return MessageContext.getCurrentContext().getTypeMapping().getClassForQName(qname);
    }

    public static List<File> recursiveListFiles(File baseDir, final FileFilter filter) {
        FileFilter dirFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || filter.accept(pathname);
            }
        };
        File[] fileArray = baseDir.listFiles(dirFilter);
        ArrayList<File> files = new ArrayList<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                files.addAll(Utils.recursiveListFiles(fileArray[i], filter));
                continue;
            }
            files.add(fileArray[i]);
        }
        return files;
    }

    public static String getRelativePath(File source, File destination) throws IOException {
        int overlapDirs;
        String sourceDir = null;
        String destDir = null;
        sourceDir = source.isDirectory() ? source.getCanonicalPath() : source.getParentFile().getCanonicalPath();
        String overlap = Utils.findOverlap(sourceDir, destDir = destination.isDirectory() ? destination.getCanonicalPath() : destination.getParentFile().getCanonicalPath());
        if (overlap.endsWith(File.separator)) {
            overlap = overlap.substring(0, overlap.length() - File.separator.length() - 1);
        }
        if ((overlapDirs = Utils.countChars(overlap, File.separatorChar)) == 0) {
            return destination.getCanonicalPath();
        }
        int parentDirsNeeded = Utils.countChars(sourceDir, File.separatorChar) - overlapDirs;
        int parentDirsKept = Utils.countChars(destDir, File.separatorChar) - overlapDirs;
        StringBuffer relPath = new StringBuffer();
        for (int i = 0; i < parentDirsNeeded; ++i) {
            relPath.append("..").append(File.separatorChar);
        }
        LinkedList<String> parentPaths = new LinkedList<String>();
        File parentDir = new File(destDir);
        for (int i = 0; i < parentDirsKept; ++i) {
            parentPaths.add(parentDir.getName());
            parentDir = parentDir.getParentFile();
        }
        Collections.reverse(parentPaths);
        Iterator i = parentPaths.iterator();
        while (i.hasNext()) {
            relPath.append(i.next()).append(File.separatorChar);
        }
        if (!destination.isDirectory()) {
            relPath.append(destination.getName());
        }
        return relPath.toString();
    }

    private static String findOverlap(String s1, String s2) {
        char c2;
        char c1;
        StringBuffer overlap = new StringBuffer();
        int count = Math.min(s1.length(), s2.length());
        for (int i = 0; i < count && (c1 = s1.charAt(i)) == (c2 = s2.charAt(i)); ++i) {
            overlap.append(c1);
        }
        return overlap.toString();
    }

    private static int countChars(String s, char c) {
        int count = 0;
        int index = -1;
        while ((index = s.indexOf(c, index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public static Object cloneBean(Object bean, QName qname) throws Exception {
        StringWriter writer = new StringWriter();
        Utils.serializeObject(bean, qname, writer);
        return Utils.deserializeObject(new StringReader(writer.getBuffer().toString()), bean.getClass());
    }
}

