/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.CountDown;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import gov.nih.nci.cagrid.common.Runner;
import gov.nih.nci.cagrid.common.RunnerGroup;

public class ThreadManager {
    private static int POOL_SIZE = 20;
    private PooledExecutor workerPool = new PooledExecutor((Channel)new LinkedQueue(), POOL_SIZE);

    public ThreadManager() {
        this.workerPool.setMinimumPoolSize(POOL_SIZE);
    }

    public void executeInBackground(Runner task) throws InterruptedException {
        this.workerPool.execute((Runnable)task);
    }

    public void execute(Runner task) throws InterruptedException {
        CountDown barrier = new CountDown(1);
        task.setSync((Sync)barrier);
        this.workerPool.execute((Runnable)task);
        barrier.acquire();
    }

    public void executeGroup(RunnerGroup group) throws InterruptedException {
        CountDown barrier = new CountDown(group.size());
        for (int i = 0; i < group.size(); ++i) {
            Runner task = group.get(i);
            task.setSync((Sync)barrier);
            this.workerPool.execute((Runnable)task);
        }
        barrier.acquire();
    }

    public void executeGroupInBackground(RunnerGroup group) throws InterruptedException {
        for (int i = 0; i < group.size(); ++i) {
            Runner task = group.get(i);
            this.workerPool.execute((Runnable)task);
        }
    }
}

