/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nci.cagrid.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StreamGobbler
extends Thread {
    public static final String TYPE_OUT = "OUT";
    public static final String TYPE_ERR = "ERR";
    private Logger logger = null;
    private Priority priority = null;
    private InputStream gobble;
    private String type;
    private PrintStream redirect;

    public StreamGobbler(InputStream is, String type) {
        this(is, type, null);
    }

    public StreamGobbler(InputStream is, String type, OutputStream redrirect) {
        this.gobble = is;
        this.type = type;
        if (redrirect != null) {
            this.redirect = new PrintStream(redrirect);
        }
    }

    public StreamGobbler(InputStream is, String type, Logger logger, Priority priority) {
        this.gobble = is;
        this.type = type;
        this.logger = logger;
        this.priority = priority;
    }

    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(this.gobble);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (this.redirect == null && (this.logger == null || this.priority == null)) continue;
                line = this.type + "> " + line;
                if (this.redirect != null) {
                    this.redirect.println(line);
                    continue;
                }
                this.logger.log(this.priority, (Object)line);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

